/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.listener;

import com.fe.client.ClientErrorMgmt;
import com.fe.p2p.MessageBean;
import com.fe.p2p.listener.OutgoingMessageCallBack;
import com.fe.p2p.msg.CommunicationTrace;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Logger;

public class OutgoingMessage
implements OutputPipeListener {
    private static int maxDebugErrCounter = 0;
    private OutgoingMessageCallBack omc = null;
    public static final String MESSAGE_NAME_SPACE = "PipeTaskMsg";
    private MessageBean smsg;
    private Logger log = Logger.getLogger(OutgoingMessage.class);
    private String destination = null;
    private boolean messageSent = false;
    private Map<String, String> attachments = null;

    public OutgoingMessage(OutgoingMessageCallBack outgoingMessageCallBack, MessageBean messageBean, String string) {
        this.omc = outgoingMessageCallBack;
        this.smsg = messageBean;
        this.destination = string;
        if (this.omc != null) {
            this.omc.setDestination(string);
        }
    }

    public void setAttachment(Map<String, String> map) {
        this.attachments = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputPipeEvent(OutputPipeEvent outputPipeEvent) {
        OutputPipe outputPipe = outputPipeEvent.getOutputPipe();
        if (this.omc != null) {
            this.omc.before(outputPipeEvent);
        }
        try {
            PipeAdvertisement pipeAdvertisement = outputPipe.getAdvertisement();
            Message message = new Message();
            StringMessageElement stringMessageElement = new StringMessageElement(MESSAGE_NAME_SPACE, this.getXML(this.smsg), null);
            message.addMessageElement(null, (MessageElement)stringMessageElement);
            if (this.attachments != null) {
                for (String object2 : this.attachments.keySet()) {
                    String i = this.attachments.get(object2);
                    if (i == null) continue;
                    StringMessageElement bl = new StringMessageElement(object2, i, null);
                    message.addMessageElement(null, (MessageElement)bl);
                }
            }
            int n = this.omc != null ? this.omc.numberOfTries : OutgoingMessageCallBack.PRIORITY_ZERO;
            Date date = new Date();
            for (int l = 0; l < n && !this.messageSent; ++l) {
                boolean bl = true;
                if (this.omc != null && !this.omc.validateBeforeSend()) {
                    bl = false;
                }
                if (this.omc == null || bl) {
                    this.messageSent = outputPipe.send(message);
                } else {
                    l = n;
                }
                this.log.debug((Object)("Msg:sent to client:getMessageElements:" + message.getMessageElements().toString() + " this.messageSent:" + this.messageSent));
                if (this.messageSent || !bl) continue;
                try {
                    Thread.sleep(50L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long l = new Date().getTime() - date.getTime();
            if (!this.messageSent && maxDebugErrCounter < 1000) {
                this.log.error((Object)("Message couldn't be sent to peer " + this.destination + " Tried:" + n + "times Took:" + l + "ms Msg:" + this.getXML(this.smsg)));
                ++maxDebugErrCounter;
            }
            if (this.messageSent && this.attachments != null) {
                new CommunicationTrace(this.destination).outgoing(this.attachments);
            }
            if (this.smsg != null) {
                // empty if block
            }
        }
        catch (IOException iOException) {
            ClientErrorMgmt.reportError(iOException, "To Peer:" + this.destination + " command:" + this.smsg.getCommand());
        }
        finally {
            if (this.omc != null) {
                this.omc.after(outputPipeEvent);
            }
            if (this.omc != null && !this.messageSent) {
                this.omc.onFail(outputPipeEvent, this.smsg, this.destination);
            }
        }
    }

    private String getXML(MessageBean messageBean) {
        String string = "<?xml version=\"1.0\"?><message>";
        string = string + "<sender>" + messageBean.getSender() + "</sender>";
        string = string + "<reply>" + messageBean.getReply() + "</reply>";
        string = string + "<type>" + messageBean.getType() + "</type>";
        string = string + "<command>" + messageBean.getCommand() + "</command>";
        string = string + "</message>";
        return string;
    }
}

