/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.msg;

import com.fe.p2p.MessageBean;
import com.fe.p2p.P2PAdvertisement;
import com.fe.p2p.P2PService;
import com.fe.p2p.listener.OutgoingMessage;
import com.fe.p2p.listener.OutgoingMessageCallBack;
import com.fe.p2p.msg.MessageHandler;
import com.fe.p2p.msg.MessageNames;
import com.fe.p2p.msg.PostCallBack;
import java.util.HashMap;
import java.util.Map;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class PostMessage {
    protected MessageHandler mha;
    protected String recipient = null;
    protected Logger log = Logger.getLogger(PostMessage.class);
    protected boolean callback = false;
    protected OutgoingMessageCallBack omc = null;

    public PostMessage(MessageHandler messageHandler, String string) {
        this.mha = messageHandler;
        this.recipient = string;
        this.omc = new OutgoingMessageCallBack(this){

            @Override
            public void onFail(OutputPipeEvent outputPipeEvent, MessageBean messageBean, String string) {
                if (this.getPostMessage().callback && this.getPostMessage().mha instanceof PostCallBack) {
                    ((PostCallBack)((Object)this.getPostMessage().mha)).onCallBackSendingFailed();
                } else {
                    this.getPostMessage().mha.onSendingFailed();
                }
            }
        };
        this.omc.setPriority(this.mha.getPriority());
    }

    public PostMessage(MessageHandler messageHandler, String string, OutgoingMessageCallBack outgoingMessageCallBack) {
        this.mha = messageHandler;
        this.recipient = string;
        this.omc = outgoingMessageCallBack;
    }

    public void setCallBack() {
        this.callback = true;
    }

    protected boolean getHelperAdvertKey() {
        return false;
    }

    public void send() {
        try {
            PeerGroup peerGroup = P2PService.getPeerGroup();
            PipeAdvertisement pipeAdvertisement = new P2PAdvertisement().getPipeAdvertisement(this.recipient, peerGroup);
            MessageBean messageBean = new MessageBean();
            messageBean.setReply(MessageBean.REPLYBACK);
            messageBean.setType(MessageBean.TYPE_REQUEST);
            OutgoingMessage outgoingMessage = new OutgoingMessage(this.omc, messageBean, this.recipient);
            HashMap hashMap = new HashMap();
            this.mha.setMsgCreator(P2PService.getComputerName());
            this.mha.setMsgRecipient(this.recipient);
            Map map = BeanUtils.describe((Object)this.mha);
            if (this.callback) {
                map.put(MessageNames.MESSAGE_TYPE_CALLBACK, MessageNames.MESSAGE_TYPE_CALLBACK);
            }
            map.put(MessageNames.MESSAGE_BEAN_NAME, this.mha.getClass().getName());
            HashMap hashMap2 = new HashMap();
            hashMap2.putAll(map);
            hashMap2.remove("msgCreator");
            hashMap2.remove("responseJSON");
            hashMap2.remove("priority");
            hashMap2.remove("class");
            hashMap2.remove("__msgBeanName__");
            hashMap2.remove("taskuid");
            this.log.debug((Object)("~~~~~~ PostMessage:class:" + this.mha.getClass().getName() + " to:" + this.recipient + ":data:" + hashMap2));
            outgoingMessage.setAttachment(map);
            PipeService pipeService = P2PService.getPipeService();
            try {
                pipeService.createOutputPipe(pipeAdvertisement, (OutputPipeListener)outgoingMessage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                PipeService pipeService2 = P2PService.getNewPipeService();
                try {
                    pipeService2.createOutputPipe(pipeAdvertisement, (OutputPipeListener)outgoingMessage);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                }
                pipeService2 = null;
            }
            peerGroup = null;
            pipeAdvertisement = null;
            messageBean = null;
            this.omc = null;
            outgoingMessage = null;
            map = null;
            pipeService = null;
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }
}

