/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.msg.scheduler;

import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.db.SchedulerDB;
import com.fe.p2p.listener.OutgoingMessageCallBack;
import com.fe.p2p.listener.P2PPipeLog;
import com.fe.p2p.msg.PostCallBack;
import com.fe.p2p.msg.PostMessage;
import com.fe.p2p.msg.scheduler.PeerFinishedTask;
import com.fe.p2p.msg.scheduler.PeerOnlineStatus;
import com.fe.p2p.msg.scheduler.TaskMessage;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.StackFrameCallBack;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.exception.ExceptionPeerRejected;
import com.fe.scheduler.exception.ExceptionPeerUnknown;
import com.fe.scheduler.exception.SchedulerException;
import com.fe.scheduler.group.RScriptScheduledTask;
import com.fe.scheduler.peer.QueueAbstract;
import com.fe.scheduler.peer.QueueFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class SendTask
extends TaskMessage
implements PostCallBack {
    private Logger log = Logger.getLogger(SendTask.class);
    private String started_time;
    private static String EXCEPTION_CLASS_NAME = "exception_class";
    private static String EXCEPTION_CLASS_MESSAGE = "exception_message";
    private static Semaphore slock = new Semaphore(1, true);
    private static final long TIMEOUT_MS = 1000L;

    public String getStarted_time() {
        return this.started_time;
    }

    public void setStarted_time(String string) {
        this.started_time = string;
    }

    private void acquireLock() {
        try {
            slock.tryAcquire(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    private void releaseLock() {
        try {
            slock.release();
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Map executeAtDestination() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        try {
            n = Integer.parseInt(this.getScheduler_id());
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l = 0L;
        try {
            l = Long.parseLong(this.getTrigger_time());
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l2 = 0L;
        try {
            l2 = Long.parseLong(this.getNext_trigger_time());
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l3 = 0L;
        try {
            l3 = Long.parseLong(this.getStarted_time());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n > 0 && l > 0L) {
            new SchedulerExePlanLogs(n, l).log("peer.sendtask.received", new HashMap(), 5007);
        }
        this.log.debug((Object)("got task: sc_id:" + n + " tri_time:" + l + " uid:" + this.getTaskuid()));
        QueueFactory queueFactory = new QueueFactory();
        QueueAbstract queueAbstract = queueFactory.getQueue(this.getTaskuid());
        SchedulerException schedulerException = null;
        try {
            this.acquireLock();
            if (!queueAbstract.isRoomForThread()) {
                throw new ExceptionPeerRejected(null);
            }
            if (n < 0) {
                throw new ExceptionPeerUnknown("sc_id: not found");
            }
            String string = this.getMsgCreator();
            this.executeTask(n, l, l2, l3, string);
            hashMap.putAll(queueFactory.getExecutingIDAndSTimes());
            this.releaseLock();
        }
        catch (ExceptionPeerRejected exceptionPeerRejected) {
            schedulerException = exceptionPeerRejected;
            hashMap.put("failed", "YES");
            if (n > 0 && l > 0L) {
                new SchedulerExePlanLogs(n, l).log("peer.sendtask.noroom2execute", new HashMap(), 7000);
            }
        }
        catch (SchedulerException schedulerException2) {
            schedulerException = schedulerException2;
            hashMap.put("failed", "YES");
            if (n > 0 && l > 0L) {
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                hashMap2.put("error_message", schedulerException2.getMessage());
                new SchedulerExePlanLogs(n, l).log("peer.sendtask.unknown", hashMap2, 6000);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new SchedulerExePlanLogs(n, l).log("Error caught at SendTask.executeAtDestination(), Error:" + exception.getMessage(), 6000);
        }
        finally {
            if (schedulerException != null) {
                this.exception(schedulerException);
                this.setPriority(OutgoingMessageCallBack.PRIORITY_VERY_VERY_HIGH);
                hashMap.put(EXCEPTION_CLASS_NAME, schedulerException.getExceptionclass());
                hashMap.put(EXCEPTION_CLASS_MESSAGE, schedulerException.getMessage());
            }
        }
        return hashMap;
    }

    @Override
    public synchronized void callBack(Map map) {
        this.log.debug((Object)"****SendTask**** callback");
        String string = this.getMsgCreator();
        if (map != null && map.get("failed") != null && ((String)map.get("failed")).equalsIgnoreCase("YES")) {
            int n = 0;
            try {
                n = Integer.parseInt(this.getScheduler_id());
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l = 0L;
            try {
                l = Long.parseLong(this.getTrigger_time());
            }
            catch (Exception exception) {
                // empty catch block
            }
            P2PPipeLog.receiveMsg("Received failed Msg:Schduler ID:" + this.getScheduler_id() + " Trigger Time:" + this.getTrigger_time(), string);
            if (n > 0 && l > 0L) {
                new SchedulerExePlanLogs(n, l).log("Sent task bounced back at the server, looking for another peer", 4002);
            }
            if (n > 0) {
                LoadBalancingQueue.getDefault().executionFailed(n, l, string);
                LoadBalancingQueue.getDefault().releasePeersCache4PriorityGr();
            }
        } else if (map.size() > 0) {
            int n = 0;
            try {
                n = Integer.parseInt(this.getScheduler_id());
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l = 0L;
            try {
                l = Long.parseLong(this.getTrigger_time());
            }
            catch (Exception exception) {
                // empty catch block
            }
            P2PPipeLog.receiveMsg("Task Execution Started confirmation Schduler ID:" + this.getScheduler_id() + " Trigger Time:" + this.getTrigger_time(), string);
            this.log.debug((Object)"peer queue data received");
            PeerOnlineStatus peerOnlineStatus = new PeerOnlineStatus();
            peerOnlineStatus.setStatus("BUSY");
            peerOnlineStatus.updatePeerStatus(map, string);
            if (n > 0 && l > 0L) {
                try {
                    LoadBalancingQueue.getDefault().peerStarted(n, l, string);
                    new SchedulerExePlanLogs(n, l).log("Peer accepted task and responded server ", 2003);
                }
                catch (Exception exception) {
                    this.log.error((Object)("callBack(), Error:" + exception.getMessage()));
                }
            }
        }
    }

    private synchronized void executeTask(int n, long l, long l2, long l3, String string) throws Exception, SchedulerException, ExceptionPeerRejected {
        block15: {
            SchedulerDB schedulerDB = null;
            try {
                Object object;
                Object object2;
                Object object3;
                schedulerDB = SchedulerDB.getSchedulerDB();
                Map<String, String> map = new HashMap();
                try {
                    schedulerDB.connectDB(BBSyncMgmt.getDBName());
                    map = schedulerDB.getScheduler(n);
                }
                catch (Exception exception) {
                    throw new ExceptionPeerRejected("Error while accessing database, Error:" + exception.getMessage());
                }
                String string2 = (String)map.get("taskuid");
                if (map.get("rscript") != null) {
                    object3 = n + "_" + l;
                    object2 = "";
                    try {
                        object2 = schedulerDB.getInjectCode4QLog((String)object3);
                    }
                    catch (Exception exception) {
                        throw new ExceptionPeerRejected("Error while accessing database, Error:" + exception.getMessage());
                    }
                    object = (String)map.get("rscript_param");
                    String string3 = (String)map.get("rscript");
                    String string4 = RScriptScheduledTask.codeInjectConcatenate((String)object, string3, (String)object2);
                    map.put("rscript", string4);
                }
                object3 = new ScheduledTaskFactory().getTaskFromAll(string2);
                object2 = new StackFrame((ScheduledTask)object3, map);
                ((StackFrame)object2).setTrigger_time(l);
                ((StackFrame)object2).setNexttrigger_time(l2);
                ((StackFrame)object2).setReplyTo(string);
                ((StackFrame)object2).setStarted_time(l3);
                if (map.get("rscript") != null) {
                    ((StackFrame)object2).setExecuted_code((String)map.get("rscript"));
                }
                ((StackFrame)object2).addCallBack(new StackFrameCallBack(){

                    @Override
                    public void callBack(StackFrame stackFrame, String string, SchedulerException schedulerException) {
                        Number number = (Number)stackFrame.getData().get("id");
                        new SchedulerExePlanLogs(number.intValue(), stackFrame.getTrigger_time()).log("Task completed, Reply server, STATUS:" + string, 5008);
                        PeerFinishedTask peerFinishedTask = new PeerFinishedTask();
                        peerFinishedTask.exception(schedulerException);
                        peerFinishedTask.setPriority(OutgoingMessageCallBack.PRIORITY_VERY_VERY_HIGH);
                        peerFinishedTask.setScheduler_id(SendTask.this.getScheduler_id());
                        peerFinishedTask.setTrigger_time(SendTask.this.getTrigger_time());
                        peerFinishedTask.setTaskuid(SendTask.this.getTaskuid());
                        peerFinishedTask.setStatus(string);
                        SendTask.this.log.debug((Object)("reply to :" + stackFrame.getReplyTo()));
                        new PostMessage(peerFinishedTask, stackFrame.getReplyTo()).send();
                    }
                });
                object = new QueueFactory().getQueue(string2);
                if (((QueueAbstract)object).isRoomForThread()) {
                    ((QueueAbstract)object).addExThread((StackFrame)object2);
                    break block15;
                }
                throw new ExceptionPeerRejected(null);
            }
            catch (ExceptionPeerRejected exceptionPeerRejected) {
                ClientErrorMgmt.reportError(exceptionPeerRejected, "ExceptionPeerRejected..");
                throw exceptionPeerRejected;
            }
            catch (SchedulerException schedulerException) {
                ClientErrorMgmt.reportError(schedulerException, "SchedulerException..");
                throw schedulerException;
            }
            catch (Exception exception) {
                ClientErrorMgmt.reportError(exception, "Exception");
                throw exception;
            }
            finally {
                if (schedulerDB != null) {
                    schedulerDB.closeDB();
                }
            }
        }
    }

    @Override
    public void onCallBackSendingFailed() {
    }

    @Override
    public void onSendingFailed() {
    }
}

