/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.msg.scheduler.rserve;

import com.fe.json.JSONObject;
import com.fe.p2p.msg.MessageHandler;
import com.fe.p2p.msg.PostCallBack;
import com.fe.scheduler.rserve.RServeConnectionPool;
import com.fe.scheduler.rserve.RServeSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;

public class RServeSessionStat
extends MessageHandler
implements PostCallBack {
    private Logger log = Logger.getLogger(RServeSessionStat.class);
    private static JCS cache = null;

    @Override
    public Map executeAtDestination() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<RServeSession> list = RServeConnectionPool.getAllSessions();
        ArrayList arrayList = new ArrayList();
        for (RServeSession rServeSession : list) {
            try {
                int n = rServeSession.getProcessid();
                Process process = Runtime.getRuntime().exec("ps -p " + n + " -o %cpu,%mem --no-header");
                String string = this.processOutput(process);
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                JSONObject jSONObject = new JSONObject();
                if (stringTokenizer.countTokens() >= 2) {
                    jSONObject.put("CPU", stringTokenizer.nextToken());
                    jSONObject.put("Memeory", stringTokenizer.nextToken());
                    jSONObject.put("scheduler_id", rServeSession.getScheduler_id());
                    jSONObject.put("trigger_time", rServeSession.getTrigger_time());
                    jSONObject.put("no_executions", rServeSession.getNoexecutions());
                    jSONObject.put("process_id", n);
                    jSONObject.put("scriptname", rServeSession.getScriptname());
                    jSONObject.put("uid", rServeSession.getUid());
                    hashMap.put(rServeSession.getUid(), jSONObject.toString());
                    continue;
                }
                this.log.error((Object)("error, the process doesn't exisit and removing process id:" + n + " from connection pool"));
                RServeConnectionPool.remove(rServeSession);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashMap;
    }

    private String processOutput(Process process) throws Exception {
        String string;
        InputStream inputStream = process.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        int n = 0;
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            string2 = string2 + (string2.equals("") ? string : "|" + string);
            ++n;
        }
        return string2;
    }

    @Override
    public void callBack(Map map) {
        try {
            IElementAttributes iElementAttributes = RServeSessionStat.getCache().getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds(5L);
            RServeSessionStat.getCache().put((Object)("peer_" + this.getMsgCreator()), (Object)map, iElementAttributes);
        }
        catch (Exception exception) {
            this.log.error((Object)("error,e:" + exception.getMessage()));
        }
    }

    public static Map getPeerCachedStat(String string) throws Exception {
        Map map = (Map)RServeSessionStat.getCache().get((Object)("peer_" + string));
        return map;
    }

    private static JCS getCache() throws Exception {
        if (cache == null) {
            cache = JCS.getInstance((String)RServeSessionStat.class.getName());
        }
        return cache;
    }

    @Override
    public void onCallBackSendingFailed() {
    }

    @Override
    public void onSendingFailed() {
    }
}

