/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler;

import com.fe.Config;
import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.MigrationMgmt;
import com.fe.connectbl.ConnectBloomberg;
import com.fe.data.Contract;
import com.fe.db.BBSyncDB;
import com.fe.db.ContractDB;
import com.fe.db.InfrastructureDB;
import com.fe.db.SuperDB;
import com.fe.migrate.historical.HistoricalMarketData;
import com.fe.migrate.historical.HistoricalSecuritiesData;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.exception.ExceptionWarningNoFullData;
import com.fe.util.InputStringTokenParser;
import java.io.File;
import java.io.FileWriter;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class BloombergDownloadJob
implements Job {
    private Logger log = Logger.getLogger(BloombergDownloadJob.class);
    public static String BB_DOWNLOAD_GROUP = "BB_DOWNLOAD_GROUP";
    private Vector<String> uniqueContracts = new Vector();
    private boolean invokedByUser = true;
    private String schedulerLog = null;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.invokedByUser = false;
        Map map = (Map)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"data");
        int n = (Integer)map.get("id");
        String string = (String)map.get("name");
        Date date = new Date();
    }

    public void setInvokedByScheduler() {
        this.invokedByUser = false;
    }

    public void rescheduleJobs(long l) throws Exception {
    }

    private String checkCommoditySpecified(String string, Map map, HashMap<String, String> hashMap) {
        String string2 = null;
        Pattern pattern = Pattern.compile("^(.*?)->(.*?)$");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string = matcher.group(1);
            String string3 = matcher.group(2);
            if (string3 != null) {
                String string4 = string;
                if (string4.indexOf("{") >= 0 && string4.indexOf("}") > 0) {
                    String string5 = string4.substring(string4.indexOf("{") + 1, string4.indexOf("}"));
                    string4 = string4.replaceAll("\\{" + string5 + "\\}", "");
                }
                hashMap.put(string4, string3);
            }
        }
        if (string.indexOf("{") >= 0 && string.indexOf("}") > 0) {
            string2 = string.substring(string.indexOf("{") + 1, string.indexOf("}"));
            string = string.replaceAll("\\{" + string2 + "\\}", "");
            map.put(string, string2);
        }
        return string;
    }

    private ArrayList<ArrayList<String>> splitTickers(ArrayList<String> arrayList, int n) {
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        if (arrayList.size() > n) {
            arrayList2.add(new ArrayList());
            for (String string : arrayList) {
                if (arrayList2.get(arrayList2.size() - 1).size() > n) {
                    arrayList2.add(new ArrayList());
                }
                arrayList2.get(arrayList2.size() - 1).add(string);
            }
        } else {
            arrayList2.add(arrayList);
        }
        return arrayList2;
    }

    public synchronized void downloadData(Map map, StackFrame stackFrame) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        int n2 = ((Number)stackFrame.getData().get("id")).intValue();
        long l = stackFrame.getTrigger_time();
        Timestamp timestamp = new Timestamp(new Date().getTime());
        TreeMap treeMap = new TreeMap();
        this.processDate(map);
        String string = (String)map.get("date_from");
        String string2 = (String)map.get("date_to");
        String string3 = (String)map.get("marketsector");
        String string4 = (String)map.get("tickers");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new InputStringTokenParser(string4).parseFreeTextTokens();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (String string5 : arrayList2) {
            arrayList.add(this.checkCommoditySpecified(string5, hashMap, hashMap2));
        }
        BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
        bBSyncDB.connectDB(BBSyncMgmt.getDBName());
        int n3 = (Integer)map.get("id");
        ArrayList arrayList3 = bBSyncDB.fieldMapping4BBSync(n3);
        for (n = 0; n < arrayList3.size(); n += 1) {
            object4 = (Map)arrayList3.get(n);
            treeMap.put(object4.get("bb_field"), object4.get("db_field"));
        }
        bBSyncDB.closeDB();
        this.log.debug((Object)("date_from:" + string));
        this.log.debug((Object)("date_to:" + string2));
        this.log.debug((Object)("market sector:" + string3));
        this.log.debug((Object)("fields:" + treeMap.keySet()));
        this.log.debug((Object)("db fields:" + treeMap.values()));
        this.log.debug((Object)("tickers:" + arrayList));
        n = 0;
        if (map.get("is_mkt_securitydb") != null && ((String)map.get("is_mkt_securitydb")).toLowerCase().equals("true")) {
            n = 1;
        }
        object4 = new ArrayList(treeMap.keySet());
        if (string != null && string2 != null && string3 != null && ((ArrayList)object4).size() > 0 && arrayList.size() > 0) {
            object3 = this.splitTickers(arrayList, 100);
            object2 = ((ArrayList)object3).iterator();
            while (object2.hasNext()) {
                object = object2.next();
                new SchedulerExePlanLogs(n2, l).log("# of tickers in this request:" + ((ArrayList)object).size(), 5000);
                TreeMap treeMap2 = new ConnectBloomberg((List)object, string, string2, (List)object4, string3, new MigrationMgmt(), true).getMultipleData();
                this.processBBData(null, treeMap2, n != 0, treeMap, (ArrayList)object, hashMap, hashMap2);
                this.processBBData(string3, treeMap2, n != 0, treeMap, (ArrayList)object, hashMap, hashMap2);
            }
        }
        this.log.debug((Object)("unique contracts:" + this.uniqueContracts));
        bBSyncDB.closeDB();
        object3 = BBSyncDB.getBBSyncDB();
        ((SuperDB)object3).connectDB(BBSyncMgmt.getDBName());
        if (this.uniqueContracts.size() > 0 && !n) {
            object2 = new Timestamp(new Date().getTime());
            ((BBSyncDB)object3).updateContractLogs(this.uniqueContracts, string3, (Timestamp)object2, hashMap, treeMap.values());
        } else if (this.uniqueContracts.size() > 0 && n) {
            object2 = new Timestamp(new Date().getTime());
            ((BBSyncDB)object3).updateSecuritiesLogs(this.uniqueContracts, string3, (Timestamp)object2, treeMap.values());
        }
        object2 = new SimpleDateFormat("yyyy-MM-dd");
        ((DateFormat)object2).setTimeZone(TimeZone.getTimeZone("Asia/Tokyo"));
        object = ((DateFormat)object2).format(new Date());
        int n4 = this.uniqueContracts.size() * treeMap.keySet().size();
        InfrastructureDB infrastructureDB = InfrastructureDB.getInfrastructureDB();
        infrastructureDB.connectDB(Config.getString("db_infrastructure_name"));
        if (n4 > 0) {
            infrastructureDB.updateBloomberDailyCounter((String)object, n4);
        }
        infrastructureDB.closeDB();
        this.log.debug((Object)"after updated unique tickers on ref database");
        Timestamp timestamp2 = new Timestamp(new Date().getTime());
        ((BBSyncDB)object3).updateTriggeredDate(n3, timestamp, timestamp2);
        Date date = (Date)map.get("date_from_date");
        Date date2 = (Date)map.get("date_to_date");
        String string6 = (String)map.get("name");
        this.log.debug((Object)"writting external log");
        this.externalLog(n3, string6, timestamp, timestamp2, date, date2, this.uniqueContracts.size(), true, (BBSyncDB)object3);
        ((SuperDB)object3).closeDB();
        this.schedulerLog = "";
        this.log.debug((Object)"writting scheduler logs");
        this.schedulerLog = this.schedulerLog + "Date Between " + new SimpleDateFormat("dd-MMM-yy").format(date) + " and " + new SimpleDateFormat("dd-MMM-yy").format(date2);
        this.schedulerLog = this.schedulerLog + "\nNo of Tickers Requested:" + arrayList.size();
        this.schedulerLog = this.schedulerLog + "\nNo of Tickers Responded:" + this.uniqueContracts.size();
        String string7 = null;
        for (String string8 : arrayList) {
            if (string8 == null || string8.equals("") || this.uniqueContracts.indexOf(string8) >= 0) continue;
            string7 = string7 == null ? string8 : string7 + "\n" + string8;
        }
        if (string7 != null) {
            this.schedulerLog = this.schedulerLog + "\nNo data found for the following tickers:\n" + string7;
            throw new ExceptionWarningNoFullData("No data found for some tickers  ");
        }
        this.schedulerLog = null;
        this.log.debug((Object)"--------------end of downloadData() -----------------------");
    }

    public String getSchedulerLog() {
        return this.schedulerLog;
    }

    private synchronized void processBBData(String string, Map map, boolean bl, Map map2, ArrayList arrayList, Map<String, String> map3, HashMap<String, String> hashMap) throws Exception {
        Vector vector;
        Object object;
        Object object22;
        Object object3;
        Object object4;
        Vector<String> vector2 = new Vector<String>();
        for (String string2 : map.keySet()) {
            Vector vector3;
            String string3;
            object4 = (Vector)map.get(string2);
            object3 = new TreeMap();
            Object object5 = null;
            object5 = bl ? new HistoricalSecuritiesData(new MigrationMgmt()).getDB() : new HistoricalMarketData(new MigrationMgmt()).getDB();
            this.log.debug((Object)("Processing: Commodity or security:fdata.size():" + ((Vector)object4).size()));
            Iterator iterator2 = ((Vector)object4).iterator();
            while (iterator2.hasNext()) {
                object22 = (Contract)iterator2.next();
                object = null;
                object = bl ? (map3.keySet().contains(((Contract)object22).getName()) ? map3.get(((Contract)object22).getName()) : ((Contract)object22).getName().trim()) : (map3.keySet().contains(((Contract)object22).getName()) ? map3.get(((Contract)object22).getName()) : ((Contract)object22).getName().substring(0, 2));
                if (this.uniqueContracts.indexOf(((Contract)object22).getName().trim()) < 0) {
                    this.uniqueContracts.add(((Contract)object22).getName().trim());
                }
                if (((TreeMap)object3).get(object) != null) {
                    vector = (Vector)((TreeMap)object3).get(object);
                } else {
                    vector = new Vector();
                    ((TreeMap)object3).put(object, vector);
                }
                vector.add(object22);
                if (!bl && hashMap.containsKey(((Contract)object22).getName())) {
                    string3 = hashMap.get(((Contract)object22).getName());
                    vector3 = (Contract)BeanUtils.cloneBean((Object)object22);
                    ((Contract)((Object)vector3)).setName(string3);
                    vector.add(vector3);
                }
                if (!bl || !hashMap.containsKey(((Contract)object22).getName())) continue;
                string3 = hashMap.get(((Contract)object22).getName());
                if (((TreeMap)object3).get(string3) != null) {
                    vector3 = (Vector)((TreeMap)object3).get(string3);
                } else {
                    vector3 = new Vector();
                    ((TreeMap)object3).put(string3, vector3);
                }
                Contract contract = (Contract)BeanUtils.cloneBean((Object)object22);
                contract.setName(string3);
                vector3.add(contract);
            }
            this.log.debug((Object)("Processing: Field:" + string2));
            for (Object object22 : ((TreeMap)object3).keySet()) {
                object = (Vector)((TreeMap)object3).get(object22);
                vector = (String)map2.get(string2);
                string3 = null;
                string3 = string != null && !string.equals("") ? HistoricalMarketData.resolvedColNameNoTrim((String)object22) + "_" + string.toLowerCase() + "_" + HistoricalMarketData.resolvedColName((String)((Object)vector)) : HistoricalMarketData.resolvedColNameNoTrim((String)object22) + "_" + HistoricalMarketData.resolvedColName((String)((Object)vector));
                vector2.add(string3);
                vector3 = new SuperDB().getContractDB(string3, (String)object5);
                ((SuperDB)((Object)vector3)).connectDB((String)object5);
                if (string != null && !string.equals("")) {
                    ((ContractDB)((Object)vector3)).updateMasterTable(((SuperDB)((Object)vector3)).connection(), (String)object22 + " " + string, (String)((Object)vector));
                } else {
                    ((ContractDB)((Object)vector3)).updateMasterTable(((SuperDB)((Object)vector3)).connection(), (String)object22, (String)((Object)vector));
                }
                ((ContractDB)((Object)vector3)).createTable(((SuperDB)((Object)vector3)).connection(), 8);
                ((ContractDB)((Object)vector3)).updateRecords(((SuperDB)((Object)vector3)).connection(), (Vector)object);
                ((SuperDB)((Object)vector3)).closeDB();
            }
        }
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string2;
            string2 = "";
            object4 = (String)iterator.next();
            object3 = null;
            if (bl) {
                string2 = map3.keySet().contains(((String)object4).trim()) ? map3.get(((String)object4).trim()) : ((String)object4).trim();
                object3 = new HistoricalSecuritiesData(new MigrationMgmt()).getDB();
            } else {
                string2 = map3.keySet().contains(((String)object4).trim()) ? map3.get(((String)object4).trim()) : ((String)object4).substring(0, 2);
                object3 = new HistoricalMarketData(new MigrationMgmt()).getDB();
            }
            for (Iterator iterator2 : map2.keySet()) {
                object22 = (String)map2.get(iterator2);
                object = HistoricalMarketData.resolvedColNameNoTrim(string2) + "_" + HistoricalMarketData.resolvedColName((String)object22);
                if (vector2.indexOf(object) >= 0) continue;
                vector = new SuperDB().getContractDB((String)object, (String)object3);
                ((SuperDB)((Object)vector)).connectDB((String)object3);
                ((ContractDB)((Object)vector)).updateMasterTable(((SuperDB)((Object)vector)).connection(), string2, (String)object22);
                ((ContractDB)((Object)vector)).createTable(((SuperDB)((Object)vector)).connection(), 8);
                ((SuperDB)((Object)vector)).closeDB();
            }
        }
    }

    private void processDate(Map map) {
        Comparable<Calendar> comparable;
        String string = (String)map.get("date_option");
        int n = (Integer)map.get("date_recentnumber");
        Date date = null;
        Date date2 = null;
        try {
            if (map.get("date_from") instanceof Date) {
                date = (Date)map.get("date_from");
            } else {
                this.log.error((Object)"date_from is not date instance");
            }
            if (map.get("date_to") instanceof Date) {
                date2 = (Date)map.get("date_to");
            } else {
                this.log.error((Object)"date_to is not date instance");
            }
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "Error while parsing date, download ID:" + map.get("id"));
        }
        if (!string.toLowerCase().equals("daterange")) {
            if (string.toLowerCase().equals("datefrom")) {
                date2 = new Date();
            } else {
                date2 = new Date();
                date = null;
                comparable = Calendar.getInstance();
                ((Calendar)comparable).setTime(date2);
                boolean bl = false;
                if (string.toLowerCase().equals("ndays")) {
                    ((Calendar)comparable).add(6, -(n - 1));
                    bl = true;
                } else if (string.toLowerCase().equals("nweeks")) {
                    ((Calendar)comparable).add(3, -n);
                    bl = true;
                } else if (string.toLowerCase().equals("nmonths")) {
                    ((Calendar)comparable).add(2, -n);
                    bl = true;
                } else if (string.toLowerCase().equals("nyears")) {
                    ((Calendar)comparable).add(1, -n);
                    bl = true;
                }
                if (bl) {
                    date = ((Calendar)comparable).getTime();
                }
            }
        }
        if (date != null) {
            map.put("date_from", new SimpleDateFormat("yyyyMMdd").format(date));
            map.put("date_from_date", date);
        }
        if (date2 != null) {
            if (map.get("enddt_adjustment") != null) {
                comparable = (Integer)map.get("enddt_adjustment");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date2);
                calendar.add(6, (Integer)comparable);
                map.put("date_to", new SimpleDateFormat("yyyyMMdd").format(calendar.getTime()));
                map.put("date_to_date", calendar.getTime());
            } else {
                map.put("date_to", new SimpleDateFormat("yyyyMMdd").format(date2));
                map.put("date_to_date", date2);
            }
        }
    }

    private void externalLog(int n, String string, Date date, Date date2, Date date3, Date date4, long l, boolean bl, BBSyncDB bBSyncDB) {
        String string2;
        File file;
        boolean bl2 = true;
        boolean bl3 = false;
        String string3 = Config.getString("log_error_folder");
        Date date5 = new Date();
        String string4 = string3 + "bloomberg_sync";
        if (!new File(string4).isDirectory()) {
            new File(string4).mkdirs();
        }
        if (!(file = new File(string2 = string3 + "bloomberg_sync" + File.separator + "" + new SimpleDateFormat("dd_MM_yyyy").format(date5) + ".csv")).exists()) {
            try {
                FileWriter fileWriter = new FileWriter(file, true);
                fileWriter.append("Date, Time, Duration(mins), Period, # of Tickers, Manual/Scheduler, Status, ID, Download Name \r\n");
                fileWriter.flush();
                fileWriter.close();
            }
            catch (Exception exception) {
                this.log.error((Object)("error while creating file: Error:" + exception.getMessage()));
            }
        }
        try {
            boolean bl4 = true;
            FileWriter fileWriter = new FileWriter(file, bl4);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("h:mm a");
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("mm:ss");
            simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("GMT"));
            SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("dd MMM-yy");
            String string5 = "";
            string5 = string5 + simpleDateFormat3.format(date) + ",";
            string5 = string5 + simpleDateFormat.format(date) + ",";
            long l2 = date2.getTime() - date.getTime();
            string5 = string5 + simpleDateFormat2.format(new Date(l2)) + ",";
            long l3 = 86400000L;
            long l4 = (date4.getTime() - date3.getTime()) / l3;
            string5 = string5 + (Math.round(l4) + 1) + " days from " + simpleDateFormat3.format(date3) + ",";
            string5 = string5 + l + ",";
            string5 = string5 + (this.invokedByUser ? "Manual" : "Scheduler") + ",";
            string5 = string5 + (bl == bl2 ? "Success" : "Failed") + ",";
            string5 = string5 + n + ",";
            string5 = string5 + string + ",";
            fileWriter.append(string5 + "\r\n");
            fileWriter.flush();
            fileWriter.close();
            bBSyncDB.addSyncLogs(n, new Timestamp(date.getTime()), new Timestamp(date2.getTime()), null, bl ? "Success" : "Failed", this.invokedByUser ? "M" : "S");
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
            ClientErrorMgmt.reportError(exception, "Error in external log file writing");
        }
    }
}

