/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler;

import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskField;
import com.fe.scheduler.StackFrame;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionException;

public class MyTestScheduledTask
extends ScheduledTask {
    private Logger log = Logger.getLogger(MyTestScheduledTask.class);

    public MyTestScheduledTask() {
        super("My Test Task", "mytask");
        try {
            this.addFormFields(this.getMyFields());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public synchronized void execute(StackFrame stackFrame) throws JobExecutionException {
        this.log.debug((Object)("task has been executed: data:" + stackFrame.getData()));
        this.wait(20);
    }

    private void wait(int n) {
        long l;
        long l2 = System.currentTimeMillis();
        while ((l = System.currentTimeMillis()) - l2 < (long)(n * 1000)) {
        }
    }

    private Vector<ScheduledTaskField> getMyFields() {
        Vector<ScheduledTaskField> vector = new Vector<ScheduledTaskField>();
        ScheduledTaskField scheduledTaskField = new ScheduledTaskField();
        scheduledTaskField.setShortname("selectoption");
        scheduledTaskField.setFieldlabel("Select Option");
        scheduledTaskField.setFieldtype("dropdown");
        scheduledTaskField.setFieldoptions("1~Option1|2~Option2|3~Option3");
        ScheduledTaskField scheduledTaskField2 = new ScheduledTaskField();
        scheduledTaskField2.setShortname("type");
        scheduledTaskField2.setFieldlabel("Type");
        scheduledTaskField2.setFieldtype("radio");
        scheduledTaskField2.setFieldoptions("Securities|Contract");
        ScheduledTaskField scheduledTaskField3 = new ScheduledTaskField();
        scheduledTaskField3.setShortname("emailme");
        scheduledTaskField3.setFieldlabel("Email Me");
        scheduledTaskField3.setFieldtype("checkbox");
        ScheduledTaskField scheduledTaskField4 = new ScheduledTaskField();
        scheduledTaskField4.setShortname("comments");
        scheduledTaskField4.setFieldlabel("Comments");
        scheduledTaskField4.setFieldtype("textarea");
        vector.add(scheduledTaskField);
        vector.add(scheduledTaskField2);
        vector.add(scheduledTaskField3);
        vector.add(scheduledTaskField4);
        return vector;
    }
}

