/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.balance.executeR;

import com.fe.client.ClientErrorMgmt;
import com.fe.io.request.IOExcecutors;
import com.fe.json.JSONObject;
import com.fe.p2p.websocket.TomcatWSServer;
import com.fe.scheduler.balance.executeR.LoadBalancingExecuteRQueue;
import com.fe.scheduler.balance.executeR.NIOGroupQueue;
import com.fe.scheduler.rscript.RScript;
import com.fe.scheduler.rscript.RScriptListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;

public class LoadBalancingNewExecuteRQueue
extends LoadBalancingExecuteRQueue {
    private Logger log = Logger.getLogger(LoadBalancingNewExecuteRQueue.class);

    @Override
    public synchronized void addExecuteR(RScript rScript, RScriptListener rScriptListener) throws Exception {
        this.log.debug((Object)("adding script:" + rScript.getScript() + " uid:" + rScript.getUid()));
        rScript.setExecuting(false);
        rScript.setQueued_time(new Date().getTime());
        String string = this.getGroupUid(rScript);
        NIOGroupQueue nIOGroupQueue = NIOGroupQueue.getGroupInstance(string);
        boolean bl = false;
        RScript rScript2 = null;
        for (RScript rScript3 : nIOGroupQueue.getScriptQueue()) {
            if (!rScript3.getUniquename().equals(rScript.getUniquename())) continue;
            rScript2 = rScript3;
        }
        if (rScript2 != null) {
            this.log.debug((Object)("script id:" + rScript.getUid() + " existing"));
            rScript2.setScript(rScript.getScript());
            nIOGroupQueue.getCache().remove((Object)rScript.getUid());
        } else {
            nIOGroupQueue.getScriptQueue().add(rScript);
            NIOGroupQueue.scriptQueueVec.add(rScript);
            if (rScriptListener != null) {
                nIOGroupQueue.getScriptQueueListener().put(rScript.getUid(), rScriptListener);
            }
            bl = true;
        }
        IElementAttributes iElementAttributes = nIOGroupQueue.getCache().getDefaultElementAttributes();
        iElementAttributes.setMaxLifeSeconds((long)CACHE_GROUP_EXPIRY);
        nIOGroupQueue.getCache().put((Object)rScript.getUid(), (Object)"alive", iElementAttributes);
        if (nIOGroupQueue.getFuture() == null || nIOGroupQueue.getFuture() != null && nIOGroupQueue.getFuture().isDone()) {
            nIOGroupQueue.start();
        }
        if (bl) {
            this.toWSAdded(rScript);
        }
    }

    @Override
    protected synchronized RScript startScriptIfNotStarted1(RScript rScript, String string) {
        RScript rScript2 = NIOGroupQueue.scriptQueueVec.get(NIOGroupQueue.scriptQueueVec.indexOf(rScript));
        String string2 = this.getGroupUid(rScript2);
        NIOGroupQueue nIOGroupQueue = NIOGroupQueue.getGroupInstance(string2);
        if (nIOGroupQueue.getScriptQueue().contains(rScript)) {
            Object object;
            nIOGroupQueue.getScriptQueue().remove(rScript);
            rScript2.setPeer(string);
            rScript2.setDelay(new Date().getTime() - rScript2.getQueued_time());
            rScript2.setExecuting(true);
            rScript2.setStartedtime(new Date());
            nIOGroupQueue.getScriptQueueProcessing().add(rScript2);
            if (nIOGroupQueue.getScriptQueueListener().get(rScript2.getUid()) != null) {
                object = nIOGroupQueue.getScriptQueueListener().get(rScript2.getUid());
                try {
                    object.onScriptSent(rScript2, string);
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Error while invoking listener");
                }
            }
            try {
                object = this.getGroupedCache().getDefaultElementAttributes();
                object.setMaxLifeSeconds((long)CACHE_GROUP_EXPIRY);
                this.getGroupedCache().putInGroup((Object)string, CACHE_GROUP_ACTIVEPEERS, (Object)"active", (IElementAttributes)object);
            }
            catch (Exception exception) {
                this.log.error((Object)"error while caching active peer");
            }
            this.toWSStarted(rScript.getUid(), string);
            return rScript2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void scriptFinished(RScript rScript, String string, String string2) {
        RScript rScript2 = NIOGroupQueue.scriptQueueVec.get(NIOGroupQueue.scriptQueueVec.indexOf(rScript));
        String string3 = this.getGroupUid(rScript2);
        NIOGroupQueue nIOGroupQueue = NIOGroupQueue.getGroupInstance(string3);
        nIOGroupQueue.getScriptQueueProcessing().remove(rScript);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM HH:mm:ss");
        Date date = new Date();
        date.setTime(rScript2.getQueued_time());
        try {
            String string4 = rScript2.getPeer() + "_" + rScript2.getTaskuid();
            rScript2.setError(rScript.getError());
            IElementAttributes iElementAttributes = nIOGroupQueue.getGroupedCache().getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds((long)CACHE_GROUP_EXPIRY);
            if (nIOGroupQueue.getScriptQueueListener().get(rScript2.getUid()) != null) {
                RScriptListener rScriptListener = nIOGroupQueue.getScriptQueueListener().get(rScript2.getUid());
                try {
                    rScriptListener.onScriptFinished(rScript2, rScript2.getPeer(), string, string2);
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Error while invoking listener");
                }
                nIOGroupQueue.getScriptQueueListener().remove(rScript2.getUid());
                rScriptListener = null;
            }
            nIOGroupQueue.getCache().remove((Object)string4);
            rScript2 = null;
            this.toWSFinished(rScript.getUid());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            NIOGroupQueue.scriptQueueVec.remove(rScript);
        }
        rScript = null;
    }

    @Override
    public void removeScriptFromAllQueue(RScript rScript) {
        try {
            RScript rScript2 = NIOGroupQueue.scriptQueueVec.get(NIOGroupQueue.scriptQueueVec.indexOf(rScript));
            String string = this.getGroupUid(rScript2);
            NIOGroupQueue nIOGroupQueue = NIOGroupQueue.getGroupInstance(string);
            nIOGroupQueue.getScriptQueueProcessing().remove(rScript2);
            String string2 = rScript2.getPeer() + "_" + rScript2.getTaskuid();
            rScript2.setError(rScript.getError());
            nIOGroupQueue.getCache().remove((Object)string2);
            NIOGroupQueue.scriptQueueVec.remove(rScript);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Collection<RScript> getScriptQueue() throws Exception {
        ArrayList<RScript> arrayList = new ArrayList<RScript>();
        for (NIOGroupQueue nIOGroupQueue : NIOGroupQueue.getAllGroupQueues().values()) {
            arrayList.addAll(nIOGroupQueue.getScriptQueue());
        }
        return arrayList;
    }

    @Override
    public Collection<RScript> getScriptProcessingQueue() throws Exception {
        ArrayList<RScript> arrayList = new ArrayList<RScript>();
        for (NIOGroupQueue nIOGroupQueue : NIOGroupQueue.getAllGroupQueues().values()) {
            arrayList.addAll(nIOGroupQueue.getScriptQueueProcessing());
        }
        return arrayList;
    }

    public int getAllScriptObjectsSize() throws Exception {
        return NIOGroupQueue.scriptQueueVec.size();
    }

    public Map getScriptListeners() throws Exception {
        HashMap<String, RScriptListener> hashMap = new HashMap<String, RScriptListener>();
        for (NIOGroupQueue nIOGroupQueue : NIOGroupQueue.getAllGroupQueues().values()) {
            hashMap.putAll(nIOGroupQueue.getScriptQueueListener());
        }
        return hashMap;
    }

    @Override
    protected void toWSStarted(String string, String string2) {
        Future<String> future = IOExcecutors.threadpool.submit(new Callable<String>(){
            private String uid;
            private String peer;

            @Override
            public String call() {
                JSONObject jSONObject = new JSONObject();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("uid", this.uid);
                hashMap.put("peer", this.peer);
                try {
                    jSONObject.put("started", hashMap);
                    jSONObject.put("executing_size", LoadBalancingNewExecuteRQueue.this.getScriptProcessingQueue().size());
                    jSONObject.put("queue_size", LoadBalancingNewExecuteRQueue.this.getScriptQueue().size());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                TomcatWSServer.broadcast(jSONObject.toString());
                return "";
            }

            public Callable<String> init(String string, String string2) {
                this.uid = string;
                this.peer = string2;
                return this;
            }
        }.init(string, string2));
    }

    @Override
    protected void toWSFinished(String string) {
        Future<String> future = IOExcecutors.threadpool.submit(new Callable<String>(){
            private String uid;

            @Override
            public String call() {
                JSONObject jSONObject = new JSONObject();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("uid", this.uid);
                try {
                    jSONObject.put("finished", hashMap);
                    jSONObject.put("executing_size", LoadBalancingNewExecuteRQueue.this.getScriptProcessingQueue().size());
                    try {
                        LoadBalancingNewExecuteRQueue.this.get30SecsData(jSONObject);
                    }
                    catch (Exception exception) {
                        LoadBalancingNewExecuteRQueue.this.log.error((Object)("Error while geting 30secs data, e:" + exception.getMessage()));
                    }
                }
                catch (Exception exception) {
                    LoadBalancingNewExecuteRQueue.this.log.error((Object)("toWSFinished()" + exception.getMessage()));
                }
                TomcatWSServer.broadcast(jSONObject.toString());
                return "";
            }

            public Callable<String> init(String string) {
                this.uid = string;
                return this;
            }
        }.init(string));
    }
}

