/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.balance.executeR;

import com.fe.client.ClientErrorMgmt;
import com.fe.io.msg.ServerExecuteScript;
import com.fe.io.request.IOExcecutors;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.balance.executeR.LoadBalancingExecuteRQueue;
import com.fe.scheduler.queue.QueueStack;
import com.fe.scheduler.queue.QueueStackManager;
import com.fe.scheduler.rscript.RScript;
import com.fe.scheduler.rscript.RScriptListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;

public class NIOGroupQueue
implements Callable {
    private Logger log = Logger.getLogger(NIOGroupQueue.class);
    private ConcurrentLinkedQueue<RScript> scriptQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<RScript> scriptQueueProcessing = new ConcurrentLinkedQueue();
    private Hashtable<String, RScriptListener> scriptQueueListener = new Hashtable();
    private Future<String> future = null;
    protected static Vector<RScript> scriptQueueVec = new Vector();
    protected JCS cache = null;
    protected JCS cacheGrouped = null;
    private String uid = null;
    private static ConcurrentHashMap<String, NIOGroupQueue> queueInstances = new ConcurrentHashMap();
    private long prevtime = 0L;
    private Vector roundRobin = new Vector();

    private NIOGroupQueue(String string) {
        this.uid = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NIOGroupQueue getGroupInstance(String string) {
        ConcurrentHashMap<String, NIOGroupQueue> concurrentHashMap = queueInstances;
        synchronized (concurrentHashMap) {
            if (queueInstances.containsKey(string)) {
                return queueInstances.get(string);
            }
            NIOGroupQueue nIOGroupQueue = new NIOGroupQueue(string);
            queueInstances.put(string, nIOGroupQueue);
            return nIOGroupQueue;
        }
    }

    public static Map<String, NIOGroupQueue> getAllGroupQueues() {
        return queueInstances;
    }

    protected ConcurrentLinkedQueue<RScript> getScriptQueue() {
        return this.scriptQueue;
    }

    protected ConcurrentLinkedQueue<RScript> getScriptQueueProcessing() {
        return this.scriptQueueProcessing;
    }

    protected Hashtable<String, RScriptListener> getScriptQueueListener() {
        return this.scriptQueueListener;
    }

    protected ExecutorService getExecutorService() {
        return IOExcecutors.threadpool;
    }

    protected Future<String> getFuture() {
        return this.future;
    }

    protected String getUid() {
        return this.uid;
    }

    public void start() {
        this.future = IOExcecutors.threadpool.submit(this);
    }

    public Object call() throws Exception {
        this.log.debug((Object)"call() made");
        try {
            while (!this.scriptQueue.isEmpty()) {
                try {
                    this.processScriptQueue();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                Thread.sleep(2L);
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("loadbalancing queue thread terminiated: e: " + exception.getMessage()));
            exception.printStackTrace();
        }
        return "done";
    }

    private void processScriptQueue() throws Exception {
        RScript rScript = this.scriptQueue.peek();
        if (!rScript.isExecuting()) {
            this.cache = this.getCache();
            if (this.getCache().get((Object)rScript.getUid()) == null) {
                IElementAttributes iElementAttributes = this.getGroupedCache().getDefaultElementAttributes();
                iElementAttributes.setMaxLifeSeconds((long)LoadBalancingExecuteRQueue.CACHE_GROUP_EXPIRY);
                this.getGroupedCache().putInGroup((Object)rScript.getUid(), LoadBalancingExecuteRQueue.CACHE_GROUP_TIMEOUT, (Object)"timeout", iElementAttributes);
                this.scriptTimedOut(rScript);
                for (Object e : this.getGroupedCache().getGroupKeys(LoadBalancingExecuteRQueue.CACHE_GROUP_TIMEOUT)) {
                    this.getGroupedCache().getFromGroup(e, LoadBalancingExecuteRQueue.CACHE_GROUP_TIMEOUT);
                }
            } else {
                Vector<Object> vector = LoadBalancingQueue.getExecuteRScriptDefault().getRunOnlyOn(rScript.getTaskuid());
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (rScript.getExecuteAt() != null) {
                    arrayList.add(rScript.getExecuteAt());
                } else {
                    arrayList.addAll(vector);
                }
                if (arrayList.size() > 0) {
                    QueueStack queueStack = QueueStackManager.useNextAvailableQueue(arrayList, rScript.getTaskuid());
                    this.log.debug((Object)("qs:" + queueStack + " rs.getTaskuid():" + rScript.getTaskuid()));
                    if (queueStack != null) {
                        Future<RScript> future = IOExcecutors.threadpool.submit(new Callable<RScript>(){
                            private RScript rscript = null;
                            private QueueStack qs = null;

                            @Override
                            public RScript call() {
                                RScript rScript = null;
                                if (this.qs != null && (rScript = LoadBalancingQueue.getExecuteRScriptDefault().startScriptIfNotStarted(this.rscript, this.qs.getPeername())) != null) {
                                    ServerExecuteScript serverExecuteScript = new ServerExecuteScript();
                                    serverExecuteScript.setQueue_uid(this.qs.getUid());
                                    serverExecuteScript.setScript(this.rscript.getScript());
                                    serverExecuteScript.setTaskuid(this.rscript.getTaskuid());
                                    serverExecuteScript.setScript_uid(this.rscript.getUid());
                                    serverExecuteScript.send(this.qs.getPeername());
                                }
                                return rScript;
                            }

                            public Callable<RScript> init(RScript rScript, QueueStack queueStack) {
                                this.rscript = rScript;
                                this.qs = queueStack;
                                return this;
                            }
                        }.init(rScript, queueStack));
                        RScript rScript2 = null;
                        try {
                            rScript2 = future.get();
                        }
                        catch (Exception exception) {
                            this.log.error((Object)"error while retriveing future result");
                            exception.printStackTrace();
                        }
                    }
                }
                vector = null;
            }
        }
        rScript = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void scriptTimedOut(RScript rScript) {
        block10: {
            try {
                if (this.scriptQueueListener.get(rScript.getUid()) == null) break block10;
                RScriptListener rScriptListener = this.scriptQueueListener.get(rScript.getUid());
                try {
                    LoadBalancingExecuteRQueue loadBalancingExecuteRQueue = (LoadBalancingExecuteRQueue)LoadBalancingQueue.getExecuteRScriptDefault();
                    rScriptListener.onScriptTimedOut(rScript);
                    loadBalancingExecuteRQueue.toWSTimedout(rScript.getUid());
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Error while invoking listener");
                }
                finally {
                    this.scriptQueueListener.remove(rScript.getUid());
                }
            }
            catch (Exception exception) {
                this.log.error((Object)"Error while time out");
            }
            finally {
                this.scriptQueue.remove(rScript);
                scriptQueueVec.remove(rScript);
            }
        }
    }

    protected JCS getCache() throws Exception {
        if (this.cache == null) {
            this.cache = JCS.getInstance((String)"LoadBalancingQueue");
        }
        return this.cache;
    }

    public JCS getGroupedCache() throws Exception {
        if (this.cacheGrouped == null) {
            this.cacheGrouped = JCS.getInstance((String)"LoadBalancingQueueGroupped");
        }
        return this.cacheGrouped;
    }
}

