/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.balance.hsqldb;

import com.fe.client.BBSyncMgmt;
import com.fe.db.SchedulerDB;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.balance.LoadBalancingQueueItem;
import com.fe.scheduler.balance.LoadBalancingQueueTimeout;
import com.fe.scheduler.balance.hsqldb.LoadBalancingHSQLLayerDB;
import com.fe.scheduler.balance.hsqldb.LoadBalancingHSQLQueueItem;
import com.fe.scheduler.rscript.RScript;
import com.fe.scheduler.rscript.RScriptListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class LoadBalancingHSQLQueue
extends LoadBalancingHSQLLayerDB
implements Callable {
    private Logger log = Logger.getLogger(LoadBalancingHSQLQueue.class);
    private Future<String> future = null;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private static Semaphore conslock = new Semaphore(1, true);

    public LoadBalancingHSQLQueue() {
        this.initDB();
        this.future = this.executor.submit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(LoadBalancingQueueItem loadBalancingQueueItem) {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        this.acquireLock();
        try {
            List<Object> list;
            Object object;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            LoadBalancingQueueTimeout loadBalancingQueueTimeout = new LoadBalancingQueueTimeout(schedulerDB, new ScheduledTaskFactory().getTaskUids());
            LoadBalancingHSQLQueue.setAlertRange(loadBalancingQueueTimeout.getMaxWaitingAlert());
            LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem = new LoadBalancingHSQLQueueItem();
            loadBalancingHSQLQueueItem.setTaskuid(loadBalancingQueueItem.getSf().getTask().getUniqueid());
            if (loadBalancingQueueItem.getStarted() == null) {
                loadBalancingQueueItem.setStarted(new Date());
            }
            BeanUtils.copyProperties((Object)loadBalancingHSQLQueueItem, (Object)loadBalancingQueueItem);
            BeanUtils.copyProperties((Object)loadBalancingHSQLQueueItem, (Object)loadBalancingQueueItem.getSf());
            Map map = loadBalancingQueueItem.getSf().getData();
            if (map != null) {
                object = (String)map.get(ScheduledTask.FIELD_DEPENDENCY_IDS);
                loadBalancingHSQLQueueItem.setDependentids((String)object);
                String string = (String)map.get(ScheduledTask.FIELD_DEPENDENCY_CHECKTIME);
                loadBalancingHSQLQueueItem.setDependentchecktime(string);
                try {
                    loadBalancingHSQLQueueItem.setConcurrentexecution(Integer.parseInt((String)map.get(ScheduledTask.FIELD_CONCURRENT_EXEC)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = new TreeMap();
            ((TreeMap)object).put("scheduler_id", loadBalancingHSQLQueueItem.getSchedulerid());
            ((TreeMap)object).put("trigger_time", loadBalancingHSQLQueueItem.getTrigger_time());
            ((TreeMap)object).put("inject_code", loadBalancingHSQLQueueItem.getInject_code());
            loadBalancingHSQLQueueItem.setStarted(null);
            int n = 0;
            String string = null;
            try {
                this.addLastExecutionDuration(schedulerDB, loadBalancingHSQLQueueItem);
                this.addTimeoutAndLastExecTimes(schedulerDB, loadBalancingHSQLQueueItem);
                this.log.debug((Object)("addTimeoutAndLastExecTimes queue:" + loadBalancingHSQLQueueItem.getLastExecutedDuration()));
                n = this.add2DBQueue(loadBalancingHSQLQueueItem);
            }
            catch (Exception exception) {
                string = exception.getMessage();
                n = 0;
            }
            boolean bl = true;
            if (n == -1) {
                ((TreeMap)object).put("status", ScheduledTask.EXCECUTION_OVERLAPPED);
                ((TreeMap)object).put("is_triggered", new Integer(1));
                list = this.getItemsFromQueue(loadBalancingHSQLQueueItem.getSchedulerid());
                if (list != null && list.size() > 0) {
                    bl = true;
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM hh:mm:ss");
                    Date date = new Date();
                    String string2 = "";
                    this.log.debug((Object)"Item overlapped and adding execution log");
                    if (list.size() == 1) {
                        date.setTime(((LoadBalancingHSQLQueueItem)list.get(0)).getTrigger_time());
                        string2 = "Rejected, The task is already queued, added at " + simpleDateFormat.format(date);
                        if (((LoadBalancingHSQLQueueItem)list.get(0)).getStarted() != null) {
                            string2 = "Failed, The task is already executing, started at " + simpleDateFormat.format(((LoadBalancingHSQLQueueItem)list.get(0)).getStarted());
                        }
                    }
                    if (list.size() > 1) {
                        string2 = "Rejected, The task is already queued/executing in " + list.size() + " concurrent threads and are scheduled/added at ";
                        String string3 = "";
                        for (LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem2 : list) {
                            date.setTime(loadBalancingHSQLQueueItem2.getTrigger_time());
                            string3 = string3 + (string3.equals("") ? simpleDateFormat.format(date) : ", " + simpleDateFormat.format(date));
                        }
                        string2 = string2 + string3;
                    }
                    new SchedulerExePlanLogs(loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getTrigger_time()).log(string2, 4000);
                }
            } else if (n == -2) {
                bl = false;
            } else if (n == 0 && string != null) {
                new SchedulerExePlanLogs(loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getTrigger_time()).log("Error while adding into queue, scheduler_id: " + loadBalancingHSQLQueueItem.getSchedulerid() + " trig_time:" + loadBalancingHSQLQueueItem.getTrigger_time() + " Err:" + string, 3004);
            }
            if (bl) {
                list = new ArrayList<Object>();
                ((ArrayList)list).add(object);
                schedulerDB.updateQueueLog(list, new Vector());
            }
            if (this.future == null || this.future != null && this.future.isDone()) {
                this.future = this.executor.submit(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error((Object)("Error while adding into queue, Error:" + exception.getMessage()));
        }
        finally {
            this.releaseLock();
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void end() throws Exception {
        System.out.println("closing the connection....");
    }

    @Override
    public boolean isPeerBusyWithTask(String string, int n) {
        return false;
    }

    public Object call() throws Exception {
        this.log.debug((Object)"call()");
        this.queueLoop();
        return "done";
    }

    @Override
    protected void processQueueItem(LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem) throws Exception {
        if (loadBalancingHSQLQueueItem != null && !loadBalancingHSQLQueueItem.isExecuting()) {
            String string = loadBalancingHSQLQueueItem.getSf().getTask().getUniqueid();
            Vector<Object> vector = this.getRunOnlyOn(string);
            Vector vector2 = (Vector)vector.clone();
            if (vector2 != null && vector2.size() > 0) {
                if (loadBalancingHSQLQueueItem.getStarted_peers() != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(loadBalancingHSQLQueueItem.getStarted_peers(), ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (!vector2.contains(string2)) continue;
                        vector2.remove(string2);
                    }
                }
                this.sendTask2Peer(vector2, loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getTrigger_time(), loadBalancingHSQLQueueItem.getNexttrigger_time(), loadBalancingHSQLQueueItem.getTaskuid());
            }
            vector2 = null;
            if (vector != null) {
                vector.clear();
            }
            vector = null;
        }
    }

    @Override
    public void addExecuteR(RScript rScript, RScriptListener rScriptListener) throws Exception {
    }

    @Override
    public long lastExcecutedTime() {
        return this.lastExcecutedTime;
    }

    @Override
    public RScript startScriptIfNotStarted(RScript rScript, String string) {
        return null;
    }

    @Override
    public void scriptFinished(RScript rScript, String string, String string2) {
    }

    @Override
    public void executeScript(Vector<Object> vector, int n) throws Exception {
    }

    @Override
    public void executionEnded(int n) {
    }

    @Override
    public Collection<RScript> getScriptQueue() throws Exception {
        return null;
    }

    @Override
    public Collection<RScript> getScriptProcessingQueue() throws Exception {
        return null;
    }

    @Override
    public void removeScriptFromAllQueue(RScript rScript) {
    }
}

