/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.engines;

import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.data.FlexiField;
import com.fe.db.BBSyncDB;
import com.fe.scheduler.BloombergDownloadJob;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskField;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.exception.ExceptionWarningNoFullData;
import com.fe.scheduler.group.BBDownloadScheduledTask;
import com.fe.scheduler.pluggin.SchedulerBloombergPlugin;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jfree.util.Log;
import org.quartz.JobExecutionException;

public class BloombergDownload
extends ScheduledTask {
    private Logger log = Logger.getLogger(BBDownloadScheduledTask.class);

    public BloombergDownload(String string, String string2) {
        super(string, string2);
        try {
            this.addFormFields(this.getMyFields());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public synchronized void execute(StackFrame stackFrame) throws JobExecutionException, ExceptionWarningNoFullData, Exception {
        Map map = stackFrame.getData();
        if (map.get("download_id") == null || map.get("download_id") != null && ((String)map.get("download_id")).equals("")) {
            throw new JobExecutionException("Job can't be executed as you did not not select download query");
        }
        try {
            String string = (String)map.get("download_id");
            String string2 = map.get("id").toString();
            this.log.debug((Object)("sc_id:" + string2 + ":before opening database ..."));
            String string3 = (String)map.get("rlsdt_adjustment");
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            this.log.debug((Object)("sc_id:" + string2 + ":syncdb init"));
            bBSyncDB.connectDB(BBSyncMgmt.getDBName());
            this.log.debug((Object)("sc_id:" + string2 + ":connected"));
            Map map2 = bBSyncDB.getDownloadQuery(Integer.parseInt(string));
            this.log.debug((Object)("sc_id:" + string2 + ":after getDownloadQuery called"));
            if (string3 != null && !string3.equals("")) {
                try {
                    int n = Integer.parseInt(string3);
                    map2.put("enddt_adjustment", new Integer(n));
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Error while parsing release date adjument to Integer");
                }
            }
            if (map2 != null) {
                this.log.debug((Object)("sc_id:" + string + ":after before bloombergDownloadJob init"));
                BloombergDownloadJob bloombergDownloadJob = new BloombergDownloadJob();
                bloombergDownloadJob.setInvokedByScheduler();
                try {
                    bloombergDownloadJob.downloadData(map2, stackFrame);
                    this.log.debug((Object)("sc_id:" + string2 + ":after before downloadData called"));
                }
                catch (ExceptionWarningNoFullData exceptionWarningNoFullData) {
                    throw exceptionWarningNoFullData;
                }
                catch (Exception exception) {
                    throw new JobExecutionException((Throwable)exception);
                }
                finally {
                    stackFrame.setTasklog(bloombergDownloadJob.getSchedulerLog());
                    if (bloombergDownloadJob.getSchedulerLog() != null && !bloombergDownloadJob.getSchedulerLog().equals("")) {
                        stackFrame.setStatus(ScheduledTask.EXCECUTION_WARNING);
                    }
                }
            } else {
                throw new JobExecutionException("Job can't be executed, relevant download query not found (you may have deleted)");
            }
            bBSyncDB.closeDB();
        }
        catch (ExceptionWarningNoFullData exceptionWarningNoFullData) {
            throw exceptionWarningNoFullData;
        }
        catch (Exception exception) {
            throw new JobExecutionException((Throwable)exception);
        }
    }

    @Override
    public List<ScheduledTaskField> listFormFields() {
        super.removeAllFields();
        try {
            super.addFormFields(this.getMyFields());
        }
        catch (Exception exception) {
            Log.error((Object)"Error in refreshing fields");
        }
        return super.listFormFields();
    }

    private Vector<ScheduledTaskField> getMyFields() throws Exception {
        Vector<ScheduledTaskField> vector = new Vector<ScheduledTaskField>();
        ScheduledTaskField scheduledTaskField = new ScheduledTaskField();
        scheduledTaskField.setShortname("rlsdt_adjustment");
        scheduledTaskField.setFieldlabel("Release Date Adjustment");
        scheduledTaskField.setFieldtype("textbox");
        vector.add(scheduledTaskField);
        ScheduledTaskField scheduledTaskField2 = new ScheduledTaskField();
        scheduledTaskField2.setShortname(SchedulerBloombergPlugin.PLUGGIN_IN);
        scheduledTaskField2.setFieldlabel("Bloomberg Query");
        scheduledTaskField2.setFieldtype(FlexiField.TYPE_BLOOMBERG_PLUGGIN);
        scheduledTaskField2.setPluggindata(new SchedulerBloombergPlugin().getPlugginData());
        vector.add(scheduledTaskField2);
        ScheduledTaskField scheduledTaskField3 = new ScheduledTaskField();
        scheduledTaskField3.setShortname(new SchedulerBloombergPlugin().getPlugginData().getFieldreference());
        scheduledTaskField3.setFieldlabel("download_id");
        scheduledTaskField3.setFieldtype("hidden");
        vector.add(scheduledTaskField3);
        return vector;
    }
}

