/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.peer;

import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.db.SchedulerDB;
import com.fe.p2p.P2PService;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.peer.QueueAbstract;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class QueueExeThread
implements Runnable {
    private Logger log = Logger.getLogger(QueueExeThread.class);
    private QueueAbstract qa;
    private StackFrame frame;
    private String status;

    public QueueExeThread(QueueAbstract queueAbstract, StackFrame stackFrame) {
        this.qa = queueAbstract;
        this.frame = stackFrame;
    }

    @Override
    public void run() {
        this.status = null;
        try {
            this.log.debug((Object)("run():" + this.frame.getRscript()));
            if (this.frame.getRscript() != null) {
                this.runRScript();
            } else {
                this.runTask();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRScript() {
        ScheduledTask scheduledTask = this.frame.getTask();
        try {
            this.log.debug((Object)("just before executed task:" + scheduledTask));
            scheduledTask.execute(this.frame);
            this.log.debug((Object)"just after executed task");
            this.status = ScheduledTask.EXCECUTION_SUCCESS;
            this.qa.setLastExecutedTime(new Date().getTime());
        }
        catch (Exception exception) {
            this.log.error((Object)("error:::::" + exception.getMessage()));
            exception.printStackTrace();
            this.status = ScheduledTask.EXCECUTION_FAIL;
            ClientErrorMgmt.reportError(exception, null);
        }
        finally {
            if (this.frame.getCallBack() != null) {
                this.log.debug((Object)"sframe call back");
                try {
                    this.frame.getCallBack().callBack(this.frame, this.status, null);
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, null);
                }
            }
            this.qa.finishedExec(this.frame);
            this.log.debug((Object)"thread finised....");
        }
    }

    /*
     * Exception decompiling
     */
    private void runTask() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void traceHostAndStart(Date date, Map map, StackFrame stackFrame) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        schedulerDB.connectDB(BBSyncMgmt.getDBName());
        Number number = (Number)map.get("id");
        schedulerDB.updateHostAndStarted(number.intValue(), stackFrame.getTrigger_time(), date, P2PService.getComputerName());
        schedulerDB.closeDB();
    }

    private int addLog(Date date, Map map, String string, StackFrame stackFrame) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        schedulerDB.connectDB(BBSyncMgmt.getDBName());
        Number number = (Number)map.get("id");
        String string2 = (String)map.get("timezone");
        Date date2 = new Date();
        int n = number.intValue();
        int n2 = schedulerDB.addSchedulerLog(n, date, date2, string2, string, null);
        if (stackFrame.getStarted_time() > 0L) {
            long l = date2.getTime() - date.getTime();
            date.setTime(stackFrame.getStarted_time());
            long l2 = stackFrame.getStarted_time() + l;
            date2.setTime(l2);
        }
        try {
            int n3;
            Object object;
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            treeMap.put("scheduler_id", number);
            treeMap.put("trigger_time", new Long(stackFrame.getTrigger_time()));
            treeMap.put("start_time", date);
            treeMap.put("end_time", date2);
            treeMap.put("status", string);
            treeMap.put("is_triggered", new Integer(1));
            treeMap.put("log_id", new Integer(n2));
            treeMap.put("host", P2PService.getComputerName());
            treeMap.put("console_message", stackFrame.getConsole_message());
            this.log.debug((Object)("addLog:sframe.getDbConnectionIds():" + stackFrame.getDbConnectionIds()));
            Map map2 = null;
            if (stackFrame.getDbConnectionIds() != null && stackFrame.getDbConnectionIds().size() > 0) {
                String string3 = "";
                object = stackFrame.getDbConnectionIds().iterator();
                while (object.hasNext()) {
                    string3 = string3 + (string3.equals("") ? "" : ",") + "'" + object.next() + "'";
                }
                this.log.debug((Object)("###########con_ids::" + string3));
                map2 = schedulerDB.getDBLogSummary(string3);
                if (map2 != null && map2.size() > 0) {
                    treeMap.putAll(map2);
                }
            }
            Vector<Object> vector = new Vector<Object>();
            vector.add(treeMap);
            if (stackFrame.getNexttrigger_time() > 0L) {
                object = new TreeMap();
                ((TreeMap)object).put("scheduler_id", number);
                ((TreeMap)object).put("trigger_time", new Long(stackFrame.getNexttrigger_time()));
                treeMap.put("log_id", new Integer(n2));
                vector.add(object);
            }
            this.log.debug((Object)("logging job:+" + stackFrame.getTrigger_time() + " scheduler_Id:" + number));
            for (n3 = 0; n3 < 10; ++n3) {
                try {
                    schedulerDB.updateQueueLog(vector, map2 != null && map2.size() > 0 ? stackFrame.getDbConnectionIds() : new Vector());
                    n3 = 100;
                    continue;
                }
                catch (SQLServerException sQLServerException) {
                    this.log.error((Object)("SQL Error:" + sQLServerException.getMessage() + " trying " + n3));
                    Thread.sleep(500L);
                }
            }
            if (stackFrame.getExecuted_code() != null) {
                for (n3 = 0; n3 < 10; ++n3) {
                    try {
                        schedulerDB.updateExecutedCodeQLog(number.intValue(), stackFrame.getTrigger_time(), stackFrame.getExecuted_code());
                        n3 = 100;
                        continue;
                    }
                    catch (SQLServerException sQLServerException) {
                        this.log.error((Object)("SQL Error:" + sQLServerException.getMessage() + " trying " + n3));
                        Thread.sleep(500L);
                    }
                }
            }
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
        }
        this.log.debug((Object)("before adding into db sframe.getTaskLog():" + stackFrame.getTasklog()));
        if (stackFrame.getTasklog() != null && !stackFrame.getTasklog().equals("")) {
            try {
                schedulerDB.updateSchedulerLogMsg(n2, stackFrame.getTasklog());
            }
            catch (Exception exception) {
                this.log.error((Object)("Error while updating log message of R Engine:" + exception.getMessage()));
            }
        }
        schedulerDB.closeDB();
        return n2;
    }

    private void addScriptLog(Date date, Map map, String string, StackFrame stackFrame) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        schedulerDB.connectDB(BBSyncMgmt.getDBName());
        Number number = (Number)map.get("script_id");
        Date date2 = new Date();
        schedulerDB.addRScriptLog(number.intValue(), P2PService.getComputerName(), string, date, date2, stackFrame.getTasklog());
        schedulerDB.closeDB();
    }
}

