/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.queue;

import com.fe.scheduler.peer.QueueAbstract;
import com.fe.scheduler.peer.QueueFactory;
import com.fe.scheduler.queue.QueueStack;
import com.googlecode.cqengine.CQEngine;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.hash.HashIndex;
import com.googlecode.cqengine.index.navigable.NavigableIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.logical.And;
import com.googlecode.cqengine.query.option.AttributeOrder;
import com.googlecode.cqengine.query.option.QueryOption;
import com.googlecode.cqengine.query.simple.Equal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class QueueStackManager {
    private static Logger log = Logger.getLogger(QueueStackManager.class);
    private static IndexedCollection<QueueStack> qstack = CQEngine.newInstance();

    public static void buildQueue4Peer(String string) {
        QueueFactory queueFactory = new QueueFactory();
        TreeMap treeMap = queueFactory.getQueue();
        ArrayList<QueueAbstract> arrayList = new ArrayList<QueueAbstract>();
        for (QueueAbstract queueAbstract : treeMap.values()) {
            if (arrayList.contains(queueAbstract)) continue;
            arrayList.add(queueAbstract);
            for (int i = 0; i < queueAbstract.getConcurrentThreads(); ++i) {
                if (queueAbstract.getTaskUids().size() <= 0) continue;
                QueueStack queueStack = new QueueStack();
                queueStack.setName(queueAbstract.getName());
                queueStack.setPeername(string);
                queueStack.setSupportedtaskuids(queueAbstract.getTaskUids());
                queueStack.setUid(queueAbstract.getName() + i);
                queueStack.setRunning(false);
                queueStack.setAvailable(false);
                qstack.add((Object)queueStack);
            }
        }
    }

    public static Set<QueueStack> getAllQueueStacks() throws Exception {
        return qstack;
    }

    public static void peerDisconnected(String string) {
        if (string != null) {
            Equal equal = QueryFactory.equal(QueueStack.PEERNAME, (Object)string);
            Iterator iterator = qstack.retrieve((Query)equal, QueryFactory.queryOptions((QueryOption)QueryFactory.orderBy((AttributeOrder)QueryFactory.ascending(QueueStack.UID)))).iterator();
            while (iterator.hasNext()) {
                qstack.remove(iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshQS(QueueStack queueStack) {
        QueueStack queueStack2 = queueStack;
        synchronized (queueStack2) {
            qstack.remove((Object)queueStack);
            qstack.add((Object)queueStack);
        }
    }

    public static void setStackBusy(String string, String string2) throws Exception {
        QueueStackManager.setStackRunning(string, string2, true);
    }

    public static void setStackIdle(String string, String string2) throws Exception {
        QueueStackManager.setStackRunning(string, string2, false);
    }

    private static void setStackRunning(String string, String string2, boolean bl) throws Exception {
        And and = QueryFactory.and((Query)QueryFactory.equal(QueueStack.PEERNAME, (Object)string), (Query)QueryFactory.equal(QueueStack.UID, (Object)string2));
        Iterator iterator = qstack.retrieve((Query)and).iterator();
        if (iterator != null && iterator.hasNext()) {
            QueueStack queueStack = (QueueStack)iterator.next();
            queueStack.setRunning(bl);
            QueueStackManager.refreshQS(queueStack);
        }
    }

    public static String getPeerQueueStatForServer() throws Exception {
        Iterator iterator = qstack.iterator();
        String string = "";
        while (iterator.hasNext()) {
            QueueStack queueStack = (QueueStack)iterator.next();
            string = string + queueStack.getUid() + "=" + queueStack.isRunning() + "|";
        }
        return string;
    }

    public static void server2SyncPeerQueue(String string, String string2) throws Exception {
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            Object object2;
            string3 = stringTokenizer.nextToken();
            if (string3 == null || string3.trim().equals("") || !((Matcher)(object2 = ((Pattern)(object = Pattern.compile("^(.*?)=(.*?)$"))).matcher(string3))).find() || ((Matcher)object2).groupCount() != 2) continue;
            String string4 = ((Matcher)object2).group(1);
            String string5 = ((Matcher)object2).group(2);
            boolean bl = string5.toLowerCase().equals("true");
            boolean bl2 = true;
            And and = QueryFactory.and((Query)QueryFactory.equal(QueueStack.PEERNAME, (Object)string), (Query)QueryFactory.equal(QueueStack.UID, (Object)string4));
            Iterator iterator = qstack.retrieve((Query)and).iterator();
            if (iterator == null || !iterator.hasNext()) continue;
            QueueStack queueStack = (QueueStack)iterator.next();
            queueStack.setRunning(bl);
            queueStack.setAvailable(bl2);
            log.debug((Object)("adding queue, q:" + queueStack.getUid() + " name:" + queueStack.getName() + " peer:" + queueStack.getPeername()));
            QueueStackManager.refreshQS(queueStack);
        }
        string3 = QueryFactory.and((Query)QueryFactory.equal(QueueStack.AVAILABLE, (Object)false), (Query)QueryFactory.equal(QueueStack.PEERNAME, (Object)string));
        for (Object object2 : qstack.retrieve((Query)string3)) {
            if (((QueueStack)object2).isAvailable()) continue;
            log.debug((Object)("removing from server queue, q:" + ((QueueStack)object2).getUid() + " name:" + ((QueueStack)object2).getName() + " peer:" + ((QueueStack)object2).getPeername() + " available:" + ((QueueStack)object2).isAvailable()));
            qstack.remove(object2);
        }
    }

    public static QueueStack useNextAvailableQueue(List list, String string) throws Exception {
        QueueStack queueStack = null;
        And and = null;
        and = list.size() > 1 ? QueryFactory.and((Query)QueryFactory.in(QueueStack.PEERNAME, (Collection)list), (Query)QueryFactory.equal(QueueStack.SUPPORTEDTASKUIDS, (Object)string), (Query)QueryFactory.equal(QueueStack.RUNNING, (Object)false)) : QueryFactory.and((Query)QueryFactory.equal(QueueStack.PEERNAME, (Object)((String)list.get(0))), (Query)QueryFactory.equal(QueueStack.SUPPORTEDTASKUIDS, (Object)string), (Query)QueryFactory.equal(QueueStack.RUNNING, (Object)false));
        Iterator iterator = qstack.retrieve((Query)and, QueryFactory.queryOptions((QueryOption)QueryFactory.orderBy((AttributeOrder)QueryFactory.ascending(QueueStack.EXECUTIONCOUNT)))).iterator();
        if (iterator != null && iterator.hasNext()) {
            queueStack = (QueueStack)iterator.next();
            queueStack.setExecutioncount(queueStack.getExecutioncount() + 1);
            queueStack.setRunning(true);
            QueueStackManager.refreshQS(queueStack);
        }
        return queueStack;
    }

    static {
        qstack.addIndex((Index)NavigableIndex.onAttribute(QueueStack.PEERNAME));
        qstack.addIndex((Index)NavigableIndex.onAttribute(QueueStack.NAME));
        qstack.addIndex((Index)NavigableIndex.onAttribute(QueueStack.PRIORITY));
        qstack.addIndex((Index)NavigableIndex.onAttribute(QueueStack.RUNNING));
        qstack.addIndex((Index)NavigableIndex.onAttribute(QueueStack.AVAILABLE));
        qstack.addIndex((Index)NavigableIndex.onAttribute(QueueStack.UID));
        qstack.addIndex((Index)HashIndex.onAttribute(QueueStack.SUPPORTEDTASKUIDS));
    }
}

