/*
 * Decompiled with CFR 0.152.
 */
package com.fe.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.CharacterConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;

public class BeanUtil {
    public Map<String, Object> convertBeanToProperties(Object object) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            String string = propertyDescriptor.getName();
            Method method = propertyDescriptor.getReadMethod();
            if (method == null) continue;
            Object object2 = method.invoke(object, new Object[0]);
            hashMap.put(string, object2);
        }
        return hashMap;
    }

    public void convertPropertiesToBean(Map<String, Object> map, Object object) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            Class<?> clazz;
            String string = propertyDescriptor.getName();
            Object object2 = map.get(string);
            Method method = propertyDescriptor.getReadMethod();
            Method method2 = propertyDescriptor.getWriteMethod();
            if (method == null || method2 == null || object2 == null) continue;
            Class<?> clazz2 = method2.getParameterTypes()[0];
            if (!clazz2.isAssignableFrom(clazz = object2.getClass())) {
                try {
                    if (clazz == String.class) {
                        object2 = ConvertUtils.convert((String)((String)object2), clazz2);
                    } else if (clazz == String[].class) {
                        object2 = ConvertUtils.convert((String[])((String[])object2), clazz2);
                    } else if (clazz == Object[].class) {
                        Object[] objectArray = (Object[])object2;
                        String[] stringArray = new String[objectArray.length];
                        for (int i = 0; i < objectArray.length; ++i) {
                            stringArray[i] = objectArray[i] == null ? null : objectArray[i].toString();
                        }
                        object2 = ConvertUtils.convert((String[])stringArray, clazz2);
                    }
                }
                catch (ConversionException conversionException) {
                    throw new IllegalArgumentException("Conversion failed for property '" + string + "' with value '" + object2 + "'", conversionException);
                }
            }
            method2.invoke(object, object2);
        }
    }

    public boolean equals(Object object, Object object2) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (object.getClass() != object2.getClass()) {
            return false;
        }
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass(), Object.class);
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            String string = propertyDescriptor.getName();
            Method method = propertyDescriptor.getReadMethod();
            if (method == null) continue;
            Object object3 = method.invoke(object, new Object[0]);
            Object object4 = method.invoke(object2, new Object[0]);
            if ((object3 == null || object3.equals(object4)) && (object4 == null || object4.equals(object3))) continue;
            return false;
        }
        return true;
    }

    static {
        ConvertUtils.register((Converter)new BooleanConverter(), Boolean.class);
        ConvertUtils.register((Converter)new BooleanConverter(), Boolean.TYPE);
        ConvertUtils.register((Converter)new ByteConverter(), Byte.class);
        ConvertUtils.register((Converter)new ByteConverter(), Byte.TYPE);
        ConvertUtils.register((Converter)new CharacterConverter(), Character.class);
        ConvertUtils.register((Converter)new CharacterConverter(), Character.TYPE);
        ConvertUtils.register((Converter)new FloatConverter(), Float.class);
        ConvertUtils.register((Converter)new FloatConverter(), Float.TYPE);
        ConvertUtils.register((Converter)new IntegerConverter(), Integer.class);
        ConvertUtils.register((Converter)new IntegerConverter(), Integer.TYPE);
        ConvertUtils.register((Converter)new LongConverter(), Long.class);
        ConvertUtils.register((Converter)new LongConverter(), Long.TYPE);
        ConvertUtils.register((Converter)new ShortConverter(), Short.class);
        ConvertUtils.register((Converter)new ShortConverter(), Short.TYPE);
    }
}

