/*
 * Decompiled with CFR 0.152.
 */
package com.fe.xls.historical;

import com.fe.data.Contract;
import com.fe.xls.listener.HistoricalRowListener;
import com.fe.xls.listener.HistoricalSheetListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class XLSMarketHistoricalReader {
    private File file;
    private int sheetscount = 0;
    private static int CONTRACT_TITLE_ROW = 0;
    private static int CONTRACT_TITLE_CELL_START_AT = 2;
    private static int CONTRACT_DATE_CELL = 0;
    private static int DATA_ROW_START_AT = 2;
    private Logger log = Logger.getLogger(XLSMarketHistoricalReader.class);

    public XLSMarketHistoricalReader(File file) {
        this.file = file;
    }

    public void processFile(HistoricalSheetListener historicalSheetListener, HistoricalRowListener historicalRowListener) throws Exception {
        int n;
        this.log.debug((Object)"processFile() called");
        FileInputStream fileInputStream = new FileInputStream(this.file);
        this.log.debug((Object)("xls file stream opened for " + this.file));
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook((InputStream)fileInputStream);
        this.sheetscount = hSSFWorkbook.getNumberOfSheets();
        this.log.debug((Object)("before sheet begin, # of sheets:" + this.sheetscount));
        String[] stringArray = new String[hSSFWorkbook.getNumberOfSheets()];
        for (n = 0; n < hSSFWorkbook.getNumberOfSheets(); ++n) {
            stringArray[n] = hSSFWorkbook.getSheetName(n);
        }
        historicalSheetListener.sheetsBegin(this.file.getName(), stringArray);
        this.log.debug((Object)"sheet begin listner excecuted");
        for (n = 0; n < hSSFWorkbook.getNumberOfSheets(); ++n) {
            HSSFSheet hSSFSheet = hSSFWorkbook.getSheetAt(n);
            Vector vector = this.getContractTitles(hSSFSheet);
            if (!historicalSheetListener.excecute(hSSFWorkbook.getSheetName(n), vector, n)) continue;
            this.log.debug((Object)("sheet execution starts, sheetname:" + hSSFWorkbook.getSheetName(n)));
            for (int i = DATA_ROW_START_AT; i < hSSFSheet.getLastRowNum(); ++i) {
                HSSFRow hSSFRow = hSSFSheet.getRow(i);
                HSSFCell hSSFCell = hSSFRow.getCell(CONTRACT_DATE_CELL);
                Date date = null;
                if (hSSFCell != null) {
                    try {
                        date = hSSFCell.getDateCellValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Vector vector2 = this.getContracts(hSSFRow, vector, date);
                if (historicalRowListener.excecuteContinue(hSSFWorkbook.getSheetName(n), date, vector2, i)) continue;
                i = hSSFSheet.getLastRowNum() + 1;
            }
        }
        historicalSheetListener.sheetsEnd();
        ((InputStream)fileInputStream).close();
    }

    public int getSheetscount() {
        return this.sheetscount;
    }

    private Vector getContracts(HSSFRow hSSFRow, Vector vector, Date date) {
        Vector<Contract> vector2 = new Vector<Contract>();
        int n = hSSFRow.getLastCellNum() > CONTRACT_TITLE_CELL_START_AT + vector.size() ? CONTRACT_TITLE_CELL_START_AT + vector.size() : hSSFRow.getLastCellNum();
        for (int i = CONTRACT_TITLE_CELL_START_AT; i < n; ++i) {
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null || hSSFCell.getCellType() != 0 || i - CONTRACT_TITLE_CELL_START_AT >= vector.size() || vector.get(i - CONTRACT_TITLE_CELL_START_AT) == null) continue;
            Contract contract = new Contract();
            contract.setCdate(date);
            contract.setName((String)vector.get(i - CONTRACT_TITLE_CELL_START_AT));
            contract.setValue(hSSFCell.getNumericCellValue());
            vector2.add(contract);
        }
        return vector2;
    }

    private Vector getContractTitles(HSSFSheet hSSFSheet) throws Exception {
        Vector<String> vector = new Vector<String>();
        HSSFRow hSSFRow = hSSFSheet.getRow(CONTRACT_TITLE_ROW);
        for (int i = CONTRACT_TITLE_CELL_START_AT; i < hSSFRow.getLastCellNum(); ++i) {
            HSSFCell hSSFCell = hSSFRow.getCell(i);
            if (hSSFCell == null || hSSFCell.getCellType() != 1) continue;
            vector.add(hSSFCell.getStringCellValue());
        }
        return vector;
    }
}

