/*
 * Decompiled with CFR 0.152.
 */
package com.bloomberglp.blpapi;

import com.bloomberglp.blpapi.CorrelationID;
import com.bloomberglp.blpapi.DuplicateCorrelationIDException;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.EventDispatcher;
import com.bloomberglp.blpapi.EventHandler;
import com.bloomberglp.blpapi.EventQueue;
import com.bloomberglp.blpapi.InvalidRequestException;
import com.bloomberglp.blpapi.NotFoundException;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.RequestQueueOverflowException;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.SessionOptions;
import com.bloomberglp.blpapi.SubscriptionIterator;
import com.bloomberglp.blpapi.SubscriptionList;
import com.bloomberglp.blpapi.UserHandle;
import com.bloomberglp.blpapi.a;
import com.bloomberglp.blpapi.impl.T;
import com.bloomberglp.blpapi.impl.aB;
import com.bloomberglp.blpapi.impl.al;
import com.bloomberglp.blpapi.impl.ar;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Session {
    private al a;
    private EventHandler[] b;

    public Session() {
        this(new SessionOptions());
    }

    public Session(SessionOptions sessionOptions) {
        this.a = new al(sessionOptions.a(), null, null);
    }

    public Session(SessionOptions sessionOptions, EventHandler eventHandler) {
        this(sessionOptions, eventHandler, null);
    }

    public Session(SessionOptions sessionOptions, EventHandler eventHandler, EventDispatcher eventDispatcher) {
        if (eventHandler == null) {
            throw new IllegalArgumentException("Event handler cannot be null");
        }
        this.b = new EventHandler[Event.EventType.b()];
        int n2 = 0;
        while (n2 < this.b.length) {
            this.b[n2] = eventHandler;
            ++n2;
        }
        this.a = new al(sessionOptions.a(), new a(this), eventDispatcher == null ? null : eventDispatcher.a());
    }

    public final boolean start() throws IOException, InterruptedException {
        return this.a.a();
    }

    public final void startAsync() throws IOException {
        this.a.b();
    }

    public final void stop() throws InterruptedException {
        this.stop(StopOption.SYNC);
    }

    public final void stop(StopOption stopOption) throws InterruptedException {
        this.a.a(StopOption.a(stopOption));
    }

    public final Event nextEvent() throws InterruptedException {
        return this.a.c();
    }

    public final Event nextEvent(long l2) throws InterruptedException {
        return this.a.a(l2);
    }

    public final CorrelationID openServiceAsync(String string) throws IllegalStateException, IOException {
        CorrelationID correlationID = new CorrelationID();
        this.a.a(string, correlationID);
        return correlationID;
    }

    public final void openServiceAsync(String string, CorrelationID correlationID) throws IllegalStateException, IOException {
        this.a.a(string, correlationID);
    }

    public final boolean openService(String string) throws InterruptedException, IOException {
        CorrelationID correlationID = new CorrelationID();
        return this.a.b(string, correlationID) != null;
    }

    public final Service getService(String string) {
        return this.a.a(string);
    }

    public final void subscribe(SubscriptionList subscriptionList) throws DuplicateCorrelationIDException, IOException {
        this.a.a(subscriptionList, (aB)null, (String)null);
    }

    public final void subscribe(SubscriptionList subscriptionList, String string) throws DuplicateCorrelationIDException, IOException {
        this.a.a(subscriptionList, null, string);
    }

    public final void subscribe(SubscriptionList subscriptionList, UserHandle userHandle) throws DuplicateCorrelationIDException, IOException, IllegalArgumentException {
        this.a.a(subscriptionList, (aB)userHandle, null);
    }

    public final void subscribe(SubscriptionList subscriptionList, UserHandle userHandle, String string) throws DuplicateCorrelationIDException, IOException, IllegalArgumentException {
        this.a.a(subscriptionList, (aB)userHandle, string);
    }

    public final void resubscribe(SubscriptionList subscriptionList) throws IOException, NotFoundException {
        this.a.a(subscriptionList, (String)null);
    }

    public final void resubscribe(SubscriptionList subscriptionList, String string) throws IOException, NotFoundException, IllegalStateException {
        this.a.a(subscriptionList, string);
    }

    public final void unsubscribe(CorrelationID correlationID) throws IOException {
        this.cancel(correlationID);
    }

    public final void unsubscribe(SubscriptionList subscriptionList) throws IOException {
        this.unsubscribe(subscriptionList, null);
    }

    public final void unsubscribe(SubscriptionList subscriptionList, String string) throws IOException {
        int n2 = subscriptionList.size();
        ArrayList<CorrelationID> arrayList = new ArrayList<CorrelationID>(subscriptionList.size());
        int n3 = 0;
        while (n3 < n2) {
            arrayList.add(subscriptionList.get(n3).correlationID());
            ++n3;
        }
        this.cancel(arrayList, string);
    }

    public final int subscriptionStatus(CorrelationID correlationID) throws NotFoundException {
        return this.a.a(correlationID);
    }

    public final String subscriptionString(CorrelationID correlationID) throws NotFoundException {
        return this.a.b(correlationID);
    }

    public final CorrelationID sendRequest(Request request, CorrelationID correlationID) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException {
        return this.sendRequest(request, null, null, correlationID, null);
    }

    public final CorrelationID sendRequest(Request request, CorrelationID correlationID, String string) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException {
        return this.sendRequest(request, null, null, correlationID, string);
    }

    public final CorrelationID sendRequest(Request request, UserHandle userHandle, CorrelationID correlationID) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException, IllegalArgumentException {
        return this.sendRequest(request, userHandle, null, correlationID, null);
    }

    public final CorrelationID sendRequest(Request request, UserHandle userHandle, CorrelationID correlationID, String string) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException, IllegalArgumentException {
        return this.sendRequest(request, userHandle, null, correlationID, string);
    }

    public final CorrelationID sendRequest(Request request, EventQueue eventQueue, CorrelationID correlationID) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException {
        return this.sendRequest(request, null, eventQueue, correlationID, null);
    }

    public final CorrelationID sendRequest(Request request, EventQueue eventQueue, CorrelationID correlationID, String string) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException {
        return this.sendRequest(request, null, eventQueue, correlationID, string);
    }

    public final CorrelationID sendRequest(Request request, UserHandle userHandle, EventQueue eventQueue, CorrelationID correlationID) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException, IllegalArgumentException {
        return this.sendRequest(request, userHandle, eventQueue, correlationID, null);
    }

    public final CorrelationID sendRequest(Request request, UserHandle userHandle, EventQueue eventQueue, CorrelationID correlationID, String string) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException, IllegalArgumentException {
        if (correlationID == null) {
            correlationID = new CorrelationID();
        }
        this.a.a((ar)request, (aB)userHandle, eventQueue != null ? eventQueue.a() : null, correlationID, string);
        return correlationID;
    }

    public final CorrelationID sendAuthorizationRequest(Request request, UserHandle userHandle, CorrelationID correlationID) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException, IllegalArgumentException {
        return this.sendAuthorizationRequest(request, userHandle, null, correlationID, null);
    }

    public final CorrelationID sendAuthorizationRequest(Request request, UserHandle userHandle, CorrelationID correlationID, String string) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException, IllegalArgumentException {
        return this.sendAuthorizationRequest(request, userHandle, null, correlationID, string);
    }

    public final CorrelationID sendAuthorizationRequest(Request request, UserHandle userHandle, EventQueue eventQueue, CorrelationID correlationID) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException, IllegalArgumentException {
        return this.sendAuthorizationRequest(request, userHandle, eventQueue, correlationID, null);
    }

    public final CorrelationID sendAuthorizationRequest(Request request, UserHandle userHandle, EventQueue eventQueue, CorrelationID correlationID, String string) throws InvalidRequestException, RequestQueueOverflowException, IOException, DuplicateCorrelationIDException, IllegalArgumentException {
        if (correlationID == null) {
            correlationID = new CorrelationID();
        }
        this.a.b((ar)request, (aB)userHandle, eventQueue != null ? eventQueue.a() : null, correlationID, string);
        return correlationID;
    }

    public final void cancel(CorrelationID correlationID) {
        this.a.a(correlationID, null);
    }

    public final void cancel(CorrelationID correlationID, String string) {
        this.a.a(correlationID, string);
    }

    public final void cancel(List list) {
        this.a.a(list, null);
    }

    public final void cancel(List list, String string) {
        this.a.a(list, string);
    }

    public final UserHandle createUserHandle() {
        return this.a.d();
    }

    public final void setEventHandler(EventHandler eventHandler, Event.EventType eventType) {
        if (eventHandler == null) {
            throw new IllegalArgumentException("Event handler cannot be null");
        }
        if (this.a.e() == 0) {
            this.b[eventType.a()] = eventHandler;
            return;
        }
        throw new IllegalStateException("Event handler cannot be set after starting session.");
    }

    public final SubscriptionIterator subscriptionIterator() {
        return new SubscriptionIterator(this.a);
    }

    static EventHandler[] a(Session session) {
        return session.b;
    }

    public static class StopOption {
        private T a;
        public static final StopOption SYNC = new StopOption(T.a);
        public static final StopOption ASYNC = new StopOption(T.b);

        private StopOption(T t2) {
            this.a = t2;
        }

        public String toString() {
            return this.a.toString();
        }

        public int intValue() {
            return this.a.a();
        }

        static T a(StopOption stopOption) {
            return stopOption.a;
        }

        public static class Constants {
            public static final int SYNC = 0;
            public static final int ASYNC = 1;
        }
    }

    public static final class SubscriptionStatus {
        private int a;
        private String b;
        public static final SubscriptionStatus SUBSCRIBING = new SubscriptionStatus(0, "SUBSCRIBING");
        public static final SubscriptionStatus WAITING_FOR_MESSAGES = new SubscriptionStatus(1, "WAITING_FOR_MESSAGES");
        public static final SubscriptionStatus RECEIVING_MESSAGES = new SubscriptionStatus(2, "RECEIVING_MESSAGES");
        public static final SubscriptionStatus UNSUBSCRIBED = new SubscriptionStatus(3, "UNSUBSCRIBED");
        private static SubscriptionStatus[] c;

        private SubscriptionStatus(int n2, String string) {
            c = new SubscriptionStatus[]{SUBSCRIBING, WAITING_FOR_MESSAGES, RECEIVING_MESSAGES, UNSUBSCRIBED};
            this.a = n2;
            this.b = string;
        }

        public final int intValue() {
            return this.a;
        }

        public final String toString() {
            return this.b;
        }

        static SubscriptionStatus a(int n2) {
            if (n2 >= 0 && n2 < c.length) {
                return c[n2];
            }
            return null;
        }

        public static class Constants {
            public static final int SUBSCRIBING = 0;
            public static final int WAITING_FOR_MESSAGES = 1;
            public static final int RECEIVING_MESSAGES = 2;
            public static final int UNSUBSCRIBED = 3;
        }
    }
}

