/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.indexed;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskElementDescriptor;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.utils.serialization.StandardSerializer;

class IndexedDisk {
    public static final int RECORD_HEADER = 4;
    protected IElementSerializer elementSerializer = new StandardSerializer();
    private static final Log log = LogFactory.getLog((Class)IndexedDisk.class);
    private final String filepath;
    private RandomAccessFile raf;
    private final byte[] buffer = new byte[16384];

    public IndexedDisk(File file, IElementSerializer elementSerializer) throws FileNotFoundException {
        this.filepath = file.getAbsolutePath();
        this.elementSerializer = elementSerializer;
        this.raf = new RandomAccessFile(this.filepath, "rw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Serializable readObject(IndexedDiskElementDescriptor ded) throws IOException, ClassNotFoundException {
        byte[] data = null;
        IndexedDisk indexedDisk = this;
        synchronized (indexedDisk) {
            String message = null;
            boolean corrupted = false;
            long fileLength = this.raf.length();
            if (ded.pos > fileLength) {
                corrupted = true;
                message = "Record " + ded + " starts past EOF.";
            } else {
                this.raf.seek(ded.pos);
                int datalen = this.raf.readInt();
                if (ded.len != datalen) {
                    corrupted = true;
                    message = "Record " + ded + " does not match data length on disk (" + datalen + ")";
                } else if (ded.pos + (long)ded.len > fileLength) {
                    corrupted = true;
                    message = "Record " + ded + " exceeds file length.";
                }
            }
            if (corrupted) {
                log.warn((Object)("\n The file is corrupt: \n " + message));
                throw new IOException("The File Is Corrupt, need to reset");
            }
            data = new byte[ded.len];
            this.raf.readFully(data);
        }
        return (Serializable)this.elementSerializer.deSerialize(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void move(IndexedDiskElementDescriptor ded, long newPosition) throws IOException {
        IndexedDisk indexedDisk = this;
        synchronized (indexedDisk) {
            int chunkSize;
            this.raf.seek(ded.pos);
            int length = this.raf.readInt();
            if (length != ded.len) {
                throw new IOException("Mismatched memory and disk length (" + length + ") for " + ded);
            }
            long readPos = ded.pos;
            long writePos = newPosition;
            for (int remaining = 4 + length; remaining > 0; remaining -= chunkSize) {
                chunkSize = Math.min(remaining, this.buffer.length);
                this.raf.seek(readPos);
                this.raf.readFully(this.buffer, 0, chunkSize);
                this.raf.seek(writePos);
                this.raf.write(this.buffer, 0, chunkSize);
                writePos += (long)chunkSize;
                readPos += (long)chunkSize;
            }
            ded.pos = newPosition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean write(IndexedDiskElementDescriptor ded, byte[] data) throws IOException {
        long pos = ded.pos;
        if (log.isTraceEnabled()) {
            log.trace((Object)("write> pos=" + pos));
            log.trace((Object)(this.raf + " -- data.length = " + data.length));
        }
        if (data.length != ded.len) {
            throw new IOException("Mismatched descriptor and data lengths");
        }
        IndexedDisk indexedDisk = this;
        synchronized (indexedDisk) {
            this.raf.seek(pos);
            this.raf.writeInt(data.length);
            this.raf.write(data, 0, ded.len);
        }
        return true;
    }

    protected boolean writeObject(Serializable obj, long pos) throws IOException {
        byte[] data = this.elementSerializer.serialize(obj);
        this.write(new IndexedDiskElementDescriptor(pos, data.length), data);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long length() throws IOException {
        IndexedDisk indexedDisk = this;
        synchronized (indexedDisk) {
            return this.raf.length();
        }
    }

    protected synchronized void close() throws IOException {
        this.raf.close();
    }

    protected synchronized void reset() throws IOException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resetting Indexed File [" + this.filepath + "]"));
        }
        this.raf.close();
        File f = new File(this.filepath);
        for (i = 0; i < 10 && !f.delete(); ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            log.warn((Object)("Failed to delete " + f.getName() + " " + i));
        }
        if (i == 10) {
            IllegalStateException ex = new IllegalStateException("Failed to delete " + f.getName());
            log.error((Object)ex);
            throw ex;
        }
        this.raf = new RandomAccessFile(this.filepath, "rw");
    }

    protected void truncate(long length) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Trucating file [" + this.filepath + "] to " + length));
        }
        this.raf.setLength(length);
    }

    protected String getFilePath() {
        return this.filepath;
    }
}

