/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.rmi.Naming;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheObserver;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.behavior.ICacheRestore;

public class RemoteCacheRestore
implements ICacheRestore {
    private static final Log log = LogFactory.getLog((Class)RemoteCacheRestore.class);
    private final RemoteCacheManager remoteCacheManager;
    private boolean canFix = true;
    private Object remoteObj;

    public RemoteCacheRestore(RemoteCacheManager rcm) {
        this.remoteCacheManager = rcm;
    }

    public boolean canFix() {
        if (!this.canFix) {
            return this.canFix;
        }
        String registry = "//" + this.remoteCacheManager.host + ":" + this.remoteCacheManager.port + "/" + this.remoteCacheManager.service;
        if (log.isInfoEnabled()) {
            log.info((Object)("looking up server [" + registry + "]"));
        }
        try {
            this.remoteObj = Naming.lookup(registry);
            if (log.isInfoEnabled()) {
                log.info((Object)("Found server " + this.remoteObj));
            }
        }
        catch (Exception ex) {
            log.error((Object)("host=" + this.remoteCacheManager.host + "; port" + this.remoteCacheManager.port + "; service=" + this.remoteCacheManager.service));
            this.canFix = false;
        }
        return this.canFix;
    }

    public void fix() {
        if (!this.canFix) {
            return;
        }
        this.remoteCacheManager.fixCaches((IRemoteCacheService)this.remoteObj, (IRemoteCacheObserver)this.remoteObj);
        if (log.isInfoEnabled()) {
            String msg = "Remote connection to //" + this.remoteCacheManager.host + ":" + this.remoteCacheManager.port + "/" + this.remoteCacheManager.service + " resumed.";
            this.remoteCacheManager.logApplicationEvent("RemoteCacheRestore", "fix", msg);
            log.info((Object)msg);
        }
    }
}

