/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.jcs.auxiliary.AbstractAuxiliaryCache;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.logging.behavior.ICacheEvent;

public abstract class AbstractAuxiliaryCacheEventLogging
extends AbstractAuxiliaryCache {
    private static final long serialVersionUID = -3921738303365238919L;

    public void update(ICacheElement cacheElement) throws IOException {
        this.updateWithEventLogging(cacheElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateWithEventLogging(ICacheElement cacheElement) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(cacheElement, "update");
        try {
            this.processUpdate(cacheElement);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract void processUpdate(ICacheElement var1) throws IOException;

    public ICacheElement get(Serializable key) throws IOException {
        return this.getWithEventLogging(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ICacheElement getWithEventLogging(Serializable key) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(this.getCacheName(), key, "get");
        try {
            ICacheElement iCacheElement = this.processGet(key);
            return iCacheElement;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract ICacheElement processGet(Serializable var1) throws IOException;

    public Map getMultiple(Set keys) throws IOException {
        return this.getMultipleWithEventLogging(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map getMultipleWithEventLogging(Set keys) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(this.getCacheName(), (Serializable)((Object)keys), "getMultiple");
        try {
            Map map = this.processGetMultiple(keys);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract Map processGetMultiple(Set var1) throws IOException;

    public Map getMatching(String pattern) throws IOException {
        return this.getMatchingWithEventLogging(pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map getMatchingWithEventLogging(String pattern) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(this.getCacheName(), (Serializable)((Object)pattern), "getMatching");
        try {
            Map map = this.processGetMatching(pattern);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract Map processGetMatching(String var1) throws IOException;

    public boolean remove(Serializable key) throws IOException {
        return this.removeWithEventLogging(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removeWithEventLogging(Serializable key) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(this.getCacheName(), key, "remove");
        try {
            boolean bl = this.processRemove(key);
            return bl;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract boolean processRemove(Serializable var1) throws IOException;

    public void removeAll() throws IOException {
        this.removeAllWithEventLogging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeAllWithEventLogging() throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(this.getCacheName(), (Serializable)((Object)"all"), "removeAll");
        try {
            this.processRemoveAll();
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract void processRemoveAll() throws IOException;

    public void dispose() throws IOException {
        this.disposeWithEventLogging();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void disposeWithEventLogging() throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(this.getCacheName(), (Serializable)((Object)"none"), "dispose");
        try {
            this.processDispose();
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected abstract void processDispose() throws IOException;
}

