/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccess;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccessFactory;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccessManager;
import org.apache.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;
import org.apache.jcs.utils.serialization.StandardSerializer;

public class JDBCDiskCache
extends AbstractDiskCache {
    private static final Log log = LogFactory.getLog((Class)JDBCDiskCache.class);
    private static final long serialVersionUID = -7169488308515823492L;
    private IElementSerializer elementSerializer = new StandardSerializer();
    private JDBCDiskCacheAttributes jdbcDiskCacheAttributes;
    private int updateCount = 0;
    private int getCount = 0;
    private int getMatchingCount = 0;
    private static final int LOG_INTERVAL = 100;
    private JDBCDiskCachePoolAccess poolAccess = null;
    private TableState tableState;

    public JDBCDiskCache(JDBCDiskCacheAttributes cattr, TableState tableState, ICompositeCacheManager compositeCacheManager) {
        super(cattr);
        this.setTableState(tableState);
        this.setJdbcDiskCacheAttributes(cattr);
        if (log.isInfoEnabled()) {
            log.info((Object)("jdbcDiskCacheAttributes = " + this.getJdbcDiskCacheAttributes()));
        }
        this.setPoolAccess(this.initializePoolAccess(cattr, compositeCacheManager));
        this.alive = true;
    }

    protected JDBCDiskCachePoolAccess initializePoolAccess(JDBCDiskCacheAttributes cattr, ICompositeCacheManager compositeCacheManager) {
        JDBCDiskCachePoolAccess poolAccess = null;
        if (cattr.getConnectionPoolName() != null) {
            JDBCDiskCachePoolAccessManager manager = JDBCDiskCachePoolAccessManager.getInstance(compositeCacheManager.getConfigurationProperties());
            poolAccess = manager.getJDBCDiskCachePoolAccess(cattr.getConnectionPoolName());
        } else {
            try {
                poolAccess = JDBCDiskCachePoolAccessFactory.createPoolAccess(cattr);
            }
            catch (Exception e) {
                this.logError(this.getAuxiliaryCacheAttributes().getName(), "initializePoolAccess", e.getMessage() + " URL: " + this.getDiskLocation());
                log.error((Object)"Problem getting connection.", (Throwable)e);
            }
        }
        return poolAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processUpdate(ICacheElement ce) {
        Connection con;
        this.incrementUpdateCount();
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating, ce = " + ce));
        }
        try {
            con = this.getPoolAccess().getConnection();
        }
        catch (SQLException e) {
            log.error((Object)"Problem getting conenction.", (Throwable)e);
            return;
        }
        try {
            byte[] element;
            Statement sStatement = null;
            try {
                sStatement = con.createStatement();
                this.alive = true;
            }
            catch (SQLException e) {
                log.error((Object)"Problem creating statement.", (Throwable)e);
                this.alive = false;
            }
            finally {
                try {
                    sStatement.close();
                }
                catch (SQLException e) {
                    log.error((Object)"Problem closing statement.", (Throwable)e);
                }
            }
            if (!this.alive) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Disk is not alive, aborting put.");
                }
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Putting [" + ce.getKey() + "] on disk."));
            }
            try {
                element = this.serialize(ce);
            }
            catch (IOException e) {
                log.error((Object)"Could not serialize element", (Throwable)e);
                try {
                    con.close();
                }
                catch (SQLException e2) {
                    log.error((Object)"Problem closing connection.", (Throwable)e2);
                }
                return;
            }
            this.insertOrUpdate(ce, con, element);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Problem closing connection.", (Throwable)e);
            }
        }
        if (log.isInfoEnabled() && this.updateCount % 100 == 0) {
            log.info((Object)("Update Count [" + this.updateCount + "]"));
        }
    }

    private void insertOrUpdate(ICacheElement ce, Connection con, byte[] element) {
        boolean exists = false;
        if (this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) {
            exists = this.doesElementExist(ce);
        }
        if (!exists) {
            exists = this.insertRow(ce, con, element);
        }
        if (exists) {
            this.updateRow(ce, con, element);
        }
    }

    private boolean insertRow(ICacheElement ce, Connection con, byte[] element) {
        boolean exists;
        block6: {
            exists = false;
            try {
                String sqlI = "insert into " + this.getJdbcDiskCacheAttributes().getTableName() + " (CACHE_KEY, REGION, ELEMENT, MAX_LIFE_SECONDS, IS_ETERNAL, CREATE_TIME, CREATE_TIME_SECONDS, SYSTEM_EXPIRE_TIME_SECONDS) " + " values (?, ?, ?, ?, ?, ?, ?, ?)";
                PreparedStatement psInsert = con.prepareStatement(sqlI);
                psInsert.setString(1, (String)((Object)ce.getKey()));
                psInsert.setString(2, this.getCacheName());
                psInsert.setBytes(3, element);
                psInsert.setLong(4, ce.getElementAttributes().getMaxLifeSeconds());
                if (ce.getElementAttributes().getIsEternal()) {
                    psInsert.setString(5, "T");
                } else {
                    psInsert.setString(5, "F");
                }
                Date createTime = new Date(ce.getElementAttributes().getCreateTime());
                psInsert.setDate(6, createTime);
                long now = System.currentTimeMillis() / 1000L;
                psInsert.setLong(7, now);
                long expireTime = now + ce.getElementAttributes().getMaxLifeSeconds();
                psInsert.setLong(8, expireTime);
                psInsert.execute();
                psInsert.close();
            }
            catch (SQLException e) {
                if (e.toString().indexOf("Violation of unique index") != -1 || e.getMessage().indexOf("Violation of unique index") != -1 || e.getMessage().indexOf("Duplicate entry") != -1) {
                    exists = true;
                } else {
                    log.error((Object)"Could not insert element", (Throwable)e);
                }
                if (exists || this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) break block6;
                exists = this.doesElementExist(ce);
            }
        }
        return exists;
    }

    private void updateRow(ICacheElement ce, Connection con, byte[] element) {
        String sqlU = null;
        try {
            sqlU = "update " + this.getJdbcDiskCacheAttributes().getTableName() + " set ELEMENT  = ?, CREATE_TIME = ?, CREATE_TIME_SECONDS = ?, " + " SYSTEM_EXPIRE_TIME_SECONDS = ? " + " where CACHE_KEY = ? and REGION = ?";
            PreparedStatement psUpdate = con.prepareStatement(sqlU);
            psUpdate.setBytes(1, element);
            Date createTime = new Date(ce.getElementAttributes().getCreateTime());
            psUpdate.setDate(2, createTime);
            long now = System.currentTimeMillis() / 1000L;
            psUpdate.setLong(3, now);
            long expireTime = now + ce.getElementAttributes().getMaxLifeSeconds();
            psUpdate.setLong(4, expireTime);
            psUpdate.setString(5, (String)((Object)ce.getKey()));
            psUpdate.setString(6, this.getCacheName());
            psUpdate.execute();
            psUpdate.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("ran update " + sqlU));
            }
        }
        catch (SQLException e2) {
            log.error((Object)("e2 sql [" + sqlU + "] Exception: "), (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doesElementExist(ICacheElement ce) {
        Connection con;
        boolean exists = false;
        try {
            con = this.getPoolAccess().getConnection();
        }
        catch (SQLException e) {
            log.error((Object)"Problem getting conenction.", (Throwable)e);
            return exists;
        }
        Statement psSelect = null;
        try {
            String sqlS = "select CACHE_KEY from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
            psSelect = con.prepareStatement(sqlS);
            psSelect.setString(1, this.getCacheName());
            psSelect.setString(2, (String)((Object)ce.getKey()));
            ResultSet rs = psSelect.executeQuery();
            if (rs.next()) {
                exists = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + ce.getKey() + "] existing status is " + exists));
            }
            rs.close();
        }
        catch (SQLException e) {
            log.error((Object)"Problem looking for item before insert.", (Throwable)e);
        }
        finally {
            try {
                if (psSelect != null) {
                    psSelect.close();
                }
                psSelect.close();
            }
            catch (SQLException e1) {
                log.error((Object)"Problem closing statement.", (Throwable)e1);
            }
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Problem closing connection.", (Throwable)e);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICacheElement processGet(Serializable key) {
        this.incrementGetCount();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting [" + key + "] from disk"));
        }
        if (!this.alive) {
            return null;
        }
        ICacheElement obj = null;
        byte[] data = null;
        try {
            String selectString = "select ELEMENT from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
            Connection con = this.getPoolAccess().getConnection();
            try {
                PreparedStatement psSelect = null;
                try {
                    psSelect = con.prepareStatement(selectString);
                    psSelect.setString(1, this.getCacheName());
                    psSelect.setString(2, key.toString());
                    ResultSet rs = psSelect.executeQuery();
                    try {
                        if (rs.next()) {
                            data = rs.getBytes(1);
                        }
                        if (data != null) {
                            try {
                                obj = (ICacheElement)this.getElementSerializer().deSerialize(data);
                            }
                            catch (IOException ioe) {
                                log.error((Object)("Problem getting item for key [" + key + "]"), (Throwable)ioe);
                            }
                            catch (Exception e) {
                                log.error((Object)("Problem getting item for key [" + key + "]"), (Throwable)e);
                            }
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                        rs.close();
                    }
                }
                finally {
                    if (psSelect != null) {
                        psSelect.close();
                    }
                    psSelect.close();
                }
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        }
        catch (SQLException sqle) {
            log.error((Object)("Caught a SQL exception trying to get the item for key [" + key + "]"), (Throwable)sqle);
        }
        if (log.isInfoEnabled() && this.getCount % 100 == 0) {
            log.info((Object)("Get Count [" + this.getCount + "]"));
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map processGetMatching(String pattern) {
        HashMap<String, ICacheElement> results;
        block22: {
            this.incrementGetMatchingCount();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting [" + pattern + "] from disk"));
            }
            if (!this.alive) {
                return null;
            }
            results = new HashMap<String, ICacheElement>();
            try {
                String selectString = "select CACHE_KEY, ELEMENT from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY like ?";
                Connection con = this.getPoolAccess().getConnection();
                try {
                    PreparedStatement psSelect = null;
                    try {
                        psSelect = con.prepareStatement(selectString);
                        psSelect.setString(1, this.getCacheName());
                        psSelect.setString(2, this.constructLikeParameterFromPattern(pattern));
                        ResultSet rs = psSelect.executeQuery();
                        block14: while (true) {
                            while (rs.next()) {
                                String key = rs.getString(1);
                                byte[] data = rs.getBytes(2);
                                if (data == null) continue;
                                try {
                                    ICacheElement value = (ICacheElement)this.getElementSerializer().deSerialize(data);
                                    results.put(key, value);
                                    continue block14;
                                }
                                catch (IOException ioe) {
                                    log.error((Object)("Problem getting items for pattern [" + pattern + "]"), (Throwable)ioe);
                                }
                                catch (Exception e) {
                                    log.error((Object)("Problem getting items for pattern [" + pattern + "]"), (Throwable)e);
                                }
                            }
                            break block22;
                            {
                                continue block14;
                                break;
                            }
                            break;
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                            rs.close();
                        }
                    }
                    finally {
                        if (psSelect != null) {
                            psSelect.close();
                        }
                        psSelect.close();
                    }
                }
                finally {
                    if (con != null) {
                        con.close();
                    }
                }
            }
            catch (SQLException sqle) {
                log.error((Object)("Caught a SQL exception trying to get items for pattern [" + pattern + "]"), (Throwable)sqle);
            }
        }
        if (log.isInfoEnabled() && this.getMatchingCount % 100 == 0) {
            log.info((Object)("Get Matching Count [" + this.getMatchingCount + "]"));
        }
        return results;
    }

    public String constructLikeParameterFromPattern(String pattern) {
        pattern = pattern.replaceAll("\\.\\+", "%");
        pattern = pattern.replaceAll("\\.", "_");
        if (log.isDebugEnabled()) {
            log.debug((Object)("pattern = [" + pattern + "]"));
        }
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processRemove(Serializable key) {
        String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
        try {
            boolean partial = false;
            if (key instanceof String && key.toString().endsWith(":")) {
                sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY like ?";
                partial = true;
            }
            Connection con = this.getPoolAccess().getConnection();
            PreparedStatement psSelect = null;
            try {
                psSelect = con.prepareStatement(sql);
                psSelect.setString(1, this.getCacheName());
                if (partial) {
                    psSelect.setString(2, key.toString() + "%");
                } else {
                    psSelect.setString(2, key.toString());
                }
                psSelect.executeUpdate();
                this.alive = true;
            }
            catch (SQLException e) {
                log.error((Object)("Problem creating statement. sql [" + sql + "]"), (Throwable)e);
                this.alive = false;
            }
            finally {
                try {
                    if (psSelect != null) {
                        psSelect.close();
                    }
                    con.close();
                }
                catch (SQLException e1) {
                    log.error((Object)"Problem closing statement.", (Throwable)e1);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem updating cache.", (Throwable)e);
            this.reset();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRemoveAll() {
        if (this.jdbcDiskCacheAttributes.isAllowRemoveAll()) {
            try {
                String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ?";
                Connection con = this.getPoolAccess().getConnection();
                PreparedStatement psDelete = null;
                try {
                    psDelete = con.prepareStatement(sql);
                    psDelete.setString(1, this.getCacheName());
                    this.alive = true;
                    psDelete.executeUpdate();
                }
                catch (SQLException e) {
                    log.error((Object)"Problem creating statement.", (Throwable)e);
                    this.alive = false;
                }
                finally {
                    try {
                        if (psDelete != null) {
                            psDelete.close();
                        }
                        con.close();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Problem closing statement.", (Throwable)e1);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem removing all.", (Throwable)e);
                this.reset();
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"RemoveAll was requested but the request was not fulfilled: allowRemoveAll is set to false.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int deleteExpired() {
        int deleted = 0;
        try {
            this.getTableState().setState(1);
            long now = System.currentTimeMillis() / 1000L;
            String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where IS_ETERNAL = ? and REGION = ? and ? > SYSTEM_EXPIRE_TIME_SECONDS";
            Connection con = this.getPoolAccess().getConnection();
            PreparedStatement psDelete = null;
            try {
                psDelete = con.prepareStatement(sql);
                psDelete.setString(1, "F");
                psDelete.setString(2, this.getCacheName());
                psDelete.setLong(3, now);
                this.alive = true;
                deleted = psDelete.executeUpdate();
            }
            catch (SQLException e) {
                log.error((Object)"Problem creating statement.", (Throwable)e);
                this.alive = false;
            }
            finally {
                try {
                    if (psDelete != null) {
                        psDelete.close();
                    }
                    con.close();
                }
                catch (SQLException e1) {
                    log.error((Object)"Problem closing statement.", (Throwable)e1);
                }
            }
            this.logApplicationEvent(this.getAuxiliaryCacheAttributes().getName(), "deleteExpired", "Deleted expired elements.  URL: " + this.getDiskLocation());
        }
        catch (Exception e) {
            this.logError(this.getAuxiliaryCacheAttributes().getName(), "deleteExpired", e.getMessage() + " URL: " + this.getDiskLocation());
            log.error((Object)"Problem removing expired elements from the table.", (Throwable)e);
            this.reset();
        }
        finally {
            this.getTableState().setState(0);
        }
        return deleted;
    }

    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDispose() {
        ICacheEvent cacheEvent = this.createICacheEvent(this.cacheName, (Serializable)((Object)"none"), "dispose");
        try {
            try {
                this.getPoolAccess().shutdownDriver();
            }
            catch (Exception e) {
                log.error((Object)"Problem shutting down.", (Throwable)e);
            }
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Connection con;
        int size = 0;
        String selectString = "select count(*) from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ?";
        try {
            con = this.getPoolAccess().getConnection();
        }
        catch (SQLException e1) {
            log.error((Object)"Problem getting conenction.", (Throwable)e1);
            return size;
        }
        try {
            PreparedStatement psSelect = null;
            try {
                psSelect = con.prepareStatement(selectString);
                psSelect.setString(1, this.getCacheName());
                ResultSet rs = null;
                rs = psSelect.executeQuery();
                try {
                    if (rs.next()) {
                        size = rs.getInt(1);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    rs.close();
                }
            }
            finally {
                if (psSelect != null) {
                    psSelect.close();
                }
                psSelect.close();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Problem getting size.", (Throwable)e);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Problem closing connection.", (Throwable)e);
            }
        }
        return size;
    }

    protected byte[] serialize(Serializable obj) throws IOException {
        return this.getElementSerializer().serialize(obj);
    }

    public Set getGroupKeys(String groupName) {
        throw new UnsupportedOperationException("Groups not implemented.");
    }

    public void setElementSerializer(IElementSerializer elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    public IElementSerializer getElementSerializer() {
        return this.elementSerializer;
    }

    private synchronized void incrementUpdateCount() {
        ++this.updateCount;
    }

    private synchronized void incrementGetCount() {
        ++this.getCount;
    }

    private synchronized void incrementGetMatchingCount() {
        ++this.getMatchingCount;
    }

    protected void setJdbcDiskCacheAttributes(JDBCDiskCacheAttributes jdbcDiskCacheAttributes) {
        this.jdbcDiskCacheAttributes = jdbcDiskCacheAttributes;
    }

    protected JDBCDiskCacheAttributes getJdbcDiskCacheAttributes() {
        return this.jdbcDiskCacheAttributes;
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.getJdbcDiskCacheAttributes();
    }

    public IStats getStatistics() {
        IStats stats = super.getStatistics();
        stats.setTypeName("JDBC/Abstract Disk Cache");
        stats.getStatElements();
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Update Count");
        se.setData("" + this.updateCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Get Count");
        se.setData("" + this.getCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Get Matching Count");
        se.setData("" + this.getMatchingCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Size");
        se.setData("" + this.getSize());
        elems.add(se);
        se = new StatElement();
        se.setName("Active DB Connections");
        se.setData("" + this.getPoolAccess().getNumActiveInPool());
        elems.add(se);
        se = new StatElement();
        se.setName("Idle DB Connections");
        se.setData("" + this.getPoolAccess().getNumIdleInPool());
        elems.add(se);
        se = new StatElement();
        se.setName("DB URL");
        if (this.getPoolAccess() != null) {
            se.setData("" + this.getPoolAccess().getPoolUrl());
        } else {
            se.setData("" + this.getJdbcDiskCacheAttributes().getUrl());
        }
        elems.add(se);
        IStatElement[] eqSEs = stats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    protected String getTableName() {
        String name = "UNDEFINED";
        if (this.getJdbcDiskCacheAttributes() != null) {
            name = this.getJdbcDiskCacheAttributes().getTableName();
        }
        return name;
    }

    public void setTableState(TableState tableState) {
        this.tableState = tableState;
    }

    public TableState getTableState() {
        return this.tableState;
    }

    protected String getDiskLocation() {
        return this.jdbcDiskCacheAttributes.getUrl();
    }

    protected void setPoolAccess(JDBCDiskCachePoolAccess poolAccess) {
        this.poolAccess = poolAccess;
    }

    public JDBCDiskCachePoolAccess getPoolAccess() {
        return this.poolAccess;
    }

    public String toString() {
        return this.getStats();
    }
}

