/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.socket.tcp.discovery;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.socket.tcp.discovery.UDPDiscoveryService;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

public class UDPDiscoveryManager {
    private static final Log log = LogFactory.getLog((Class)UDPDiscoveryManager.class);
    private static UDPDiscoveryManager INSTANCE = new UDPDiscoveryManager();
    private Map services = new HashMap();

    private UDPDiscoveryManager() {
    }

    public static UDPDiscoveryManager getInstance() {
        return INSTANCE;
    }

    public synchronized UDPDiscoveryService getService(ITCPLateralCacheAttributes lca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        UDPDiscoveryService service = this.getService(lca.getUdpDiscoveryAddr(), lca.getUdpDiscoveryPort(), lca.getTcpListenerPort(), cacheMgr, cacheEventLogger, elementSerializer);
        service.setTcpLateralCacheAttributes(lca);
        return service;
    }

    private synchronized UDPDiscoveryService getService(String discoveryAddress, int discoveryPort, int servicePort, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        String key = discoveryAddress + ":" + discoveryPort;
        UDPDiscoveryService service = (UDPDiscoveryService)this.services.get(key);
        if (service == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating service for address:port [" + key + "]"));
            }
            service = new UDPDiscoveryService(discoveryAddress, discoveryPort, servicePort, cacheMgr, cacheEventLogger, elementSerializer);
            this.services.put(key, service);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Returning service [" + service + "] for key [" + key + "]"));
        }
        return service;
    }
}

