/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AbstractAuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheClient;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.CacheAdaptor;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class RemoteCacheNoWait
extends AbstractAuxiliaryCache {
    private static final long serialVersionUID = -3104089136003714717L;
    private static final Log log = LogFactory.getLog((Class)RemoteCacheNoWait.class);
    private final IRemoteCacheClient remoteCacheClient;
    private ICacheEventQueue cacheEventQueue;
    private int getCount = 0;
    private int getMatchingCount = 0;
    private int getMultipleCount = 0;
    private int removeCount = 0;
    private int putCount = 0;

    public RemoteCacheNoWait(IRemoteCacheClient cache) {
        this.remoteCacheClient = cache;
        CacheEventQueueFactory factory = new CacheEventQueueFactory();
        this.cacheEventQueue = factory.createCacheEventQueue(new CacheAdaptor(this.remoteCacheClient), this.remoteCacheClient.getListenerId(), this.remoteCacheClient.getCacheName(), this.remoteCacheClient.getAuxiliaryCacheAttributes().getEventQueuePoolName(), this.remoteCacheClient.getAuxiliaryCacheAttributes().getEventQueueType());
        if (this.remoteCacheClient.getStatus() == 3) {
            this.cacheEventQueue.destroy();
        }
    }

    public void update(ICacheElement element) throws IOException {
        ++this.putCount;
        try {
            this.cacheEventQueue.addPutEvent(element);
        }
        catch (IOException e) {
            log.error((Object)"Problem adding putEvent to queue.", (Throwable)e);
            this.cacheEventQueue.destroy();
            throw e;
        }
    }

    public ICacheElement get(Serializable key) throws IOException {
        ++this.getCount;
        try {
            return this.remoteCacheClient.get(key);
        }
        catch (UnmarshalException ue) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Retrying the get owing to UnmarshalException.");
            }
            try {
                return this.remoteCacheClient.get(key);
            }
            catch (IOException ex) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Failed in retrying the get for the second time. " + ex.getMessage()));
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        return null;
    }

    public Map getMatching(String pattern) throws IOException {
        ++this.getMatchingCount;
        try {
            return this.remoteCacheClient.getMatching(pattern);
        }
        catch (UnmarshalException ue) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Retrying the getMatching owing to UnmarshalException.");
            }
            try {
                return this.remoteCacheClient.getMatching(pattern);
            }
            catch (IOException ex) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Failed in retrying the getMatching for the second time. " + ex.getMessage()));
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        return Collections.EMPTY_MAP;
    }

    public Map getMultiple(Set keys) throws IOException {
        ++this.getMultipleCount;
        try {
            return this.remoteCacheClient.getMultiple(keys);
        }
        catch (UnmarshalException ue) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Retrying the getMultiple owing to UnmarshalException...");
            }
            try {
                return this.remoteCacheClient.getMultiple(keys);
            }
            catch (IOException ex) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Failed in retrying the getMultiple for the second time. " + ex.getMessage()));
                }
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        return new HashMap();
    }

    public Set getGroupKeys(String groupName) throws IOException {
        return this.remoteCacheClient.getGroupKeys(groupName);
    }

    public boolean remove(Serializable key) throws IOException {
        ++this.removeCount;
        try {
            this.cacheEventQueue.addRemoveEvent(key);
        }
        catch (IOException e) {
            log.error((Object)"Problem adding RemoveEvent to queue.", (Throwable)e);
            this.cacheEventQueue.destroy();
            throw e;
        }
        return false;
    }

    public void removeAll() throws IOException {
        try {
            this.cacheEventQueue.addRemoveAllEvent();
        }
        catch (IOException e) {
            log.error((Object)"Problem adding RemoveAllEvent to queue.", (Throwable)e);
            this.cacheEventQueue.destroy();
            throw e;
        }
    }

    public void dispose() {
        try {
            this.cacheEventQueue.addDisposeEvent();
        }
        catch (IOException e) {
            log.error((Object)"Problem adding DisposeEvent to queue.", (Throwable)e);
            this.cacheEventQueue.destroy();
        }
    }

    public int getSize() {
        return this.remoteCacheClient.getSize();
    }

    public int getCacheType() {
        return 4;
    }

    public int getStatus() {
        return this.cacheEventQueue.isWorking() ? this.remoteCacheClient.getStatus() : 3;
    }

    public String getCacheName() {
        return this.remoteCacheClient.getCacheName();
    }

    public void fixCache(IRemoteCacheService remote) {
        this.remoteCacheClient.fixCache(remote);
        this.resetEventQ();
    }

    public void resetEventQ() {
        ICacheEventQueue previousQueue = this.cacheEventQueue;
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.cacheEventQueue = fact.createCacheEventQueue(new CacheAdaptor(this.remoteCacheClient), this.remoteCacheClient.getListenerId(), this.remoteCacheClient.getCacheName(), this.remoteCacheClient.getAuxiliaryCacheAttributes().getEventQueuePoolName(), this.remoteCacheClient.getAuxiliaryCacheAttributes().getEventQueueType());
        if (previousQueue.isWorking()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("resetEventQ, previous queue has [" + previousQueue.size() + "] items queued up."));
            }
            previousQueue.destroy();
        }
    }

    protected IRemoteCacheClient getRemoteCache() {
        return this.remoteCacheClient;
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.remoteCacheClient.getAuxiliaryCacheAttributes();
    }

    protected ICacheEventQueue getCacheEventQueue() {
        return this.cacheEventQueue;
    }

    public String toString() {
        return this.getStats() + "\n" + this.remoteCacheClient.toString();
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Status");
        int status = this.getStatus();
        if (status == 3) {
            se.setData("ERROR");
        } else if (status == 1) {
            se.setData("ALIVE");
        } else if (status == 2) {
            se.setData("DISPOSED");
        } else {
            se.setData("" + status);
        }
        elems.add(se);
        IStats cStats = this.remoteCacheClient.getStatistics();
        if (cStats != null) {
            IStatElement[] cSEs = cStats.getStatElements();
            List<IStatElement> cL = Arrays.asList(cSEs);
            elems.addAll(cL);
        }
        IStats eqStats = this.cacheEventQueue.getStatistics();
        IStatElement[] eqSEs = eqStats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        se = new StatElement();
        se.setName("Get Count");
        se.setData("" + this.getCount);
        elems.add(se);
        se = new StatElement();
        se.setName("GetMatching Count");
        se.setData("" + this.getMatchingCount);
        elems.add(se);
        se = new StatElement();
        se.setName("GetMultiple Count");
        se.setData("" + this.getMultipleCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Remove Count");
        se.setData("" + this.removeCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Put Count");
        se.setData("" + this.putCount);
        elems.add(se);
        IStatElement[] ses = elems.toArray(new StatElement[elems.size()]);
        stats.setStatElements(ses);
        return stats;
    }

    public String getEventLoggingExtraInfo() {
        return "Remote Cache No Wait";
    }
}

