/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.util;

import java.io.Serializable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.jcs.engine.behavior.ICacheElement;

public class RemoteCacheRequestFactory {
    private static final Log log = LogFactory.getLog((Class)RemoteCacheRequestFactory.class);

    public static RemoteCacheRequest createGetRequest(String cacheName, Serializable key, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setKey(key);
        request.setRequesterId(requesterId);
        request.setRequestType((byte)1);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static RemoteCacheRequest createGetMatchingRequest(String cacheName, String pattern, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setPattern(pattern);
        request.setRequesterId(requesterId);
        request.setRequestType((byte)3);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static RemoteCacheRequest createGetMultipleRequest(String cacheName, Set keys, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setKeySet(keys);
        request.setRequesterId(requesterId);
        request.setRequestType((byte)2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static RemoteCacheRequest createRemoveRequest(String cacheName, Serializable key, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setKey(key);
        request.setRequesterId(requesterId);
        request.setRequestType((byte)5);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static RemoteCacheRequest createGetGroupKeysRequest(String cacheName, String groupName, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setKey((Serializable)((Object)groupName));
        request.setRequesterId(requesterId);
        request.setRequestType((byte)7);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static RemoteCacheRequest createRemoveAllRequest(String cacheName, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setRequesterId(requesterId);
        request.setRequestType((byte)6);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static RemoteCacheRequest createDisposeRequest(String cacheName, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setCacheName(cacheName);
        request.setRequesterId(requesterId);
        request.setRequestType((byte)8);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static RemoteCacheRequest createUpdateRequest(ICacheElement cacheElement, long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        if (cacheElement != null) {
            request.setCacheName(cacheElement.getCacheName());
            request.setCacheElement(cacheElement);
            request.setKey(cacheElement.getKey());
        } else {
            log.error((Object)"Can't create a proper update request for a null cache element.");
        }
        request.setRequesterId(requesterId);
        request.setRequestType((byte)4);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }

    public static RemoteCacheRequest createAliveCheckRequest(long requesterId) {
        RemoteCacheRequest request = new RemoteCacheRequest();
        request.setRequesterId(requesterId);
        request.setRequestType((byte)0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created: " + request));
        }
        return request;
    }
}

