/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine;

import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.ICache;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheListener;

public class CacheAdaptor
implements ICacheListener {
    private static final Log log = LogFactory.getLog((Class)CacheAdaptor.class);
    private final ICache cache;
    protected long listenerId = 0L;

    public void setListenerId(long id) throws IOException {
        this.listenerId = id;
        log.debug((Object)("listenerId = " + id));
    }

    public long getListenerId() throws IOException {
        return this.listenerId;
    }

    public CacheAdaptor(ICache cache) {
        this.cache = cache;
    }

    public void handlePut(ICacheElement item) throws IOException {
        try {
            this.cache.update(item);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleRemove(String cacheName, Serializable key) throws IOException {
        this.cache.remove(key);
    }

    public void handleRemoveAll(String cacheName) throws IOException {
        this.cache.removeAll();
    }

    public void handleDispose(String cacheName) throws IOException {
        this.cache.dispose();
    }
}

