/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.access;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.access.behavior.ICacheAccess;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.access.exception.InvalidArgumentException;
import org.apache.jcs.access.exception.InvalidHandleException;
import org.apache.jcs.access.exception.ObjectExistsException;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.stats.behavior.ICacheStats;

public class CacheAccess
implements ICacheAccess {
    private static final Log log = LogFactory.getLog((Class)CacheAccess.class);
    private static CompositeCacheManager cacheMgr;
    protected CompositeCache cacheControl;

    public CacheAccess(CompositeCache cacheControl) {
        this.cacheControl = cacheControl;
    }

    public static CacheAccess defineRegion(String name) throws CacheException {
        CacheAccess.ensureCacheManager();
        return new CacheAccess(cacheMgr.getCache(name));
    }

    public static CacheAccess defineRegion(String name, ICompositeCacheAttributes cattr) throws CacheException {
        CacheAccess.ensureCacheManager();
        return new CacheAccess(cacheMgr.getCache(name, cattr));
    }

    public static CacheAccess defineRegion(String name, ICompositeCacheAttributes cattr, IElementAttributes attr) throws CacheException {
        CacheAccess.ensureCacheManager();
        return new CacheAccess(cacheMgr.getCache(name, cattr, attr));
    }

    public static CacheAccess getAccess(String region) throws CacheException {
        CacheAccess.ensureCacheManager();
        return new CacheAccess(cacheMgr.getCache(region));
    }

    public static CacheAccess getAccess(String region, ICompositeCacheAttributes icca) throws CacheException {
        CacheAccess.ensureCacheManager();
        return new CacheAccess(cacheMgr.getCache(region, icca));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void ensureCacheManager() {
        Class clazz = CacheAccess.class;
        synchronized (clazz) {
            if (cacheMgr == null) {
                cacheMgr = CompositeCacheManager.getInstance();
            }
        }
    }

    public Object get(Object name) {
        ICacheElement element = this.cacheControl.get((Serializable)name);
        return element != null ? element.getVal() : null;
    }

    public HashMap getMatching(String pattern) {
        HashMap unwrappedResults = new HashMap();
        Map wrappedResults = this.cacheControl.getMatching(pattern);
        if (wrappedResults != null) {
            Set keySet = wrappedResults.keySet();
            Iterator it = keySet.iterator();
            while (it.hasNext()) {
                Object key = it.next();
                ICacheElement element = (ICacheElement)wrappedResults.get(key);
                if (element == null) continue;
                unwrappedResults.put(key, element.getVal());
            }
        }
        return unwrappedResults;
    }

    public ICacheElement getCacheElement(Object name) {
        return this.cacheControl.get((Serializable)name);
    }

    public Map getCacheElements(Set names) {
        return this.cacheControl.getMultiple(names);
    }

    public Map getMatchingCacheElements(String pattern) {
        return this.cacheControl.getMatching(pattern);
    }

    public void putSafe(Object key, Object value) throws CacheException {
        if (this.cacheControl.get((Serializable)key) != null) {
            throw new ObjectExistsException("putSafe failed.  Object exists in the cache for key [" + key + "].  Remove first or use a non-safe put to override the value.");
        }
        this.put(key, value);
    }

    public void put(Object name, Object obj) throws CacheException {
        this.put(name, obj, this.cacheControl.getElementAttributes());
    }

    public void put(Object key, Object val, IElementAttributes attr) throws CacheException {
        if (key == null) {
            throw new InvalidArgumentException("Key must not be null");
        }
        if (val == null) {
            throw new InvalidArgumentException("Value must not be null");
        }
        try {
            CacheElement ce = new CacheElement(this.cacheControl.getCacheName(), (Serializable)key, (Serializable)val);
            ce.setElementAttributes(attr);
            this.cacheControl.update(ce);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    public void destroy() throws CacheException {
        try {
            this.cacheControl.removeAll();
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    public void remove() throws CacheException {
        this.clear();
    }

    public void clear() throws CacheException {
        try {
            this.cacheControl.removeAll();
        }
        catch (IOException e) {
            throw new CacheException(e);
        }
    }

    public void destroy(Object name) throws CacheException {
        this.cacheControl.remove((Serializable)name);
    }

    public void remove(Object name) throws CacheException {
        this.cacheControl.remove((Serializable)name);
    }

    public void resetElementAttributes(IElementAttributes attr) throws CacheException, InvalidHandleException {
        this.cacheControl.setElementAttributes(attr);
    }

    public void setDefaultElementAttributes(IElementAttributes attr) throws CacheException {
        this.cacheControl.setElementAttributes(attr);
    }

    public void resetElementAttributes(Object name, IElementAttributes attr) throws CacheException, InvalidHandleException {
        ICacheElement element = this.cacheControl.get((Serializable)name);
        if (element == null) {
            throw new InvalidHandleException("Object for name [" + name + "] is not in the cache");
        }
        this.put(element.getKey(), element.getVal(), attr);
    }

    public IElementAttributes getElementAttributes() throws CacheException {
        return this.cacheControl.getElementAttributes();
    }

    public IElementAttributes getDefaultElementAttributes() throws CacheException {
        return this.cacheControl.getElementAttributes();
    }

    public IElementAttributes getElementAttributes(Object name) throws CacheException {
        IElementAttributes attr = null;
        try {
            attr = this.cacheControl.getElementAttributes((Serializable)name);
        }
        catch (IOException ioe) {
            log.error((Object)"Failure getting element attributes", (Throwable)ioe);
        }
        return attr;
    }

    public ICacheStats getStatistics() {
        return this.cacheControl.getStatistics();
    }

    public String getStats() {
        return this.cacheControl.getStats();
    }

    public void dispose() {
        this.cacheControl.dispose();
    }

    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cacheControl.getCacheAttributes();
    }

    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        this.cacheControl.setCacheAttributes(cattr);
    }

    public int freeMemoryElements(int numberToFree) throws CacheException {
        int numFreed = -1;
        try {
            numFreed = this.cacheControl.getMemoryCache().freeElements(numberToFree);
        }
        catch (IOException ioe) {
            String message = "Failure freeing memory elements.  ";
            log.error((Object)message, (Throwable)ioe);
            throw new CacheException(message + ioe.getMessage());
        }
        return numFreed;
    }
}

