/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.block;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.utils.serialization.StandardSerializer;
import org.apache.jcs.utils.struct.SingleLinkedList;

public class BlockDisk {
    private static final Log log = LogFactory.getLog((Class)BlockDisk.class);
    public static final byte HEADER_SIZE_BYTES = 4;
    private static final int DEFAULT_BLOCK_SIZE_BYTES = 4096;
    private int blockSizeBytes = 4096;
    private int numberOfBlocks = 0;
    private SingleLinkedList emptyBlocks = new SingleLinkedList();
    protected IElementSerializer elementSerializer = new StandardSerializer();
    private final String filepath;
    private RandomAccessFile raf;
    private long putBytes = 0L;
    private long putCount = 0L;

    public BlockDisk(File file, IElementSerializer elementSerializer) throws FileNotFoundException {
        this(file, 4096);
        if (log.isInfoEnabled()) {
            log.info((Object)"Used default block size [4096]");
        }
        this.elementSerializer = elementSerializer;
    }

    public BlockDisk(File file, int blockSizeBytes) throws FileNotFoundException {
        this.filepath = file.getAbsolutePath();
        this.raf = new RandomAccessFile(this.filepath, "rw");
        if (log.isInfoEnabled()) {
            log.info((Object)("Constructing BlockDisk, blockSizeBytes [" + blockSizeBytes + "]"));
        }
        this.blockSizeBytes = blockSizeBytes;
    }

    public BlockDisk(File file, int blockSizeBytes, IElementSerializer elementSerializer) throws FileNotFoundException {
        this.filepath = file.getAbsolutePath();
        this.raf = new RandomAccessFile(this.filepath, "rw");
        if (log.isInfoEnabled()) {
            log.info((Object)("Constructing BlockDisk, blockSizeBytes [" + blockSizeBytes + "]"));
        }
        this.blockSizeBytes = blockSizeBytes;
        this.elementSerializer = elementSerializer;
    }

    protected int[] write(Serializable object) throws IOException {
        byte[] data = this.elementSerializer.serialize(object);
        if (log.isDebugEnabled()) {
            log.debug((Object)("write, total pre-chunking data.length = " + data.length));
        }
        this.addToPutBytes(data.length);
        this.incrementPutCount();
        int numBlocksNeeded = this.calculateTheNumberOfBlocksNeeded(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("numBlocksNeeded = " + numBlocksNeeded));
        }
        int[] blocks = new int[numBlocksNeeded];
        for (int i = 0; i < numBlocksNeeded; i = (int)((short)(i + 1))) {
            Integer emptyBlock = (Integer)this.emptyBlocks.takeFirst();
            blocks[i] = emptyBlock != null ? emptyBlock.intValue() : this.takeNextBlock();
        }
        byte[][] chunks = this.getBlockChunks(data, numBlocksNeeded);
        for (int i = 0; i < numBlocksNeeded; i = (int)((byte)(i + 1))) {
            int position = this.calculateByteOffsetForBlock(blocks[i]);
            this.write(position, chunks[i]);
        }
        return blocks;
    }

    protected byte[][] getBlockChunks(byte[] complete, int numBlocksNeeded) {
        byte[][] chunks = new byte[numBlocksNeeded][];
        if (numBlocksNeeded == 1) {
            chunks[0] = complete;
        } else {
            int maxChunkSize = this.blockSizeBytes - 4;
            int totalBytes = complete.length;
            int totalUsed = 0;
            for (int i = 0; i < numBlocksNeeded; i = (int)((short)(i + 1))) {
                int chunkSize = Math.min(maxChunkSize, totalBytes - totalUsed);
                byte[] chunk = new byte[chunkSize];
                System.arraycopy(complete, totalUsed, chunk, 0, chunkSize);
                chunks[i] = chunk;
                totalUsed += chunkSize;
            }
        }
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean write(long position, byte[] data) throws IOException {
        BlockDisk blockDisk = this;
        synchronized (blockDisk) {
            this.raf.seek(position);
            this.raf.writeInt(data.length);
            this.raf.write(data, 0, data.length);
        }
        return true;
    }

    protected Serializable read(int[] blockNumbers) throws IOException, ClassNotFoundException {
        byte[] data = null;
        if (blockNumbers.length == 1) {
            data = this.readBlock(blockNumbers[0]);
        } else {
            data = new byte[]{};
            for (int i = 0; i < blockNumbers.length; i = (int)((short)(i + 1))) {
                byte[] chunk = this.readBlock(blockNumbers[i]);
                byte[] newTotal = new byte[data.length + chunk.length];
                System.arraycopy(data, 0, newTotal, 0, data.length);
                System.arraycopy(chunk, 0, newTotal, data.length, chunk.length);
                data = newTotal;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("read, total post combination data.length = " + data.length));
        }
        return (Serializable)this.elementSerializer.deSerialize(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBlock(int block) throws IOException {
        byte[] data = null;
        int datalen = 0;
        BlockDisk blockDisk = this;
        synchronized (blockDisk) {
            String message = null;
            boolean corrupted = false;
            long fileLength = this.raf.length();
            int position = this.calculateByteOffsetForBlock(block);
            if ((long)position > fileLength) {
                corrupted = true;
                message = "Record " + position + " starts past EOF.";
            } else {
                this.raf.seek(position);
                datalen = this.raf.readInt();
                if ((long)(position + datalen) > fileLength) {
                    corrupted = true;
                    message = "Record " + position + " exceeds file length.";
                }
            }
            if (corrupted) {
                log.warn((Object)("\n The file is corrupt: \n " + message));
                throw new IOException("The File Is Corrupt, need to reset");
            }
            data = new byte[datalen];
            this.raf.readFully(data);
        }
        return data;
    }

    protected void freeBlocks(int[] blocksToFree) {
        if (blocksToFree != null) {
            for (int i = 0; i < blocksToFree.length; i = (int)((short)(i + 1))) {
                this.emptyBlocks.addLast(new Integer(blocksToFree[i]));
            }
        }
    }

    private synchronized void addToPutBytes(long length) {
        this.putBytes += length;
    }

    private synchronized void incrementPutCount() {
        ++this.putCount;
    }

    private synchronized int takeNextBlock() {
        return this.numberOfBlocks++;
    }

    protected int calculateByteOffsetForBlock(int block) {
        return block * this.blockSizeBytes;
    }

    protected int calculateTheNumberOfBlocksNeeded(byte[] data) {
        int dataLength = data.length;
        int oneBlock = this.blockSizeBytes - 4;
        if (dataLength <= oneBlock) {
            return 1;
        }
        int dividend = dataLength / oneBlock;
        if (dataLength % oneBlock != 0) {
            ++dividend;
        }
        return dividend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long length() throws IOException {
        BlockDisk blockDisk = this;
        synchronized (blockDisk) {
            return this.raf.length();
        }
    }

    protected synchronized void close() throws IOException {
        this.raf.close();
    }

    protected int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    protected int getBlockSizeBytes() {
        return this.blockSizeBytes;
    }

    protected long getAveragePutSizeBytes() {
        if (this.putCount == 0L) {
            return 0L;
        }
        return this.putBytes / this.putCount;
    }

    protected int getEmptyBlocks() {
        return this.emptyBlocks.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\nBlock Disk ");
        buf.append("\n  Filepath [" + this.filepath + "]");
        buf.append("\n  NumberOfBlocks [" + this.getNumberOfBlocks() + "]");
        buf.append("\n  BlockSizeBytes [" + this.getBlockSizeBytes() + "]");
        buf.append("\n  Put Bytes [" + this.putBytes + "]");
        buf.append("\n  Put Count [" + this.putCount + "]");
        buf.append("\n  Average Size [" + this.getAveragePutSizeBytes() + "]");
        buf.append("\n  Empty Blocks [" + this.getEmptyBlocks() + "]");
        try {
            buf.append("\n  Length [" + this.length() + "]");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    protected String getFilePath() {
        return this.filepath;
    }
}

