/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AbstractAuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public abstract class AbstractRemoteCacheNoWaitFacade
extends AbstractAuxiliaryCache {
    private static final long serialVersionUID = -4529970797620747110L;
    private static final Log log = LogFactory.getLog((Class)AbstractRemoteCacheNoWaitFacade.class);
    public RemoteCacheNoWait[] noWaits;
    private String cacheName;
    protected IRemoteCacheAttributes remoteCacheAttributes;
    private ICompositeCacheManager compositeCacheManager;

    public AbstractRemoteCacheNoWaitFacade(RemoteCacheNoWait[] noWaits, RemoteCacheAttributes rca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"CONSTRUCTING NO WAIT FACADE");
        }
        this.noWaits = noWaits;
        this.remoteCacheAttributes = rca;
        this.cacheName = rca.getCacheName();
        this.setCompositeCacheManager(cacheMgr);
        this.cacheEventLogger = cacheEventLogger;
        this.elementSerializer = elementSerializer;
    }

    public void update(ICacheElement ce) throws IOException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating through cache facade, noWaits.length = " + this.noWaits.length));
        }
        try {
            for (i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].update(ce);
            }
        }
        catch (Exception ex) {
            String message = "Problem updating no wait.  Will initiate failover if the noWait is in error.";
            log.error((Object)message, (Throwable)ex);
            if (this.getCacheEventLogger() != null) {
                this.getCacheEventLogger().logError("RemoteCacheNoWaitFacade", "update", message + ":" + ex.getMessage() + " REGION: " + ce.getCacheName() + " ELEMENT: " + ce);
            }
            this.failover(i);
        }
    }

    public ICacheElement get(Serializable key) {
        for (int i = 0; i < this.noWaits.length; ++i) {
            try {
                ICacheElement obj = this.noWaits[i].get(key);
                if (obj == null) continue;
                return obj;
            }
            catch (Exception ex) {
                log.debug((Object)"Failed to get.");
                return null;
            }
        }
        return null;
    }

    public Map getMatching(String pattern) throws IOException {
        int i = 0;
        if (i < this.noWaits.length) {
            try {
                return this.noWaits[i].getMatching(pattern);
            }
            catch (Exception ex) {
                log.debug((Object)"Failed to getMatching.");
                return Collections.EMPTY_MAP;
            }
        }
        return Collections.EMPTY_MAP;
    }

    public Map getMultiple(Set keys) {
        int i;
        if (keys != null && !keys.isEmpty() && (i = 0) < this.noWaits.length) {
            try {
                return this.noWaits[i].getMultiple(keys);
            }
            catch (Exception ex) {
                log.debug((Object)"Failed to get.");
                return Collections.EMPTY_MAP;
            }
        }
        return new HashMap();
    }

    public Set getGroupKeys(String group) throws IOException {
        HashSet allKeys = new HashSet();
        for (int i = 0; i < this.noWaits.length; ++i) {
            RemoteCacheNoWait aux = this.noWaits[i];
            if (aux == null) continue;
            allKeys.addAll(aux.getGroupKeys(group));
        }
        return allKeys;
    }

    public boolean remove(Serializable key) {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].remove(key);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return false;
    }

    public void removeAll() {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].removeAll();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public void dispose() {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].dispose();
            }
        }
        catch (Exception ex) {
            log.error((Object)"Problem in dispose.", (Throwable)ex);
        }
    }

    public int getSize() {
        return 0;
    }

    public int getCacheType() {
        return 4;
    }

    public String getCacheName() {
        return this.remoteCacheAttributes.getCacheName();
    }

    public int getStatus() {
        for (int i = 0; i < this.noWaits.length; ++i) {
            if (this.noWaits[i].getStatus() != 1) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "RemoteCacheNoWaitFacade: " + this.cacheName + ", rca = " + this.remoteCacheAttributes;
    }

    abstract void failover(int var1);

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.remoteCacheAttributes;
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait Facade");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        if (this.noWaits != null) {
            se = new StatElement();
            se.setName("Number of No Waits");
            se.setData("" + this.noWaits.length);
            elems.add(se);
            for (int i = 0; i < this.noWaits.length; ++i) {
                IStats sStats = this.noWaits[i].getStatistics();
                IStatElement[] sSEs = sStats.getStatElements();
                List<IStatElement> sL = Arrays.asList(sSEs);
                elems.addAll(sL);
            }
        }
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    public String getEventLoggingExtraInfo() {
        return "Remote Cache No Wait Facade";
    }

    public IRemoteCacheAttributes getRemoteCacheAttributes() {
        return this.remoteCacheAttributes;
    }

    public void setRemoteCacheAttributes(IRemoteCacheAttributes rca) {
        this.remoteCacheAttributes = rca;
    }

    protected void setCompositeCacheManager(ICompositeCacheManager compositeCacheManager) {
        this.compositeCacheManager = compositeCacheManager;
    }

    protected ICompositeCacheManager getCompositeCacheManager() {
        return this.compositeCacheManager;
    }
}

