/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.http.server;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.jcs.auxiliary.remote.http.server.AbstractRemoteCacheService;
import org.apache.jcs.auxiliary.remote.http.server.RemoteHttpCacheServerAttributes;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

public class RemoteHttpCacheService
extends AbstractRemoteCacheService {
    private static final String EVENT_LOG_SOURCE_NAME = "RemoteHttpCacheServer";
    private RemoteHttpCacheServerAttributes remoteHttpCacheServerAttributes;

    public RemoteHttpCacheService(ICompositeCacheManager cacheManager, RemoteHttpCacheServerAttributes remoteHttpCacheServerAttributes, ICacheEventLogger cacheEventLogger) {
        super(cacheManager, cacheEventLogger);
        this.setEventLogSourceName(EVENT_LOG_SOURCE_NAME);
        this.remoteHttpCacheServerAttributes = remoteHttpCacheServerAttributes;
    }

    public ICacheElement processGet(String cacheName, Serializable key, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isAllowClusterGet();
        if (keepLocal) {
            return cache.localGet(key);
        }
        return cache.get(key);
    }

    public Map processGetMultiple(String cacheName, Set keys, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isAllowClusterGet();
        if (keepLocal) {
            return cache.localGetMultiple(keys);
        }
        return cache.getMultiple(keys);
    }

    public Map processGetMatching(String cacheName, String pattern, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isAllowClusterGet();
        if (keepLocal) {
            return cache.localGetMatching(pattern);
        }
        return cache.getMatching(pattern);
    }

    public void processUpdate(ICacheElement item, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache cache = this.getCacheManager().getCache(item.getCacheName());
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isLocalClusterConsistency();
        if (keepLocal) {
            cache.localUpdate(item);
        } else {
            cache.update(item);
        }
    }

    public void processRemove(String cacheName, Serializable key, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isLocalClusterConsistency();
        if (keepLocal) {
            cache.localRemove(key);
        } else {
            cache.remove(key);
        }
    }

    public void processRemoveAll(String cacheName, long requesterId) throws IOException {
        boolean keepLocal;
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        boolean bl = keepLocal = !this.remoteHttpCacheServerAttributes.isLocalClusterConsistency();
        if (keepLocal) {
            cache.localRemoveAll();
        } else {
            cache.removeAll();
        }
    }

    public void processDispose(String cacheName, long requesterId) throws IOException {
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        cache.dispose();
    }

    public void release() throws IOException {
    }

    protected String getExtraInfoForRequesterId(long requesterId) {
        return requesterId + "";
    }
}

