/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.http.server;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.jcs.auxiliary.remote.http.server.RemoteHttpCacheServerAttributes;
import org.apache.jcs.auxiliary.remote.http.server.RemoteHttpCacheService;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.jcs.utils.config.PropertySetter;

public class RemoteHttpCacheSeviceFactory {
    private static final Log log = LogFactory.getLog((Class)RemoteHttpCacheSeviceFactory.class);

    public static RemoteHttpCacheService createRemoteHttpCacheService(ICompositeCacheManager cacheManager) {
        Properties props = cacheManager.getConfigurationProperties();
        ICacheEventLogger cacheEventLogger = RemoteHttpCacheSeviceFactory.configureCacheEventLogger(props);
        RemoteHttpCacheServerAttributes attributes = RemoteHttpCacheSeviceFactory.configureRemoteHttpCacheServerAttributes(props);
        RemoteHttpCacheService service = new RemoteHttpCacheService(cacheManager, attributes, cacheEventLogger);
        if (log.isInfoEnabled()) {
            log.info((Object)("Created new RemoteHttpCacheService " + service));
        }
        return service;
    }

    protected static ICacheEventLogger configureCacheEventLogger(Properties props) {
        ICacheEventLogger cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, "jcs.remotehttpcache");
        return cacheEventLogger;
    }

    protected static RemoteHttpCacheServerAttributes configureRemoteHttpCacheServerAttributes(Properties prop) {
        RemoteHttpCacheServerAttributes rcsa = new RemoteHttpCacheServerAttributes();
        PropertySetter.setProperties(rcsa, prop, "jcs.remotehttpcache.serverattributes.");
        return rcsa;
    }
}

