/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.event.behavior.IElementEventHandler;

public class ElementAttributes
implements IElementAttributes,
Serializable,
Cloneable {
    private static final long serialVersionUID = 7814990748035017441L;
    public boolean IS_SPOOL = true;
    public boolean IS_LATERAL = true;
    public boolean IS_REMOTE = true;
    public boolean IS_ETERNAL = true;
    public long maxLifeSeconds = -1L;
    public long maxIdleTimeSeconds = -1L;
    public int size = 0;
    public long createTime = 0L;
    public long lastAccessTime = 0L;
    public transient ArrayList eventHandlers;

    public ElementAttributes() {
        this.lastAccessTime = this.createTime = System.currentTimeMillis();
    }

    protected ElementAttributes(ElementAttributes attr) {
        this.IS_ETERNAL = attr.IS_ETERNAL;
        this.IS_SPOOL = attr.IS_SPOOL;
        this.IS_LATERAL = attr.IS_LATERAL;
        this.IS_REMOTE = attr.IS_REMOTE;
        this.maxLifeSeconds = attr.maxLifeSeconds;
        this.maxIdleTimeSeconds = attr.maxIdleTimeSeconds;
        this.size = attr.size;
    }

    public IElementAttributes copy() {
        try {
            ElementAttributes attr = new ElementAttributes();
            attr.setIdleTime(this.getIdleTime());
            attr.setIsEternal(this.getIsEternal());
            attr.setIsLateral(this.getIsLateral());
            attr.setIsRemote(this.getIsRemote());
            attr.setIsSpool(this.getIsSpool());
            attr.setMaxLifeSeconds(this.getMaxLifeSeconds());
            attr.addElementEventHandlers(this.eventHandlers);
            return attr;
        }
        catch (Exception e) {
            return new ElementAttributes();
        }
    }

    public Object clone2() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this);
            byte[] buf = baos.toByteArray();
            oos.close();
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ObjectInputStream ois = new ObjectInputStream(bais);
            ElementAttributes attr = (ElementAttributes)ois.readObject();
            ois.close();
            attr.createTime = System.currentTimeMillis();
            return attr;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setMaxLifeSeconds(long mls) {
        this.maxLifeSeconds = mls;
    }

    public long getMaxLifeSeconds() {
        return this.maxLifeSeconds;
    }

    public void setIdleTime(long idle) {
        this.maxIdleTimeSeconds = idle;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime() {
        this.createTime = System.currentTimeMillis();
    }

    public long getIdleTime() {
        return this.maxIdleTimeSeconds;
    }

    public long getTimeToLiveSeconds() {
        long now = System.currentTimeMillis();
        return (this.getCreateTime() + this.getMaxLifeSeconds() * 1000L - now) / 1000L;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTimeNow() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public boolean getIsSpool() {
        return this.IS_SPOOL;
    }

    public void setIsSpool(boolean val) {
        this.IS_SPOOL = val;
    }

    public boolean getIsLateral() {
        return this.IS_LATERAL;
    }

    public void setIsLateral(boolean val) {
        this.IS_LATERAL = val;
    }

    public boolean getIsRemote() {
        return this.IS_REMOTE;
    }

    public void setIsRemote(boolean val) {
        this.IS_REMOTE = val;
    }

    public boolean getIsEternal() {
        return this.IS_ETERNAL;
    }

    public void setIsEternal(boolean val) {
        this.IS_ETERNAL = val;
    }

    public void addElementEventHandler(IElementEventHandler eventHandler) {
        if (this.eventHandlers == null) {
            this.eventHandlers = new ArrayList();
        }
        this.eventHandlers.add(eventHandler);
    }

    public void addElementEventHandlers(ArrayList eventHandlers) {
        if (eventHandlers == null) {
            return;
        }
        Iterator iter = eventHandlers.iterator();
        while (iter.hasNext()) {
            this.addElementEventHandler((IElementEventHandler)iter.next());
        }
    }

    public ArrayList getElementEventHandlers() {
        return this.eventHandlers;
    }

    public String toString() {
        StringBuffer dump = new StringBuffer();
        dump.append("[ IS_LATERAL = ").append(this.IS_LATERAL);
        dump.append(", IS_SPOOL = ").append(this.IS_SPOOL);
        dump.append(", IS_REMOTE = ").append(this.IS_REMOTE);
        dump.append(", IS_ETERNAL = ").append(this.IS_ETERNAL);
        dump.append(", MaxLifeSeconds = ").append(this.getMaxLifeSeconds());
        dump.append(", IdleTime = ").append(this.getIdleTime());
        dump.append(", CreateTime = ").append(this.getCreateTime());
        dump.append(", LastAccessTime = ").append(this.getLastAccessTime());
        dump.append(", getTimeToLiveSeconds() = ").append(String.valueOf(this.getTimeToLiveSeconds()));
        dump.append(", createTime = ").append(String.valueOf(this.createTime)).append(" ]");
        return dump.toString();
    }
}

