/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.gui;

import java.awt.Frame;
import java.awt.Graphics;

public class GUITasks {
    public static Frame getTopFrame() {
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].getFocusOwner() == null) continue;
            return frames[i];
        }
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public static void drawDashed(Graphics g, int x1, int y1, int x2, int y2, int dashSize, int gapSize) {
        int temp;
        if (x2 < x1) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y2 < y1) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        int totalDash = dashSize + gapSize;
        if (y1 == y2) {
            int virtualStartX;
            for (int x = virtualStartX = x1 / totalDash * totalDash; x < x2; x += totalDash) {
                int firstX;
                int topX = x + dashSize;
                if (topX > x2) {
                    topX = x2;
                }
                if ((firstX = x) < x1) {
                    firstX = x1;
                }
                if (firstX >= topX) continue;
                g.drawLine(firstX, y1, topX, y1);
            }
        } else if (x1 == x2) {
            int virtualStartY;
            for (int y = virtualStartY = y1 / totalDash * totalDash; y < y2; y += totalDash) {
                int firstY;
                int topY = y + dashSize;
                if (topY > y2) {
                    topY = y2;
                }
                if ((firstY = y) < y1) {
                    firstY = y1;
                }
                if (firstY >= topY) continue;
                g.drawLine(x1, firstY, x1, topY);
            }
        } else {
            g.drawLine(x1, y1, x2, y2);
        }
    }
}

