/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary;

import java.io.Serializable;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.logging.CacheEvent;
import org.apache.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.jcs.engine.match.KeyMatcherPatternImpl;
import org.apache.jcs.engine.match.behavior.IKeyMatcher;
import org.apache.jcs.utils.serialization.StandardSerializer;

public abstract class AbstractAuxiliaryCache
implements AuxiliaryCache {
    private static final long serialVersionUID = -1285708398502576617L;
    protected ICacheEventLogger cacheEventLogger;
    protected IElementSerializer elementSerializer = new StandardSerializer();
    private static final ICacheEvent EMPTY_ICACHE_EVENT = new CacheEvent();
    protected IKeyMatcher keyMatcher = new KeyMatcherPatternImpl();

    protected ICacheEvent createICacheEvent(ICacheElement item, String eventName) {
        if (this.cacheEventLogger == null) {
            return EMPTY_ICACHE_EVENT;
        }
        String diskLocation = this.getEventLoggingExtraInfo();
        String regionName = null;
        if (item != null) {
            regionName = item.getCacheName();
        }
        return this.cacheEventLogger.createICacheEvent(this.getAuxiliaryCacheAttributes().getName(), regionName, eventName, diskLocation, item);
    }

    protected ICacheEvent createICacheEvent(String regionName, Serializable key, String eventName) {
        if (this.cacheEventLogger == null) {
            return EMPTY_ICACHE_EVENT;
        }
        String diskLocation = this.getEventLoggingExtraInfo();
        return this.cacheEventLogger.createICacheEvent(this.getAuxiliaryCacheAttributes().getName(), regionName, eventName, diskLocation, key);
    }

    protected void logICacheEvent(ICacheEvent cacheEvent) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logICacheEvent(cacheEvent);
        }
    }

    protected void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logApplicationEvent(source, eventName, optionalDetails);
        }
    }

    protected void logError(String source, String eventName, String errorMessage) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logError(source, eventName, errorMessage);
        }
    }

    public abstract String getEventLoggingExtraInfo();

    public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        this.cacheEventLogger = cacheEventLogger;
    }

    public ICacheEventLogger getCacheEventLogger() {
        return this.cacheEventLogger;
    }

    public void setElementSerializer(IElementSerializer elementSerializer) {
        if (elementSerializer != null) {
            this.elementSerializer = elementSerializer;
        }
    }

    public IElementSerializer getElementSerializer() {
        return this.elementSerializer;
    }

    public void setKeyMatcher(IKeyMatcher keyMatcher) {
        if (keyMatcher != null) {
            this.keyMatcher = keyMatcher;
        }
    }

    public IKeyMatcher getKeyMatcher() {
        return this.keyMatcher;
    }
}

