/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.block;

import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.disk.AbstractDiskCacheManager;
import org.apache.jcs.auxiliary.disk.block.BlockDiskCache;
import org.apache.jcs.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

public class BlockDiskCacheManager
extends AbstractDiskCacheManager {
    private static final long serialVersionUID = -4153287154512274626L;
    private static final Log log = LogFactory.getLog((Class)BlockDiskCacheManager.class);
    private static BlockDiskCacheManager instance;
    private Hashtable caches = new Hashtable();
    private BlockDiskCacheAttributes defaultCacheAttributes;

    private BlockDiskCacheManager(BlockDiskCacheAttributes defaultCacheAttributes, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        this.defaultCacheAttributes = defaultCacheAttributes;
        this.setElementSerializer(elementSerializer);
        this.setCacheEventLogger(cacheEventLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockDiskCacheManager getInstance(BlockDiskCacheAttributes defaultCacheAttributes, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        Class clazz = BlockDiskCacheManager.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new BlockDiskCacheManager(defaultCacheAttributes, cacheEventLogger, elementSerializer);
            }
        }
        return instance;
    }

    public AuxiliaryCache getCache(String cacheName) {
        BlockDiskCacheAttributes cacheAttributes = (BlockDiskCacheAttributes)this.defaultCacheAttributes.copy();
        cacheAttributes.setCacheName(cacheName);
        return this.getCache(cacheAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuxiliaryCache getCache(BlockDiskCacheAttributes cacheAttributes) {
        AuxiliaryCache cache = null;
        String cacheName = cacheAttributes.getCacheName();
        log.debug((Object)("Getting cache named: " + cacheName));
        Hashtable hashtable = this.caches;
        synchronized (hashtable) {
            cache = (AuxiliaryCache)this.caches.get(cacheName);
            if (cache == null) {
                cache = new BlockDiskCache(cacheAttributes);
                cache.setCacheEventLogger(this.getCacheEventLogger());
                cache.setElementSerializer(this.getElementSerializer());
                this.caches.put(cacheName, cache);
            }
        }
        return cache;
    }

    public int getCacheType() {
        return 2;
    }
}

