/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.http.server.RemoteCacheServiceAdaptor;
import org.apache.jcs.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.jcs.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.utils.serialization.StandardSerializer;

public class RemoteHttpCacheServlet
extends HttpServlet {
    private static final long serialVersionUID = 8752849397531933346L;
    private static final Log log = LogFactory.getLog((Class)RemoteHttpCacheServlet.class);
    private static CompositeCacheManager cacheMgr;
    private RemoteCacheServiceAdaptor remoteHttpCacheServiceAdaptor;
    private StandardSerializer serializer = new StandardSerializer();
    private int serviceCalls = 0;
    private int logInterval = 100;

    public void init(ServletConfig config) throws ServletException {
        this.ensureCacheManager();
        this.setRemoteHttpCacheServiceAdaptor(new RemoteCacheServiceAdaptor(cacheMgr));
        super.init(config);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.incrementServiceCallCount();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Servicing a request. " + request));
        }
        RemoteCacheRequest remoteRequest = this.readRequest(request);
        RemoteCacheResponse cacheResponse = this.getRemoteHttpCacheServiceAdaptor().processRequest(remoteRequest);
        this.writeResponse(response, cacheResponse);
    }

    protected RemoteCacheRequest readRequest(HttpServletRequest request) {
        RemoteCacheRequest remoteRequest = null;
        try {
            ServletInputStream inputStream = request.getInputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)"After getting input stream and before reading it");
            }
            remoteRequest = this.readRequestFromStream((InputStream)inputStream);
        }
        catch (Exception e) {
            log.error((Object)"Could not get a RemoteHttpCacheRequest object from the input stream.", (Throwable)e);
        }
        return remoteRequest;
    }

    protected RemoteCacheRequest readRequestFromStream(InputStream inputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(inputStream);
        RemoteCacheRequest remoteRequest = (RemoteCacheRequest)ois.readObject();
        ois.close();
        return remoteRequest;
    }

    protected void writeResponse(HttpServletResponse response, RemoteCacheResponse cacheResponse) {
        try {
            response.setContentType("application/octet-stream");
            byte[] responseAsByteAray = this.serializer.serialize(cacheResponse);
            response.setContentLength(responseAsByteAray.length);
            ServletOutputStream outputStream = response.getOutputStream();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opened output stream.  Response size: " + responseAsByteAray.length));
            }
            outputStream.write(responseAsByteAray);
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            log.error((Object)("Problem writing response. " + cacheResponse), (Throwable)e);
        }
    }

    private void incrementServiceCallCount() {
        ++this.serviceCalls;
        if (log.isInfoEnabled() && this.serviceCalls % this.logInterval == 0) {
            log.info((Object)("serviceCalls = " + this.serviceCalls));
        }
    }

    protected synchronized void ensureCacheManager() {
        if (cacheMgr == null) {
            cacheMgr = CompositeCacheManager.getInstance();
        }
    }

    public void destroy() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Servlet Destroyed, shutting down JCS.");
        }
        cacheMgr.shutDown();
    }

    public String getServletInfo() {
        return "RemoteHttpCacheServlet";
    }

    public void setRemoteHttpCacheServiceAdaptor(RemoteCacheServiceAdaptor remoteHttpCacheProcessor) {
        this.remoteHttpCacheServiceAdaptor = remoteHttpCacheProcessor;
    }

    public RemoteCacheServiceAdaptor getRemoteHttpCacheServiceAdaptor() {
        return this.remoteHttpCacheServiceAdaptor;
    }
}

