/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.utils.config.OptionConverter;
import org.apache.jcs.utils.config.PropertySetterException;

public class PropertySetter {
    private static final Log log = LogFactory.getLog((Class)OptionConverter.class);
    protected Object obj;
    protected PropertyDescriptor[] props;

    public PropertySetter(Object obj) {
        this.obj = obj;
    }

    protected void introspect() {
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.obj.getClass());
            this.props = bi.getPropertyDescriptors();
        }
        catch (IntrospectionException ex) {
            log.error((Object)("Failed to introspect " + this.obj + ": " + ex.getMessage()));
            this.props = new PropertyDescriptor[0];
        }
    }

    public static void setProperties(Object obj, Properties properties, String prefix) {
        new PropertySetter(obj).setProperties(properties, prefix);
    }

    public void setProperties(Properties properties, String prefix) {
        int len = prefix.length();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix) || key.indexOf(46, len + 1) > 0) continue;
            String value = OptionConverter.findAndSubst(key, properties);
            key = key.substring(len);
            this.setProperty(key, value);
        }
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            return;
        }
        PropertyDescriptor prop = this.getPropertyDescriptor(name = Introspector.decapitalize(name));
        if (prop == null) {
            log.warn((Object)("No such property [" + name + "] in " + this.obj.getClass().getName() + "."));
        } else {
            try {
                this.setProperty(prop, name, value);
            }
            catch (PropertySetterException ex) {
                log.warn((Object)("Failed to set property " + name + " to value \"" + value + "\". " + ex.getMessage()));
            }
        }
    }

    public void setProperty(PropertyDescriptor prop, String name, String value) throws PropertySetterException {
        Object arg;
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            throw new PropertySetterException("No setter for property");
        }
        Class<?>[] paramTypes = setter.getParameterTypes();
        if (paramTypes.length != 1) {
            throw new PropertySetterException("#params for setter != 1");
        }
        try {
            arg = this.convertArg(value, paramTypes[0]);
        }
        catch (Throwable t) {
            throw new PropertySetterException("Conversion to type [" + paramTypes[0] + "] failed. Reason: " + t);
        }
        if (arg == null) {
            throw new PropertySetterException("Conversion to type [" + paramTypes[0] + "] failed.");
        }
        log.debug((Object)("Setting property [" + name + "] to [" + arg + "]."));
        try {
            setter.invoke(this.obj, arg);
        }
        catch (Exception ex) {
            throw new PropertySetterException(ex);
        }
    }

    protected Object convertArg(String val, Class type) {
        if (val == null) {
            return null;
        }
        String v = val.trim();
        if (String.class.isAssignableFrom(type)) {
            return val;
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return new Integer(v);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return new Long(v);
        }
        if (Boolean.TYPE.isAssignableFrom(type)) {
            if ("true".equalsIgnoreCase(v)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(v)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        if (this.props == null) {
            this.introspect();
        }
        for (int i = 0; i < this.props.length; ++i) {
            if (!name.equals(this.props[i].getName())) continue;
            return this.props[i];
        }
        return null;
    }
}

