/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.serialization;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.CacheElementSerialized;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheElementSerialized;
import org.apache.jcs.engine.behavior.IElementSerializer;

public class SerializationConversionUtil {
    private static final Log log = LogFactory.getLog((Class)SerializationConversionUtil.class);

    public static ICacheElementSerialized getSerializedCacheElement(ICacheElement element, IElementSerializer elementSerializer) throws IOException {
        if (element == null) {
            return null;
        }
        byte[] serialzedValue = null;
        if (element instanceof ICacheElementSerialized) {
            serialzedValue = ((ICacheElementSerialized)element).getSerializedValue();
        } else if (elementSerializer != null) {
            try {
                serialzedValue = elementSerializer.serialize(element.getVal());
            }
            catch (IOException e) {
                log.error((Object)"Problem serializing object.", (Throwable)e);
                throw e;
            }
        } else {
            log.warn((Object)"ElementSerializer is null.  Could not serialize object.");
            throw new IOException("Could not serialize object.  The ElementSerializer is null.");
        }
        CacheElementSerialized serialized = new CacheElementSerialized(element.getCacheName(), element.getKey(), serialzedValue, element.getElementAttributes());
        return serialized;
    }

    public static ICacheElement getDeSerializedCacheElement(ICacheElementSerialized serialized, IElementSerializer elementSerializer) throws IOException, ClassNotFoundException {
        Object deSerialzedValue;
        block6: {
            if (serialized == null) {
                return null;
            }
            deSerialzedValue = null;
            if (elementSerializer != null) {
                try {
                    try {
                        deSerialzedValue = elementSerializer.deSerialize(serialized.getSerializedValue());
                        break block6;
                    }
                    catch (ClassNotFoundException e) {
                        log.error((Object)"Problem de-serializing object.", (Throwable)e);
                        throw e;
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Problem de-serializing object.", (Throwable)e);
                    throw e;
                }
            }
            log.warn((Object)"ElementSerializer is null.  Could not serialize object.");
        }
        CacheElement deSerialized = new CacheElement(serialized.getCacheName(), serialized.getKey(), deSerialzedValue);
        deSerialized.setElementAttributes(serialized.getElementAttributes());
        return deSerialized;
    }
}

