/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.struct;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.utils.struct.DoubleLinkedListNode;

public class DoubleLinkedList {
    private int size = 0;
    private static final Log log = LogFactory.getLog((Class)DoubleLinkedList.class);
    private DoubleLinkedListNode first;
    private DoubleLinkedListNode last;

    public synchronized void addLast(DoubleLinkedListNode me) {
        if (this.first == null) {
            this.first = me;
        } else {
            this.last.next = me;
            me.prev = this.last;
        }
        this.last = me;
        ++this.size;
    }

    public synchronized void addFirst(DoubleLinkedListNode me) {
        if (this.last == null) {
            this.last = me;
        } else {
            this.first.prev = me;
            me.next = this.first;
        }
        this.first = me;
        ++this.size;
    }

    public synchronized DoubleLinkedListNode getLast() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"returning last node");
        }
        return this.last;
    }

    public synchronized DoubleLinkedListNode getFirst() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"returning first node");
        }
        return this.first;
    }

    public synchronized void makeFirst(DoubleLinkedListNode ln) {
        if (ln.prev == null) {
            return;
        }
        ln.prev.next = ln.next;
        if (ln.next == null) {
            this.last = ln.prev;
            this.last.next = null;
        } else {
            ln.next.prev = ln.prev;
        }
        this.first.prev = ln;
        ln.next = this.first;
        ln.prev = null;
        this.first = ln;
    }

    public synchronized void makeLast(DoubleLinkedListNode ln) {
        if (ln.next == null) {
            return;
        }
        if (ln.prev != null) {
            ln.prev.next = ln.next;
        } else {
            this.first = this.last;
        }
        if (this.last != null) {
            this.last.next = ln;
        }
        ln.prev = this.last;
        ln.next = null;
        this.last = ln;
    }

    public synchronized void removeAll() {
        DoubleLinkedListNode me = this.first;
        while (me != null) {
            DoubleLinkedListNode next;
            if (me.prev != null) {
                me.prev = null;
            }
            me = next = me.next;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    public synchronized boolean remove(DoubleLinkedListNode me) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removing node");
        }
        if (me.next == null) {
            if (me.prev == null) {
                if (me == this.first && me == this.last) {
                    this.last = null;
                    this.first = null;
                }
            } else {
                this.last = me.prev;
                this.last.next = null;
                me.prev = null;
            }
        } else if (me.prev == null) {
            this.first = me.next;
            this.first.prev = null;
            me.next = null;
        } else {
            me.prev.next = me.next;
            me.next.prev = me.prev;
            me.next = null;
            me.prev = null;
        }
        --this.size;
        return true;
    }

    public synchronized DoubleLinkedListNode removeLast() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removing last node");
        }
        DoubleLinkedListNode temp = this.last;
        if (this.last != null) {
            this.remove(this.last);
        }
        return temp;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized void debugDumpEntries() {
        log.debug((Object)"dumping Entries");
        DoubleLinkedListNode me = this.first;
        while (me != null) {
            log.debug((Object)("dump Entries> payload= '" + me.getPayload() + "'"));
            me = me.next;
        }
    }
}

