/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.client.AdminMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.connectbl.ConnectBBReference;
import com.fe.data.BBSyncTrigger;
import com.fe.db.BBSyncDB;
import com.fe.db.ReferenceDB;
import com.fe.lucene.LuceneCrawler;
import com.fe.lucene.TickerIndexRecord;
import com.fe.lucene.TokenCollectorFactory;
import com.fe.scheduler.BloombergDownloadJob;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.directwebremoting.WebContextFactory;

public class BBSyncMgmt {
    private static String dbname = Config.getString("db_bbsync_name");
    private Logger log = Logger.getLogger(BBSyncMgmt.class);
    private HttpServletRequest request = null;

    public static String getDBName() {
        return dbname;
    }

    public BBSyncMgmt(HttpServletRequest httpServletRequest) throws Exception {
        this.request = httpServletRequest;
        String string = (String)this.getRequest().getSession().getAttribute(AdminMgmt.LOGGED_IN_ATTRIBUTE);
        if (string == null || string.equalsIgnoreCase("true")) {
            // empty if block
        }
    }

    public BBSyncMgmt() throws Exception {
        String string = (String)this.getRequest().getSession().getAttribute(AdminMgmt.LOGGED_IN_ATTRIBUTE);
        if (string == null || string.equalsIgnoreCase("true")) {
            // empty if block
        }
    }

    public BBSyncMgmt(String string) throws Exception {
    }

    public Map loadFirst() throws Exception {
        BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
        bBSyncDB.connectDB(dbname);
        TreeMap<String, Vector> treeMap = new TreeMap<String, Vector>();
        Vector vector = bBSyncDB.listAll();
        Vector vector2 = bBSyncDB.getFieldMapping();
        for (int i = 0; i < vector.size(); ++i) {
            Map map = (Map)vector.get(i);
            Object v = map.get("last_executed");
            if (!(v instanceof Timestamp) || v == null) continue;
            String string = new SimpleDateFormat("d MMM,yy  HH:mm").format((java.util.Date)v);
            map.put("last_executed", string);
        }
        bBSyncDB.closeDB();
        treeMap.put("schedules", vector);
        treeMap.put("field_mapping", vector2);
        return treeMap;
    }

    public Vector deleteMapping(int n) throws Exception {
        BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
        bBSyncDB.connectDB(dbname);
        bBSyncDB.deleteFieldMapping(n);
        Vector vector = bBSyncDB.getFieldMapping();
        bBSyncDB.closeDB();
        return vector;
    }

    public Vector addMapping(String string, String string2) throws Exception {
        BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
        bBSyncDB.connectDB(dbname);
        bBSyncDB.addFieldMapping(string, string2);
        Vector vector = bBSyncDB.getFieldMapping();
        bBSyncDB.closeDB();
        return vector;
    }

    public Map getDownloadQuery(long l) throws Exception {
        try {
            Object object;
            Object object2;
            Object v;
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            bBSyncDB.connectDB(dbname);
            Map map = bBSyncDB.getDownloadQuery(l);
            Object v2 = map.get("date_from");
            if (v2 != null) {
                map.put("date_from", new SimpleDateFormat("dd/MM/yyyy").format((java.util.Date)v2));
            }
            if ((v = map.get("date_to")) != null) {
                map.put("date_to", new SimpleDateFormat("dd/MM/yyyy").format((java.util.Date)v));
            }
            if (map.get("trigger_time") != null) {
                try {
                    object2 = new SimpleDateFormat("HH:mm").parse((String)map.get("trigger_time"));
                    object = Calendar.getInstance();
                    ((Calendar)object).setTime((java.util.Date)object2);
                    map.put("trigger_hour", ((Calendar)object).get(11));
                    map.put("trigger_minute", ((Calendar)object).get(12));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (map.get("fields") != null) {
                object2 = (String)map.get("fields");
                object = new StringTokenizer((String)object2, "|");
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string = ((StringTokenizer)object).nextToken();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "~");
                    if (stringTokenizer.countTokens() != 2) continue;
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    treeMap.put(string2, string3);
                }
                map.put("fieldsmap", treeMap);
            }
            bBSyncDB.closeDB();
            return map;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map saveSchedule(int n, String string, boolean bl, String string2, String string3, String string4, String string5, Vector vector, String string6, BBSyncTrigger bBSyncTrigger, BBSyncTrigger bBSyncTrigger2, BBSyncTrigger bBSyncTrigger3, String string7, String string8) throws Exception {
        try {
            Object object;
            this.log.debug((Object)"saveSchedule called");
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            BBSyncTrigger bBSyncTrigger4 = new BBSyncTrigger();
            if (bBSyncTrigger != null && bBSyncTrigger2 == null && bBSyncTrigger3 == null) {
                bBSyncTrigger4 = bBSyncTrigger;
                bBSyncTrigger4.setSynctype(1);
            }
            if (bBSyncTrigger == null && bBSyncTrigger2 != null && bBSyncTrigger3 == null) {
                bBSyncTrigger4 = bBSyncTrigger2;
                bBSyncTrigger4.setSynctype(2);
            }
            if (bBSyncTrigger == null && bBSyncTrigger2 == null && bBSyncTrigger3 != null) {
                bBSyncTrigger4 = bBSyncTrigger3;
                bBSyncTrigger4.setSynctype(3);
            }
            this.log.debug((Object)("trigobj:" + bBSyncTrigger4));
            try {
                bBSyncDB.connectDB(dbname);
                this.log.debug((Object)"after connected");
                object = null;
                Date date = null;
                this.log.debug((Object)("before parsing:" + string3));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("DD/mm/yyyy");
                if (string3 != null) {
                    this.log.debug((Object)("parseing:" + simpleDateFormat.parse(string3)));
                    object = new Date(simpleDateFormat.parse(string3).getTime());
                }
                if (string4 != null) {
                    date = new Date(simpleDateFormat.parse(string4).getTime());
                }
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n3 = bBSyncDB.saveSchedule(n, string, bl + "", string2, (Date)object, date, n2, vector, string6, bBSyncTrigger4, string7, string8);
                bBSyncDB.closeDB();
                try {
                    new BloombergDownloadJob().rescheduleJobs(n3);
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Couldn't schedule the queries");
                }
            }
            catch (Exception exception) {
                ClientErrorMgmt.reportError(exception, "Couldn't save scheduling data");
                throw exception;
            }
            object = this.loadFirst();
            object.remove("field_mapping");
            return object;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public int saveSchedule2(int n, String string, boolean bl, String string2, String string3, String string4, String string5, Vector vector, String string6, BBSyncTrigger bBSyncTrigger, BBSyncTrigger bBSyncTrigger2, BBSyncTrigger bBSyncTrigger3, String string7, String string8) throws Exception {
        try {
            this.log.debug((Object)"saveSchedule called");
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            BBSyncTrigger bBSyncTrigger4 = new BBSyncTrigger();
            if (bBSyncTrigger != null && bBSyncTrigger2 == null && bBSyncTrigger3 == null) {
                bBSyncTrigger4 = bBSyncTrigger;
                bBSyncTrigger4.setSynctype(1);
            }
            if (bBSyncTrigger == null && bBSyncTrigger2 != null && bBSyncTrigger3 == null) {
                bBSyncTrigger4 = bBSyncTrigger2;
                bBSyncTrigger4.setSynctype(2);
            }
            if (bBSyncTrigger == null && bBSyncTrigger2 == null && bBSyncTrigger3 != null) {
                bBSyncTrigger4 = bBSyncTrigger3;
                bBSyncTrigger4.setSynctype(3);
            }
            this.log.debug((Object)("trigobj:" + bBSyncTrigger4));
            try {
                bBSyncDB.connectDB(dbname);
                this.log.debug((Object)"after connected");
                Date date = null;
                Date date2 = null;
                this.log.debug((Object)("before parsing:" + string3));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("DD/mm/yyyy");
                if (string3 != null) {
                    this.log.debug((Object)("parseing:" + simpleDateFormat.parse(string3)));
                    date = new Date(simpleDateFormat.parse(string3).getTime());
                }
                if (string4 != null) {
                    date2 = new Date(simpleDateFormat.parse(string4).getTime());
                }
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string5);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n3 = bBSyncDB.saveSchedule(n, string, bl + "", string2, date, date2, n2, vector, string6, bBSyncTrigger4, string7, string8);
                bBSyncDB.closeDB();
                return n3;
            }
            catch (Exception exception) {
                ClientErrorMgmt.reportError(exception, "Couldn't save scheduling data");
                throw exception;
            }
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public boolean downloadOnDemand(int n) throws Exception {
        try {
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            bBSyncDB.connectDB(dbname);
            Map map = bBSyncDB.getDownloadQuery(n);
            bBSyncDB.closeDB();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "id:" + n);
            throw exception;
        }
    }

    public Map deleteQuery(int n) throws Exception {
        try {
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            bBSyncDB.connectDB(dbname);
            bBSyncDB.deleteQuery(n);
            Map map = this.loadFirst();
            map.remove("field_mapping");
            bBSyncDB.closeDB();
            return map;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "id:" + n);
            throw exception;
        }
    }

    public Vector bbSynchSecurites(boolean bl) throws Exception {
        try {
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            bBSyncDB.connectDB(dbname);
            referenceDB.connectDB(dbname);
            Map<String, String> map = bBSyncDB.getSecurityNames2RefSync(bl);
            if (map.size() < 1) {
                throw new Exception("No Securities to synchronize");
            }
            Vector vector = referenceDB.getSecFieldMapping();
            Vector vector2 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                vector2.add(((Map)vector.get(i)).get("bb_fieldname"));
            }
            if (vector2.size() < 1) {
                throw new Exception("No Fields found to synchronize");
            }
            ConnectBBReference connectBBReference = new ConnectBBReference(new Vector<String>(map.keySet()), vector2, "");
            Map map2 = connectBBReference.getData();
            Vector<String> vector3 = new Vector<String>();
            for (String string : map2.keySet()) {
                Map map3 = (Map)map2.get(string);
                String string2 = map.get(string);
                if (string2 != null && !string2.equals("")) {
                    String string3 = string.replaceAll(string2, "");
                }
                bBSyncDB.updateSecurityReference(string2, string.trim(), map3);
                vector3.add(string2);
                this.indexSecurity(string2);
            }
            return vector3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    protected void indexSecurity(String string) throws Exception {
        TickerIndexRecord tickerIndexRecord = new TickerIndexRecord();
        tickerIndexRecord.setTablename(LuceneCrawler.INDEX_TABLE_SECURITY);
        if (TokenCollectorFactory.getTokenCollector(tickerIndexRecord) != null) {
            LuceneCrawler luceneCrawler = new LuceneCrawler(LuceneCrawler.INDEX_TABLE_SECURITY);
            luceneCrawler.index(string);
        }
    }

    public boolean bbSynchOneContract(String string) throws Exception {
        try {
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            bBSyncDB.connectDB(dbname);
            referenceDB.connectDB(dbname);
            Vector<String> vector = new Vector<String>();
            vector.add(string);
            Vector vector2 = referenceDB.getFieldMapping();
            Vector vector3 = new Vector();
            for (int i = 0; i < vector2.size(); ++i) {
                vector3.add(((Map)vector2.get(i)).get("bb_fieldname"));
            }
            if (vector3.size() < 1) {
                throw new Exception("No Fields found to synchronize");
            }
            ConnectBBReference connectBBReference = new ConnectBBReference(vector, vector3, "Comdty");
            Map map = connectBBReference.getData();
            for (String string2 : map.keySet()) {
                Map map2 = (Map)map.get(string2);
                bBSyncDB.updateContractReference(string, map2);
                this.indexContract(string);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public boolean bbSynchOneSecurity(String string) throws Exception {
        try {
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            bBSyncDB.connectDB(dbname);
            referenceDB.connectDB(dbname);
            Map<String, String> map = bBSyncDB.getSecurityName2RefSync(string);
            if (map.size() < 1) {
                throw new Exception("No Securities to synchronize");
            }
            Vector vector = referenceDB.getSecFieldMapping();
            Vector vector2 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                vector2.add(((Map)vector.get(i)).get("bb_fieldname"));
            }
            if (vector2.size() < 1) {
                throw new Exception("No Fields found to synchronize");
            }
            ConnectBBReference connectBBReference = new ConnectBBReference(new Vector<String>(map.keySet()), vector2, "");
            Map map2 = connectBBReference.getData();
            for (String string2 : map2.keySet()) {
                Map map3 = (Map)map2.get(string2);
                String string3 = map.get(string2);
                String string4 = string2.replaceAll(string3, "");
                bBSyncDB.updateSecurityReference(string3, string2.trim(), map3);
                this.indexSecurity(string3);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public Vector bbSynchContracts(boolean bl) throws Exception {
        try {
            BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            bBSyncDB.connectDB(dbname);
            referenceDB.connectDB(dbname);
            Vector<String> vector = null;
            vector = bBSyncDB.getContractNames2RefSync(bl);
            if (vector.size() < 1) {
                throw new Exception("No Contract to synchronize");
            }
            Vector vector2 = referenceDB.getFieldMapping();
            Vector vector3 = new Vector();
            for (int i = 0; i < vector2.size(); ++i) {
                vector3.add(((Map)vector2.get(i)).get("bb_fieldname"));
            }
            if (vector3.size() < 1) {
                throw new Exception("No Fields found to synchronize");
            }
            ConnectBBReference connectBBReference = new ConnectBBReference(vector, vector3, "Comdty");
            Map map = connectBBReference.getData();
            Vector<String> vector4 = new Vector<String>();
            for (String string : map.keySet()) {
                Map map2 = (Map)map.get(string);
                bBSyncDB.updateContractReference(string, map2);
                vector4.add(string);
                this.indexContract(string);
            }
            return vector4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private void indexContract(String string) throws Exception {
        TickerIndexRecord tickerIndexRecord = new TickerIndexRecord();
        tickerIndexRecord.setTablename(LuceneCrawler.INDEX_TABLE_CONTRACT);
        if (TokenCollectorFactory.getTokenCollector(tickerIndexRecord) != null) {
            LuceneCrawler luceneCrawler = new LuceneCrawler(LuceneCrawler.INDEX_TABLE_CONTRACT);
            luceneCrawler.index(string);
        }
    }

    private HttpServletRequest getRequest() throws Exception {
        return this.request == null && WebContextFactory.get() != null ? WebContextFactory.get().getHttpServletRequest() : this.request;
    }
}

