/*
 * Decompiled with CFR 0.152.
 */
package com.fe.connectbl;

import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.MessageIterator;
import com.bloomberglp.blpapi.NotFoundException;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import com.fe.Config;
import com.fe.client.MigrationMgmt;
import com.fe.data.Contract;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCacheManager;

public class ConnectBloomberg {
    private List contracts;
    private String scontracts;
    private String startdate;
    private String enddate;
    private String fieldname;
    private List vfieldname;
    private Vector<Contract> rtn = new Vector();
    private String marketsector;
    private TreeMap uniqueDates = new TreeMap();
    private int mode = 0;
    private MigrationMgmt clientGateway;
    private TreeMap datamulti = new TreeMap();
    private static int MULTIPLE_CONTRACT_N_FIELDS = 2;
    private static JCS cache = null;

    public ConnectBloomberg(List list, String string, String string2, String string3, String string4, MigrationMgmt migrationMgmt) {
        this.contracts = list;
        this.fieldname = string3;
        this.startdate = string;
        this.enddate = string2;
        this.marketsector = " " + string4;
        this.mode = 0;
        this.clientGateway = migrationMgmt;
    }

    public ConnectBloomberg(String string, String string2, String string3, List list, String string4, MigrationMgmt migrationMgmt) {
        this.scontracts = string;
        this.vfieldname = list;
        this.startdate = string2;
        this.enddate = string3;
        this.marketsector = " " + string4;
        this.mode = 1;
        this.clientGateway = migrationMgmt;
    }

    public ConnectBloomberg(List list, String string, String string2, List list2, String string3, MigrationMgmt migrationMgmt, boolean bl) {
        this.contracts = list;
        this.vfieldname = list2;
        this.startdate = string;
        this.enddate = string2;
        this.marketsector = " " + string3;
        this.mode = MULTIPLE_CONTRACT_N_FIELDS;
        this.clientGateway = migrationMgmt;
    }

    public Vector<Contract> getData() throws Exception {
        this.connect();
        return this.rtn;
    }

    public TreeMap getMultipleData() throws Exception {
        this.connectMultiple();
        return this.datamulti;
    }

    public Set getUniqueDates() {
        return this.uniqueDates.keySet();
    }

    private void connect() throws Exception {
        boolean bl;
        Session session;
        block18: {
            Element element;
            Element element2;
            String string = "localhost";
            int n = 8194;
            SessionOptions sessionOptions = new SessionOptions();
            sessionOptions.setServerHost(string);
            sessionOptions.setServerPort(n);
            session = new Session(sessionOptions);
            if (!session.start()) {
                throw new Exception("Failed to start Bloomberg Session");
            }
            if (!session.openService("//blp/refdata")) {
                throw new Exception("Failed to open //blp/refdata");
            }
            Service service = session.getService("//blp/refdata");
            Request request = service.createRequest("HistoricalDataRequest");
            if (this.mode == 0) {
                element2 = request.getElement("securities");
                for (MessageIterator messageIterator : this.contracts) {
                    element2.appendValue((String)messageIterator + this.marketsector);
                }
                element = request.getElement("fields");
                element.appendValue(this.fieldname.toUpperCase());
            } else if (this.mode == MULTIPLE_CONTRACT_N_FIELDS) {
                element2 = request.getElement("securities");
                for (MessageIterator messageIterator : this.contracts) {
                    element2.appendValue((String)messageIterator + this.marketsector);
                }
                element = request.getElement("fields");
                for (String string2 : this.vfieldname) {
                    element.appendValue(string2.toUpperCase());
                }
            } else {
                element2 = request.getElement("securities");
                element2.appendValue(this.scontracts + this.marketsector);
                element = request.getElement("fields");
                for (String string2 : this.vfieldname) {
                    element.appendValue(string2.toUpperCase());
                }
            }
            request.set("periodicityAdjustment", "ACTUAL");
            request.set("periodicitySelection", "DAILY");
            request.set("startDate", this.startdate);
            request.set("endDate", this.enddate);
            request.set("returnEids", true);
            session.sendRequest(request, null);
            bl = false;
            do {
                MessageIterator messageIterator;
                element = session.nextEvent();
                messageIterator = element.messageIterator();
                while (messageIterator.hasNext()) {
                    String string2;
                    string2 = messageIterator.next();
                    if (element.eventType() != Event.EventType.RESPONSE && element.eventType() != Event.EventType.PARTIAL_RESPONSE) continue;
                    this.clientGateway.setMessageClientServe("Connecting bloomberg");
                    Element element3 = string2.getElement("securityData");
                    String string3 = element3.getElementAsString("security");
                    this.clientGateway.setMessageClientServe("Processing field or security " + string3);
                    Element element4 = element3.getElement("fieldData");
                    int n2 = element4.numValues();
                    for (int i = 0; i < n2; ++i) {
                        Element element5 = element4.getValueAsElement(i);
                        if (this.mode == 0) {
                            Contract contract = new Contract();
                            contract.setCdate(element5.getElementAsDate("date").calendar().getTime());
                            String string4 = string3.replaceAll(this.marketsector, "");
                            contract.setName(string4.trim());
                            contract.setValue(element5.getElementAsFloat64(this.fieldname.toUpperCase()));
                            this.rtn.add(contract);
                            this.clientGateway.setMessageClientServe("Processing bloomberg data");
                            this.uniqueDates.put(contract.getCdate(), "");
                            continue;
                        }
                        for (String string4 : this.vfieldname) {
                            Contract contract = new Contract();
                            contract.setCdate(element5.getElementAsDate("date").calendar().getTime());
                            String string5 = string3.replaceAll(this.marketsector, "");
                            contract.setName(string4);
                            try {
                                contract.setValue(element5.getElementAsFloat64(string4.toUpperCase()));
                                this.rtn.add(contract);
                            }
                            catch (NotFoundException notFoundException) {
                                // empty catch block
                            }
                            this.uniqueDates.put(contract.getCdate(), "");
                        }
                    }
                }
                if (element.eventType() == Event.EventType.RESPONSE) break block18;
            } while (element.eventType() != Event.EventType.TIMEOUT);
            bl = true;
        }
        if (bl) {
            throw new Exception("Bloomberg API throws timed out exception.....");
        }
        session.stop();
    }

    private synchronized void connectMultiple() throws Exception {
        Object object2;
        Session session;
        block16: {
            String string3;
            String string2 = "localhost";
            int n = 8194;
            SessionOptions sessionOptions = new SessionOptions();
            sessionOptions.setServerHost(string2);
            sessionOptions.setServerPort(n);
            session = new Session(sessionOptions);
            if (!session.start()) {
                throw new Exception("Failed to start Bloomberg Session");
            }
            if (!session.openService("//blp/refdata")) {
                throw new Exception("Failed to open //blp/refdata");
            }
            Service service = session.getService("//blp/refdata");
            Request request = service.createRequest("HistoricalDataRequest");
            Element element = request.getElement("securities");
            for (Object object2 : this.contracts) {
                element.appendValue((String)object2 + this.marketsector);
            }
            Element element2 = request.getElement("fields");
            for (String string3 : this.vfieldname) {
                element2.appendValue(string3.toUpperCase());
            }
            request.set("periodicityAdjustment", "ACTUAL");
            request.set("periodicitySelection", "DAILY");
            request.set("startDate", this.startdate);
            request.set("endDate", this.enddate);
            request.set("returnEids", true);
            session.sendRequest(request, null);
            object2 = null;
            string3 = ConnectBloomberg.getCache().getDefaultElementAttributes();
            int n2 = 1200;
            try {
                n2 = Integer.parseInt(Config.getString("bloomberg.timeout.seconds"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            string3.setMaxLifeSeconds((long)n2);
            if (ConnectBloomberg.getCache().get((Object)"connectMultiple") != null) {
                ConnectBloomberg.getCache().remove((Object)"connectMultiple");
            }
            ConnectBloomberg.getCache().put((Object)"connectMultiple", (Object)"locked", (IElementAttributes)string3);
            do {
                Event event = session.nextEvent();
                MessageIterator messageIterator = event.messageIterator();
                while (messageIterator.hasNext()) {
                    Message message = messageIterator.next();
                    if (event.eventType() != Event.EventType.RESPONSE && event.eventType() != Event.EventType.PARTIAL_RESPONSE) continue;
                    this.clientGateway.setMessageClientServe("Connecting bloomberg");
                    Element element3 = message.getElement("securityData");
                    String string4 = element3.getElementAsString("security");
                    this.clientGateway.setMessageClientServe("Processing field or security " + string4);
                    Element element4 = element3.getElement("fieldData");
                    int n3 = element4.numValues();
                    for (int i = 0; i < n3; ++i) {
                        Element element5 = element4.getValueAsElement(i);
                        for (String string5 : this.vfieldname) {
                            Contract contract = new Contract();
                            contract.setCdate(element5.getElementAsDate("date").calendar().getTime());
                            String string6 = string4.replaceAll(this.marketsector, "");
                            contract.setName(string6.trim());
                            try {
                                Vector vector;
                                contract.setValue(element5.getElementAsFloat64(string5.toUpperCase()));
                                if (this.datamulti.get(string5) != null) {
                                    vector = (Vector)this.datamulti.get(string5);
                                } else {
                                    vector = new Vector();
                                    this.datamulti.put(string5, vector);
                                }
                                vector.add(contract);
                                this.uniqueDates.put(contract.getCdate(), "");
                            }
                            catch (NotFoundException notFoundException) {
                                // empty catch block
                            }
                            this.uniqueDates.put(contract.getCdate(), "");
                        }
                    }
                }
                if (event.eventType() == Event.EventType.RESPONSE) break block16;
                if (event.eventType() != Event.EventType.TIMEOUT) continue;
                object2 = "Bloomberg API throws timed out exception.....";
                break block16;
            } while (ConnectBloomberg.getCache().get((Object)"connectMultiple") != null);
            object2 = "Downloading terminated, beacause bloomberg download takes longer than " + n2 + " minutes";
        }
        session.stop();
        if (object2 != null) {
            throw new Exception((String)object2);
        }
    }

    private static JCS getCache() throws Exception {
        if (cache == null) {
            CompositeCacheManager compositeCacheManager = CompositeCacheManager.getUnconfiguredInstance();
            Properties properties = new Properties();
            properties.put("jcs.default", "DC");
            properties.put("jcs.default.cacheattributes", "org.apache.jcs.engine.CompositeCacheAttributes");
            compositeCacheManager.configure(properties);
            cache = JCS.getInstance((String)"bloombergTimeout");
        }
        return cache;
    }
}

