/*
 * Decompiled with CFR 0.152.
 */
package com.fe.db.mariadb;

import com.fe.data.BBSyncTrigger;
import com.fe.db.BBSyncDB;
import com.fe.db.GeneralUtilDB;
import com.fe.util.InputStringTokenParser;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BBSyncDBMariaDB
extends BBSyncDB {
    private Logger log = Logger.getLogger(BBSyncDB.class);

    @Override
    public Vector listAll() throws Exception {
        Statement statement = this.connection().createStatement();
        ResultSet resultSet = statement.executeQuery("Select * from bbsync order by name");
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            int n = (Integer)map.get("id");
            map.put("fieldsids", this.getFieldIds(n));
            map.put("tickers", this.getContracts(n));
            vector.add(map);
        }
        return vector;
    }

    @Override
    public ArrayList fieldMapping4BBSync(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select * from field_mapping where id in (select field_id from bbsync_fields where bbsync_id=?)");
        preparedStatement.setLong(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        while (resultSet.next()) {
            Map<String, Object> map = GeneralUtilDB.resultsetToMap(resultSet);
            arrayList.add(map);
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    @Override
    public Map getDownloadQuery(long l) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select * from bbsync where id=?");
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        Map<String, Object> map = null;
        if (resultSet.next()) {
            map = GeneralUtilDB.resultsetToMap(resultSet);
        }
        resultSet.close();
        preparedStatement.close();
        if (map != null) {
            map.put("fieldsids", this.getFieldIds(l));
            map.put("tickers", this.getContracts(l));
        }
        return map;
    }

    private Vector getFieldIds(long l) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select field_id from bbsync_fields where bbsync_id=?");
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.add(Integer.valueOf(resultSet.getInt("field_id")) + "");
        }
        preparedStatement.close();
        resultSet.clearWarnings();
        return vector;
    }

    private String getContracts(long l) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select contract from bbsync_contracts where bbsync_id=?");
        preparedStatement.setLong(1, l);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string = "";
        while (resultSet.next()) {
            string = string + (string.equals("") ? resultSet.getString("contract") : "," + resultSet.getString("contract"));
        }
        preparedStatement.close();
        resultSet.clearWarnings();
        return string;
    }

    @Override
    public Vector getFieldMapping() throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select * from field_mapping");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map<String, Object>> vector = new Vector<Map<String, Object>>();
        while (resultSet.next()) {
            vector.add(GeneralUtilDB.resultsetToMap(resultSet));
        }
        return vector;
    }

    @Override
    public void updateTriggeredDate(int n, Timestamp timestamp, Timestamp timestamp2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE bbsync SET trigger_startedat=?, trigger_endedat=?,last_executed=? WHERE id=?");
        preparedStatement.setTimestamp(1, timestamp);
        preparedStatement.setTimestamp(2, timestamp2);
        preparedStatement.setTimestamp(3, timestamp2);
        preparedStatement.setInt(4, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void deleteFieldMapping(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM field_mapping where id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void addFieldMapping(String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO field_mapping(db_field, bb_field) VALUES (?,?)");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updateContractLogs(Vector<String> vector, String string, Timestamp timestamp, Map<String, String> map, Collection collection) throws Exception {
        for (String string2 : collection) {
            PreparedStatement preparedStatement = this.connection().prepareStatement("SELECT * FROM reference.contractSync WHERE contract_name=? AND contract_field=?");
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO reference.contractSync(last_sync,contract_name,contract_field) VALUES(?,?,?)");
            PreparedStatement preparedStatement3 = this.connection().prepareStatement("UPDATE reference.contractSync SET last_sync=? WHERE contract_name=? AND contract_field=?");
            for (String string3 : vector) {
                string3 = string3.trim() + " " + string;
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    preparedStatement3.setTimestamp(1, timestamp);
                    preparedStatement3.setString(2, string3.trim());
                    preparedStatement3.setString(3, string2);
                    preparedStatement3.execute();
                } else {
                    preparedStatement2.setTimestamp(1, timestamp);
                    preparedStatement2.setString(2, string3.trim());
                    preparedStatement2.setString(3, string2);
                    preparedStatement2.execute();
                }
                resultSet.close();
            }
            preparedStatement.close();
            preparedStatement2.close();
            preparedStatement3.close();
        }
    }

    @Override
    public void updateSecuritiesLogs(Vector<String> vector, String string, Timestamp timestamp, Collection collection) throws Exception {
        for (String string2 : collection) {
            PreparedStatement preparedStatement = this.connection().prepareStatement("SELECT * FROM reference.SecuritySync WHERE security_name=? AND security_field=?");
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO reference.SecuritySync(last_sync,security_name,security_field) VALUES(?,?,?)");
            PreparedStatement preparedStatement3 = this.connection().prepareStatement("UPDATE reference.SecuritySync SET last_sync=? WHERE security_name=? AND security_field=?");
            for (String string3 : vector) {
                string3 = string3.trim() + " " + string;
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string2);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    preparedStatement3.setTimestamp(1, timestamp);
                    preparedStatement3.setString(2, string3.trim());
                    preparedStatement3.setString(3, string2);
                    preparedStatement3.execute();
                } else {
                    preparedStatement2.setTimestamp(1, timestamp);
                    preparedStatement2.setString(2, string3.trim());
                    preparedStatement2.setString(3, string2);
                    preparedStatement2.execute();
                }
                resultSet.close();
            }
            preparedStatement.close();
            preparedStatement2.close();
            preparedStatement3.close();
        }
    }

    @Override
    public Vector<String> getContractNames2RefSync(boolean bl) throws Exception {
        Statement statement = this.connection().createStatement();
        ResultSet resultSet = null;
        resultSet = bl ? statement.executeQuery("select * from contract_info WHERE ref_synchronized<=0 OR ref_synchronized is NULL") : statement.executeQuery("select * from contract_info");
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.add(resultSet.getString("name"));
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public Map<String, String> getSecurityNames2RefSync(boolean bl) throws Exception {
        Statement statement = this.connection().createStatement();
        ResultSet resultSet = null;
        resultSet = bl ? statement.executeQuery("select * from security_info WHERE ref_synchronized<=0 OR ref_synchronized is NULL") : statement.executeQuery("select * from security_info");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (resultSet.next()) {
            String string = resultSet.getString("name");
            String string2 = resultSet.getString("marketsector");
            linkedHashMap.put(string + " " + string2, string);
        }
        resultSet.close();
        statement.close();
        return linkedHashMap;
    }

    @Override
    public Map<String, String> getSecurityName2RefSync(String string) throws Exception {
        Statement statement = this.connection().createStatement();
        ResultSet resultSet = null;
        resultSet = statement.executeQuery("select * from security_info where name='" + string + "'");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (resultSet.next()) {
            String string2 = resultSet.getString("name");
            String string3 = resultSet.getString("marketsector");
            linkedHashMap.put(string2 + " " + string3, string2);
        }
        resultSet.close();
        statement.close();
        return linkedHashMap;
    }

    @Override
    public void updateContractReference(String string, Map<String, String> map) throws Exception {
        AutoCloseable autoCloseable;
        PreparedStatement preparedStatement = this.connection().prepareStatement("SELECT * FROM contract_info WHERE name=?");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        java.sql.Date date = null;
        java.sql.Date date2 = null;
        if (map.get("FUT_LAST_TRADE_DT") != null) {
            date2 = new java.sql.Date(simpleDateFormat.parse(map.get("FUT_LAST_TRADE_DT")).getTime());
        }
        if (map.get("FUT_NOTICE_FIRST") != null) {
            date = new java.sql.Date(simpleDateFormat.parse(map.get("FUT_NOTICE_FIRST")).getTime());
        }
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        PreparedStatement preparedStatement2 = null;
        int n = 0;
        boolean bl = true;
        if (resultSet.next()) {
            preparedStatement2 = this.connection().prepareStatement("UPDATE contract_info SET ref_synchronized=?,first_notice_date=?,last_trade_date=? WHERE name=?");
            autoCloseable = this.connection().prepareStatement("DELETE FROM contract_info_fields WHERE contract_id=(select id from contract_info where name=? limit 1)");
            autoCloseable.setString(1, string);
            autoCloseable.execute();
            autoCloseable.close();
            PreparedStatement preparedStatement3 = this.connection().prepareStatement("select id from contract_info where name=?");
            preparedStatement3.setString(1, string);
            ResultSet object = preparedStatement3.executeQuery();
            if (object.next()) {
                n = object.getInt("id");
            }
            object.close();
            preparedStatement3.close();
        } else {
            preparedStatement2 = this.connection().prepareStatement("INSERT INTO contract_info(ref_synchronized,first_notice_date,last_trade_date,name) VALUES(?,?,?,?)", 1);
            bl = false;
        }
        resultSet.close();
        preparedStatement2.setInt(1, 1);
        preparedStatement2.setDate(2, date);
        preparedStatement2.setDate(3, date2);
        preparedStatement2.setString(4, string);
        preparedStatement2.executeUpdate();
        if (!bl) {
            autoCloseable = preparedStatement2.getGeneratedKeys();
            if (autoCloseable.next()) {
                n = autoCloseable.getInt(1);
            }
            autoCloseable.close();
        }
        preparedStatement2.close();
        if (n > 0) {
            autoCloseable = this.connection().prepareStatement("INSERT INTO contract_info_fields(bb_fieldname,value,contract_id) VALUES(?,?,?)");
            for (String string2 : map.keySet()) {
                autoCloseable.setString(1, string2);
                autoCloseable.setString(2, map.get(string2));
                autoCloseable.setInt(3, n);
                autoCloseable.executeUpdate();
            }
            autoCloseable.close();
        }
    }

    @Override
    public void updateSecurityReference(String string, String string2, Map<String, String> map) throws Exception {
        AutoCloseable autoCloseable;
        PreparedStatement preparedStatement = this.connection().prepareStatement("SELECT * FROM security_info WHERE name=?");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Object var6_6 = null;
        Object var7_7 = null;
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        PreparedStatement preparedStatement2 = null;
        int n = 0;
        boolean bl = true;
        if (resultSet.next()) {
            preparedStatement2 = this.connection().prepareStatement("UPDATE security_info SET ref_synchronized=? WHERE name=?");
            autoCloseable = this.connection().prepareStatement("DELETE FROM security_info_fields WHERE security_id=(select id from security_info where name=? limit 1)");
            autoCloseable.setString(1, string);
            autoCloseable.execute();
            autoCloseable.close();
            PreparedStatement preparedStatement3 = this.connection().prepareStatement("select id from security_info where name=?");
            preparedStatement3.setString(1, string);
            ResultSet object = preparedStatement3.executeQuery();
            if (object.next()) {
                n = object.getInt("id");
            }
            object.close();
            preparedStatement3.close();
        } else {
            preparedStatement2 = this.connection().prepareStatement("INSERT INTO security_info(ref_synchronized, name,marketsector) VALUES(?,?,?)", 1);
            bl = false;
        }
        resultSet.close();
        preparedStatement2.setInt(1, 1);
        preparedStatement2.setString(2, string);
        if (!bl) {
            preparedStatement2.setString(3, string2);
        }
        preparedStatement2.executeUpdate();
        if (!bl) {
            autoCloseable = preparedStatement2.getGeneratedKeys();
            if (autoCloseable.next()) {
                n = autoCloseable.getInt(1);
            }
            autoCloseable.close();
        }
        preparedStatement2.close();
        if (n > 0) {
            autoCloseable = this.connection().prepareStatement("INSERT INTO security_info_fields(bb_fieldname,value,security_id) VALUES(?,?,?)");
            for (String string3 : map.keySet()) {
                autoCloseable.setString(1, string3);
                autoCloseable.setString(2, map.get(string3));
                autoCloseable.setInt(3, n);
                autoCloseable.executeUpdate();
            }
            autoCloseable.close();
        }
    }

    @Override
    public void addSyncLogs(int n, Timestamp timestamp, Timestamp timestamp2, String string, String string2, String string3) throws Exception {
        String string4 = "DELETE FROM bbsync_logs WHERE bbsync_id=? AND id NOT IN (select id from (select id from bbsync_logs WHERE bbsync_id=? ORDER BY start_time DESC limit 11) temp_table)";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string4);
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO bbsync_logs(bbsync_id,start_time,end_time,message,status,manual_scheduler) VALUES(?,?,?,?,?,?)");
        preparedStatement2.setInt(1, n);
        preparedStatement2.setTimestamp(2, timestamp);
        preparedStatement2.setTimestamp(3, timestamp2);
        preparedStatement2.setString(4, string);
        preparedStatement2.setString(5, string2);
        preparedStatement2.setString(6, string3);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
    }

    @Override
    public void removeScheduleTicker(int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM bbsync_contracts WHERE bbsync_id=? AND contract=?");
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string.trim());
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public int saveSchedule(int n, String string, String string2, String string3, java.sql.Date date, java.sql.Date date2, int n2, Vector vector, String string4, BBSyncTrigger bBSyncTrigger, String string5, String string6) throws Exception {
        AutoCloseable autoCloseable;
        PreparedStatement preparedStatement;
        String string7;
        this.log.debug((Object)"saveSchedule() called:");
        if (n > 0) {
            string7 = "UPDATE bbsync SET name=?,is_mkt_securitydb=?,date_option=?,date_recentnumber=?,date_from=?,date_to=?,tickers=?,trigger_type=?,fields=?,trigger_time=?,trigger_days=?,trigger_day=?,marketsector=?,trigger_week=?,trigger_dailyhour=?,timezone=? WHERE id=?";
            preparedStatement = this.connection().prepareStatement(string7);
        } else {
            string7 = "INSERT INTO bbsync(name,is_mkt_securitydb,date_option,date_recentnumber,date_from,date_to,tickers,trigger_type,fields,trigger_time,trigger_days,trigger_day,marketsector,trigger_week,trigger_dailyhour,timezone) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
            preparedStatement = this.connection().prepareStatement(string7, 1);
        }
        this.log.debug((Object)("connection:" + this.connection()));
        this.log.debug((Object)("ps:" + preparedStatement));
        this.log.debug((Object)("t:" + bBSyncTrigger));
        this.log.debug((Object)("query:" + string7));
        this.log.debug((Object)("id:" + n));
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.setInt(4, n2);
        preparedStatement.setDate(5, date);
        preparedStatement.setDate(6, date2);
        preparedStatement.setString(7, "");
        preparedStatement.setInt(8, bBSyncTrigger.getSynctype());
        preparedStatement.setString(9, "");
        preparedStatement.setString(10, bBSyncTrigger.getTime());
        preparedStatement.setString(11, bBSyncTrigger.getDays());
        preparedStatement.setInt(12, bBSyncTrigger.getDay());
        preparedStatement.setString(13, string5);
        preparedStatement.setInt(14, bBSyncTrigger.getWeek() != null ? bBSyncTrigger.getWeek() : 0);
        preparedStatement.setInt(15, bBSyncTrigger.getDailyhour() != null ? bBSyncTrigger.getDailyhour() : 0);
        preparedStatement.setString(16, string6);
        if (n > 0) {
            preparedStatement.setInt(17, n);
            preparedStatement.executeUpdate();
        } else {
            preparedStatement.executeUpdate();
            autoCloseable = preparedStatement.getGeneratedKeys();
            if (autoCloseable.next()) {
                n = autoCloseable.getInt(1);
            }
            autoCloseable.close();
        }
        preparedStatement.close();
        if (n > 0) {
            autoCloseable = this.connection().createStatement();
            autoCloseable.execute("DELETE FROM bbsync_fields WHERE bbsync_id=" + n);
            autoCloseable.close();
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT into bbsync_fields(bbsync_id,field_id) values(?,?)");
            for (int i = 0; i < vector.size(); ++i) {
                preparedStatement2.setInt(1, n);
                preparedStatement2.setInt(2, Integer.parseInt((String)vector.get(i)));
                preparedStatement2.executeUpdate();
            }
            preparedStatement2.close();
            ArrayList arrayList = new InputStringTokenParser(string4).parseFreeTextTokens();
            Statement statement = this.connection().createStatement();
            statement.execute("DELETE FROM bbsync_contracts WHERE bbsync_id=" + n);
            statement.close();
            PreparedStatement preparedStatement3 = this.connection().prepareStatement("INSERT into bbsync_contracts(bbsync_id,contract) values(?,?)");
            for (int i = 0; i < arrayList.size(); ++i) {
                preparedStatement3.setInt(1, n);
                preparedStatement3.setString(2, ((String)arrayList.get(i)).trim());
                preparedStatement3.executeUpdate();
            }
            preparedStatement3.close();
        }
        return n;
    }

    @Override
    public void deleteQuery(int n) throws Exception {
        if (n > 0) {
            Statement statement = this.connection().createStatement();
            statement.execute("DELETE FROM bbsync_fields WHERE bbsync_id=" + n);
            statement.close();
            Statement statement2 = this.connection().createStatement();
            statement2.execute("DELETE FROM bbsync_contracts WHERE bbsync_id=" + n);
            statement2.close();
            Statement statement3 = this.connection().createStatement();
            statement3.execute("DELETE FROM bbsync WHERE id=" + n);
            statement3.close();
        }
    }

    @Override
    public void peerStarted(String string, long l, Date date) throws Exception {
        Timestamp timestamp = new Timestamp(date.getTime());
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO peer_sessions(peername, sessionid,started_time) VALUES (?,?,?)");
        preparedStatement.setString(1, string);
        preparedStatement.setLong(2, l);
        preparedStatement.setTimestamp(3, timestamp);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void peerStopped(String string, long l, Date date) throws Exception {
        Timestamp timestamp = new Timestamp(date.getTime());
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE peer_sessions SET stopped_time=? WHERE peername=? AND sessionid=?");
        preparedStatement.setTimestamp(1, timestamp);
        preparedStatement.setString(2, string);
        preparedStatement.setLong(3, l);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }
}

