/*
 * Decompiled with CFR 0.152.
 */
package com.fe.db.mariadb;

import com.fe.data.PeerPackage;
import com.fe.db.RFunctionDB;
import com.fe.db.SchedulerDB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.log4j.Logger;

public class RFunctionDBMariaDB
extends RFunctionDB {
    private Logger log = Logger.getLogger(RFunctionDBMariaDB.class);

    @Override
    public String getFolderName(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select folder_name  FROM  folder  WHERE id=?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string = null;
        while (resultSet.next()) {
            string = resultSet.getString(1);
        }
        return string;
    }

    @Override
    public void updateWikiDone(int n, int n2) throws Exception {
        String string = "UPDATE r_function set is_wiki_done=? where  id=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updateFunctionOrder(int[] nArray) throws Exception {
        String string = "UPDATE r_function set disp_order=? where  id=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        for (int i = 0; i < nArray.length; ++i) {
            preparedStatement.setInt(1, i + 1);
            preparedStatement.setInt(2, nArray[i]);
            preparedStatement.executeUpdate();
        }
    }

    @Override
    public void updateFunctionDeleted(int n) throws Exception {
        String string = "UPDATE r_function set deletedon=? where  id=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setTimestamp(1, new Timestamp(new Date().getTime()));
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
    }

    @Override
    public void updateFolderOrder(int[] nArray) throws Exception {
        String string = "UPDATE folder set disp_order=? where  id=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        for (int i = 0; i < nArray.length; ++i) {
            preparedStatement.setInt(1, i + 1);
            preparedStatement.setInt(2, nArray[i]);
            preparedStatement.executeUpdate();
        }
    }

    @Override
    public List listRFunctions() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT a.*,IFNULL(TIMESTAMPDIFF(day,date(a.deletedon),now()),7) as deleteddays,b.folder_name,d.tagname as owner_tag,(select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from function_tags as st  left outer join tags on tags.id=st.tag_id WHERE st.function_id=a.id ) as stags ");
        stringBuffer.append(" FROM  r_function as a ");
        stringBuffer.append(" left outer join folder as b on a.folder_id=b.id ");
        stringBuffer.append(" left outer join function_group as c on c.group_uid=b.group_uid ");
        stringBuffer.append(" left outer join tags as d on d.id=a.owner_tag_id ");
        stringBuffer.append(" order by c.disp_order,b.disp_order,a.disp_order,a.function_name ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector;
    }

    @Override
    public List listAllRFunctionNames() throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select function_name  FROM  r_function ");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.add(resultSet.getString(1));
        }
        return vector;
    }

    @Override
    public List listAllRScriptNames(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select script_file FROM  r_function where folder_id=? order by disp_order");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<String> vector = new Vector<String>();
        while (resultSet.next()) {
            vector.add(resultSet.getString(1));
        }
        return vector;
    }

    @Override
    public List autoCompleteFunctions(String string) throws Exception {
        String string2 = null;
        if (string.contains(":") && string.split(":").length > 1) {
            string2 = string.split(":")[0];
            string = string.split(":")[1];
        }
        if (string.contains(":") && string.split(":").length == 1) {
            string2 = string.split(":")[0];
            string = null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select a.id,a.function_name,c.group_name,b.folder_name,a.last_modified, ");
        stringBuffer.append(" (select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from function_tags as st  left outer join tags on tags.id=st.tag_id WHERE st.function_id=a.id ) as stags ");
        stringBuffer.append(" from r_function as a ");
        stringBuffer.append(" left outer join folder as b on a.folder_id=b.id ");
        stringBuffer.append(" left outer join function_group as c on b.group_uid = c.group_uid ");
        stringBuffer.append(" where c.group_uid <> 'trash' ");
        if (string != null) {
            stringBuffer.append(" AND a.function_name like '%" + string + "%' ");
        }
        if (string2 != null) {
            stringBuffer.append("\t AND a.id in (select function_id from function_tags left outer join tags on function_tags.tag_id = tags.id where tags.tagname='thm-" + string2.trim() + "' ) ");
        }
        stringBuffer.append(" order by c.disp_order, b.disp_order,a.disp_order ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Map> arrayList = new ArrayList<Map>();
        while (resultSet.next()) {
            arrayList.add(new BasicRowProcessor().toMap(resultSet));
        }
        return arrayList;
    }

    @Override
    public List<Map> listOfFunctions(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select * FROM  r_function where folder_id=? order by disp_order");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Map> arrayList = new ArrayList<Map>();
        while (resultSet.next()) {
            arrayList.add(new BasicRowProcessor().toMap(resultSet));
        }
        return arrayList;
    }

    @Override
    public Map getRFunction(int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT a.*,b.folder_name,IFNULL(TIMESTAMPDIFF(day,date(a.deletedon),now()),7) as deleteddays,b.folder_name,c.tagname as owner_tag,(select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from function_tags as st  left outer join tags on tags.id=st.tag_id WHERE st.function_id=a.id ) as stags FROM  r_function as a ");
        stringBuffer.append(" left outer join tags as c on c.id=a.owner_tag_id ");
        stringBuffer.append(" left outer join folder as b on a.folder_id=b.id ");
        stringBuffer.append(" WHERE  a.id=? ORDER BY a.function_name ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        Map map = null;
        if (resultSet.next()) {
            map = new BasicRowProcessor().toMap(resultSet);
        }
        return map;
    }

    @Override
    public Map getRFunctionForScriptFile(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Select a.*,b.folder_name, ");
        stringBuffer.append("(select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from function_tags as st  left outer join tags on tags.id=st.tag_id WHERE st.function_id=a.id ) as stags ");
        stringBuffer.append("FROM  r_function as a ");
        stringBuffer.append("left outer join folder as b on a.folder_id=b.id ");
        stringBuffer.append("WHERE  a.script_file=? ");
        stringBuffer.append("ORDER BY a.function_name ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Map map = null;
        if (resultSet.next()) {
            map = new BasicRowProcessor().toMap(resultSet);
        }
        return map;
    }

    @Override
    public Vector getRFunctions(Vector vector) throws Exception {
        String string = "''";
        Object object = vector.iterator();
        while (object.hasNext()) {
            string = string + ",'" + object.next() + "'";
        }
        object = new StringBuffer();
        ((StringBuffer)object).append("Select a.*, ");
        ((StringBuffer)object).append("IFNULL(TIMESTAMPDIFF(day,date(a.deletedon),now()),7) as deleteddays, ");
        ((StringBuffer)object).append("b.folder_name, ");
        ((StringBuffer)object).append("(select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from function_tags as st  left outer join tags on tags.id=st.tag_id WHERE st.function_id=a.id ) as stags ");
        ((StringBuffer)object).append("FROM  r_function as a left outer join folder as b on a.folder_id=b.id WHERE  a.function_name IN (" + string + ") ORDER BY a.function_name ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(((StringBuffer)object).toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector2 = new Vector<Map>();
        while (resultSet.next()) {
            vector2.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector2;
    }

    @Override
    public List listFunctionGroups() throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select * from function_group ORDER BY disp_order");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector;
    }

    @Override
    public Map getRFunction(String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("Select *  FROM  r_function WHERE  function_name=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Map map = null;
        if (resultSet.next()) {
            map = new BasicRowProcessor().toMap(resultSet);
        }
        return map;
    }

    @Override
    public int createFunction(int n, String string, String string2, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO r_function(folder_id,function_name,script_file,last_modified,is_class) VALUES(?,?,?,?,?)", 1);
        preparedStatement.setInt(1, n);
        preparedStatement.setString(2, string);
        preparedStatement.setString(3, string2);
        preparedStatement.setTimestamp(4, new Timestamp(new Date().getTime()));
        preparedStatement.setInt(5, n2);
        preparedStatement.executeUpdate();
        int n3 = 0;
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        if (resultSet.next()) {
            n3 = resultSet.getInt(1);
        }
        preparedStatement.close();
        return n3;
    }

    @Override
    public void renameFunction(int n, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE r_function SET function_name=?,script_file=?,last_modified=? WHERE id=?");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setTimestamp(3, new Timestamp(new Date().getTime()));
        preparedStatement.setInt(4, n);
        preparedStatement.executeUpdate();
    }

    @Override
    public void updatedOwnerIDNow(int n, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE r_function SET last_modified=?,owner_tag_id=? WHERE id=?");
        preparedStatement.setTimestamp(1, new Timestamp(new Date().getTime()));
        preparedStatement.setInt(2, n);
        preparedStatement.setInt(3, n2);
        preparedStatement.executeUpdate();
    }

    @Override
    public void deleteFunction(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM r_function  WHERE id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("DELETE FROM function_tags  WHERE function_id=?");
        preparedStatement2.setInt(1, n);
        preparedStatement2.executeUpdate();
    }

    @Override
    public void updateFunctionFolder(int n, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE r_function SET folder_id=? WHERE id=?");
        preparedStatement.setInt(1, n2);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("update r_function set disp_order = ( ");
        stringBuffer.append("select max_disp_order from ( ");
        stringBuffer.append("select max(disp_order)+1 as max_disp_order from r_function where folder_id = ? ");
        stringBuffer.append(") as temp_table ");
        stringBuffer.append(") where id = ? ");
        PreparedStatement preparedStatement2 = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement2.setInt(1, n2);
        preparedStatement2.setInt(2, n);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
    }

    @Override
    public void updateLock(int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE r_function SET lockedby=? WHERE id=?");
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public List listOfFolders() throws Exception {
        PreparedStatement preparedStatement = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Select a.*, ");
        stringBuffer.append("(select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from folder_tags as st  left outer join tags on tags.id=st.tag_id WHERE st.folder_id=a.id ) as stags ");
        stringBuffer.append("FROM folder as a left outer join function_group as b on b.group_uid = a.group_uid ORDER BY b.disp_order,a.disp_order ");
        preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector;
    }

    @Override
    public List listOfFolders(String string) throws Exception {
        PreparedStatement preparedStatement = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Select *, ");
        stringBuffer.append("(select CONCAT(GROUP_CONCAT(cast(tags.tagname as CHAR(8000)) order by tags.tagname SEPARATOR ', '), ', ') from folder_tags as st  left outer join tags on tags.id=st.tag_id WHERE st.folder_id=a.id ) as stags ");
        stringBuffer.append("FROM folder as a WHERE group_uid=?  ORDER BY disp_order ");
        preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector;
    }

    @Override
    public void moveFolder(int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE folder SET group_uid = ? WHERE  id=?");
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public int getFolderID(String string) throws Exception {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.connection().prepareStatement("Select * FROM folder WHERE folder_name=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        if (resultSet.next()) {
            n = resultSet.getInt("id");
        }
        return n;
    }

    @Override
    public int createFolder(String string, String string2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("INSERT INTO folder(folder_name,group_uid) VALUES(?,?)", 1);
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.executeUpdate();
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        int n = 0;
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        preparedStatement.close();
        return n;
    }

    @Override
    public void renameFolder(int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE folder SET folder_name = ? WHERE  id=?");
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void removeFolder(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM folder WHERE  id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public Vector getTags() throws Exception {
        Vector<Map> vector = new Vector<Map>();
        PreparedStatement preparedStatement = this.connection().prepareStatement("select * FROM tags ORDER BY tagname");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        return vector;
    }

    @Override
    public Vector getTagIds4Function(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select tag_id FROM function_tags WHERE function_id=?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Integer> vector = new Vector<Integer>();
        while (resultSet.next()) {
            vector.add(resultSet.getInt("tag_id"));
        }
        return vector;
    }

    @Override
    public ArrayList getTagIds4Folder(int n, String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select tag_id FROM " + string + " WHERE folder_id=?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (resultSet.next()) {
            arrayList.add(resultSet.getInt("tag_id"));
        }
        return arrayList;
    }

    @Override
    public List getThemeTags4Folder(int n) throws Exception {
        String string = "select replace(b.tagname,'thm-','') as theme FROM folder_tags as a ";
        string = string + "left outer join " + this.getTagTable() + " as b on a.tag_id=b.id ";
        string = string + "where a.folder_id=? ";
        string = string + "and left(b.tagname,4)='thm-' ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString("theme"));
        }
        return arrayList;
    }

    @Override
    public void updateTagIds4Folder(int n, List list, int n2, String string) throws Exception {
        PreparedStatement preparedStatement;
        if (SchedulerDB.REMOVE_BEFORE_UPDATE == n2) {
            preparedStatement = this.connection().prepareStatement("DELETE FROM " + string + " WHERE folder_id=?");
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        preparedStatement = this.connection().prepareStatement("INSERT INTO " + string + "(folder_id,tag_id) VALUES(?,?)");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, Integer.parseInt((String)iterator.next()));
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
    }

    @Override
    public void updateLast2UsersTag(int n, int n2) throws Exception {
        String string = "DELETE FROM function_tags WHERE id IN ( select id from ( SELECT st.id FROM function_tags as st ";
        string = string + " LEFT OUTER JOIN tags  on tags.id=st.tag_id ";
        string = string + " WHERE st.id NOT IN( ";
        string = string + "   select st1.id from function_tags as st1 ";
        string = string + "   left outer join tags as t1 on t1.id=st1.tag_id ";
        string = string + "   WHERE LEFT(t1.tagname,4)='usr-' AND st1.function_id=st.function_id ";
        string = string + "   order by st1.id desc ";
        string = string + " ) ";
        string = string + " AND LEFT(tags.tagname,4)='usr-' AND st.function_id=? ) temp_table) ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("DELETE FROM function_tags WHERE function_id=? AND tag_id=?");
        preparedStatement2.setInt(1, n);
        preparedStatement2.setInt(2, n2);
        preparedStatement2.executeUpdate();
        PreparedStatement preparedStatement3 = this.connection().prepareStatement("INSERT INTO function_tags(function_id,tag_id) VALUES(?,?)");
        preparedStatement3.setInt(1, n);
        preparedStatement3.setInt(2, n2);
        preparedStatement3.executeUpdate();
        preparedStatement3.close();
    }

    @Override
    public int addIfTagNotExist(String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select * FROM tags WHERE tagname=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        if (resultSet.next()) {
            n = resultSet.getInt("id");
        } else {
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("insert into tags(tagname) values(?)", 1);
            preparedStatement2.setString(1, string);
            preparedStatement2.executeUpdate();
            ResultSet resultSet2 = preparedStatement2.getGeneratedKeys();
            if (resultSet2.next()) {
                n = resultSet2.getInt(1);
            }
        }
        return n;
    }

    @Override
    public void addTagIds4Function(int n, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM function_tags WHERE function_id=? and tag_id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO function_tags(function_id,tag_id) VALUES(?,?)");
        preparedStatement2.setInt(1, n);
        preparedStatement2.setInt(2, n2);
        preparedStatement2.executeUpdate();
        preparedStatement2.close();
    }

    @Override
    public void removeTagIds4Function(int n, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM function_tags WHERE function_id=? and tag_id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void setGroupOrder(Vector vector) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("UPDATE function_group SET disp_order=? WHERE group_uid=?");
        int n = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            preparedStatement.setInt(1, n++);
            preparedStatement.setString(2, (String)iterator.next());
            preparedStatement.executeUpdate();
        }
    }

    @Override
    public Map getAllFunctionNamesID(String string) throws Exception {
        String string2 = "select id,function_name from r_function ";
        if (string != null && !string.equals("")) {
            string2 = string2 + " WHERE " + string;
        }
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        while (resultSet.next()) {
            int n = resultSet.getInt("id");
            String string3 = resultSet.getString("function_name");
            hashMap.put(n, string3);
        }
        return hashMap;
    }

    @Override
    public boolean updatePeerPackage(String string, ArrayList<PeerPackage> arrayList) throws Exception {
        try {
            this.connection().setAutoCommit(false);
            PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM peer_packages WHERE peername=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO peer_packages(peername,packagename,version,lastchecked) VALUES(?,?,?,?)");
            for (PeerPackage peerPackage : arrayList) {
                preparedStatement2.setString(1, string);
                preparedStatement2.setString(2, peerPackage.getPackagename());
                preparedStatement2.setString(3, peerPackage.getVersion());
                preparedStatement2.setTimestamp(4, new Timestamp(peerPackage.getLastchecked().getTime()));
                preparedStatement2.executeUpdate();
            }
            preparedStatement2.close();
            this.connection().commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.connection().rollback();
            throw exception;
        }
        finally {
            this.connection().setAutoCommit(false);
        }
    }

    @Override
    public Map getPackageInfo(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select a.version, ");
        stringBuffer.append("(select CONCAT(GROUP_CONCAT(cast(b.peername as CHAR(8000)) SEPARATOR ', '), ', ') from peer_packages as b where b.packagename=? and b.version=a.version ) as peers ");
        stringBuffer.append("from peer_packages as a ");
        stringBuffer.append("where a.packagename=? ");
        stringBuffer.append("group by a.version ");
        PreparedStatement preparedStatement = this.connection().prepareStatement(stringBuffer.toString());
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string + "");
        ResultSet resultSet = preparedStatement.executeQuery();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (resultSet.next()) {
            String string2 = resultSet.getString("version");
            String string3 = resultSet.getString("peers");
            string3 = string3.substring(0, string3.lastIndexOf(","));
            linkedHashMap.put(string2, string3);
        }
        resultSet.close();
        preparedStatement.close();
        return linkedHashMap;
    }

    @Override
    public List getDefaultHierarchyDependsIds(String string) throws Exception {
        String string2 = "";
        string2 = string2 + "select a.id,a.folder_name from folder as a ";
        string2 = string2 + " left outer join function_group as b on a.group_uid = b.group_uid ";
        string2 = string2 + " order by b.disp_order, a.disp_order  ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = true;
        while (resultSet.next() && bl) {
            Integer n = resultSet.getInt("id");
            String string3 = resultSet.getString("folder_name");
            if (string3.equals(string)) {
                bl = false;
                continue;
            }
            arrayList.add(n);
        }
        return arrayList;
    }

    @Override
    public List listRelatedFolderIds(int n) throws Exception {
        String string = "select related_folder_id from folder_dependencies where folder_id=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (resultSet.next()) {
            Integer n2 = resultSet.getInt("related_folder_id");
            arrayList.add(n2);
        }
        return arrayList;
    }

    @Override
    public void updateRelatedFolderIds(int n, List<Integer> list) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE from folder_dependencies where folder_id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO folder_dependencies(folder_id,related_folder_id) VALUES(?,?)");
        for (Integer n2 : list) {
            preparedStatement2.setInt(1, n);
            preparedStatement2.setInt(2, n2);
            preparedStatement2.executeUpdate();
        }
        preparedStatement2.close();
    }

    @Override
    public void addTag4Package(int n, int[] nArray, boolean bl) throws Exception {
        try {
            this.connection().setAutoCommit(false);
            PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM function_tags WHERE function_id=? and tag_id=?");
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("insert into function_tags(function_id,tag_id)  VALUES(?,?)");
            PreparedStatement preparedStatement3 = this.connection().prepareStatement("UPDATE r_function SET owner_tag_id=? WHERE id=?");
            for (int i = 0; i < nArray.length; ++i) {
                preparedStatement.setInt(1, nArray[i]);
                preparedStatement.setInt(2, n);
                preparedStatement.executeUpdate();
                this.log.debug((Object)"tags deleted");
                preparedStatement2.setInt(1, nArray[i]);
                preparedStatement2.setInt(2, n);
                preparedStatement2.executeUpdate();
                this.log.debug((Object)"tags added");
                if (!bl) continue;
                preparedStatement3.setInt(1, n);
                preparedStatement3.setInt(2, nArray[i]);
                preparedStatement3.executeUpdate();
            }
            preparedStatement.close();
            preparedStatement2.close();
            preparedStatement3.close();
            this.connection().commit();
        }
        catch (Exception exception) {
            this.connection().rollback();
            throw exception;
        }
        finally {
            this.connection().setAutoCommit(true);
        }
    }

    @Override
    public void removeTag4Package(int n, int[] nArray) throws Exception {
        try {
            this.connection().setAutoCommit(false);
            this.connection().setAutoCommit(false);
            for (int i = 0; i < nArray.length; ++i) {
                PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM function_tags WHERE function_id=? and tag_id=?");
                preparedStatement.setInt(1, nArray[i]);
                preparedStatement.setInt(2, n);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                this.log.debug((Object)"tags deleted");
                PreparedStatement preparedStatement2 = this.connection().prepareStatement("update r_function set owner_tag_id=(select tag_id from function_tags where function_id=r_function.id order by id limit 1) where id=?");
                preparedStatement2.setInt(1, nArray[i]);
                preparedStatement2.executeUpdate();
                preparedStatement2.close();
            }
            this.connection().commit();
        }
        catch (Exception exception) {
            this.connection().rollback();
            throw exception;
        }
        finally {
            this.connection().setAutoCommit(true);
        }
    }

    @Override
    public void addNotificationTag4Package(int n, int[] nArray, boolean bl) throws Exception {
        try {
            this.connection().setAutoCommit(false);
            PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM function_followtags WHERE function_id=? and tag_id=?");
            PreparedStatement preparedStatement2 = this.connection().prepareStatement("insert into function_followtags(function_id,tag_id)  VALUES(?,?)");
            for (int i = 0; i < nArray.length; ++i) {
                preparedStatement.setInt(1, nArray[i]);
                preparedStatement.setInt(2, n);
                preparedStatement.executeUpdate();
                if (!bl) continue;
                preparedStatement2.setInt(1, nArray[i]);
                preparedStatement2.setInt(2, n);
                preparedStatement2.executeUpdate();
            }
            preparedStatement.close();
            preparedStatement2.close();
            this.connection().commit();
        }
        catch (Exception exception) {
            this.connection().rollback();
            throw exception;
        }
        finally {
            this.connection().setAutoCommit(true);
        }
    }
}

