/*
 * Decompiled with CFR 0.152.
 */
package com.fe.db.mariadb;

import com.fe.db.TradeDB;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Vector;

public class TradeDBMariaDB
extends TradeDB {
    @Override
    public void createTable(Connection connection) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE IF NOT EXISTS tblTrading ( ");
        stringBuffer.append(" cdate datetime NOT NULL, ");
        stringBuffer.append(" qty numeric(18, 1) NOT NULL, ");
        stringBuffer.append(" contract varchar(50) NOT NULL, ");
        stringBuffer.append(" price numeric(20, 8) NOT NULL, ");
        stringBuffer.append(" account varchar(50) NOT NULL, ");
        stringBuffer.append(" reconciled tinyint NULL, ");
        stringBuffer.append(" source varchar(50), ");
        stringBuffer.append(" commodity varchar(2) AS (left(contract,(2))) ");
        stringBuffer.append(") ");
        Statement statement = connection.createStatement();
        statement.execute(stringBuffer.toString());
        statement.close();
    }

    @Override
    public List getAllCommodities(Connection connection) throws Exception {
        Vector<String> vector = new Vector<String>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT distinct commodity FROM tblTrading");
        while (resultSet.next()) {
            vector.add(resultSet.getString("commodity"));
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public List getAllUniqueAccounts(Connection connection) throws Exception {
        Vector<String> vector = new Vector<String>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT distinct account FROM tblTrading");
        while (resultSet.next()) {
            vector.add(resultSet.getString("account"));
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public List getUniqueContracts(Connection connection, String string) throws Exception {
        Vector<String> vector = new Vector<String>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT distinct contract FROM tblTrading " + (string != null ? string : ""));
        while (resultSet.next()) {
            vector.add(resultSet.getString("contract"));
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public String generateSQLXLQuery(String string, Vector<String> vector, Vector vector2, boolean bl) {
        String string22;
        Object object;
        Vector<String> vector3 = new Vector<String>();
        if (!bl && vector2.size() > 0) {
            object = vector2.iterator();
            while (object.hasNext()) {
                vector3.add("commodity='" + object.next() + "'");
            }
        }
        for (String string22 : vector) {
            vector3.add("contract='" + string22 + "'");
        }
        object = "SELECT * FROM tblTrading ";
        string22 = null;
        if (vector3.size() > 0) {
            for (String string3 : vector3) {
                string22 = string22 == null ? "\n" + string3 : string22 + " OR \n" + string3;
            }
        }
        if (string != null && !string.trim().equals("")) {
            string22 = string22 != null ? " WHERE (" + string22 + ") AND (" + string.trim() + ")" : " WHERE " + string.trim() + " ";
        } else if (string22 != null) {
            string22 = " WHERE " + string22 + " ";
        }
        if (string22 != null) {
            object = (String)object + string22;
        }
        return object;
    }

    @Override
    public String getUniqueContractsWhereCondQuery(String string, Vector<String> vector, Vector vector2, boolean bl, String string2, String string3) {
        Object object;
        Vector<String> vector3 = new Vector<String>();
        if (!bl && vector2.size() > 0) {
            object = vector2.iterator();
            while (object.hasNext()) {
                vector3.add("commodity='" + object.next() + "'");
            }
        }
        for (String object2 : vector) {
            vector3.add("contract='" + object2 + "'");
        }
        object = null;
        if (vector3.size() > 0) {
            for (String string4 : vector3) {
                object = object == null ? "\n" + string4 : (String)object + " OR \n" + string4;
            }
        }
        if (string != null && !string.trim().equals("")) {
            object = object != null ? " WHERE (" + object + ") AND (" + string.trim() + ")" : " WHERE " + string.trim() + " ";
        } else if (object != null) {
            object = " WHERE " + object + " ";
        }
        if (string2 != null && !string2.equals("")) {
            object = object != null ? (String)object + "AND (source='" + string2 + "') " : " WHERE source='" + string2 + "') ";
        }
        if (string3 != null && !string3.equals("")) {
            object = object != null ? (String)object + "AND (account='" + string3 + "') " : " WHERE account='" + string3 + "') ";
        }
        return object;
    }

    @Override
    public String generateOpenPositionQuery(List<String> list, String string, String string2, String string3) {
        String string4 = "select date_format(cdateonly, '%d %b %Y') as Date ";
        for (String string5 : list) {
            String string6 = "";
            if (string2 != null && !string2.equals("")) {
                string6 = " AND a.account='" + string2 + "' ";
            }
            if (string != null && !string.equals("")) {
                string4 = string4 + ",(select sum(qty) from tblTrading as a where a.cdateonly<=b.cdateonly and a.contract='" + string5 + "' and a.source='" + string + "' " + string6 + ")  AS '" + string5 + "'\n";
                continue;
            }
            string4 = string4 + ",(select sum(qty) from tblTrading as a where a.cdateonly<=b.cdateonly and a.contract='" + string5 + "' " + string6 + ")  AS '" + string5 + "'\n";
        }
        string4 = string4 + " FROM tblTrading as b " + (string3 != null ? string3 : "") + "  GROUP BY cdateonly ORDER BY cdateonly ";
        return string4;
    }
}

