/*
 * Decompiled with CFR 0.152.
 */
package com.fe.db.sqlserver;

import com.fe.data.Contract;
import com.fe.data.Strategy;
import com.fe.db.ContractDB;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ContractDBSQL
extends ContractDB {
    private Logger log = Logger.getLogger(ContractDB.class);
    private String tablename;

    public ContractDBSQL(String string) {
        this.tablename = string;
    }

    @Override
    public void updateRecords(Connection connection, Vector vector) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT into [" + this.tablename + "] (cdate,contract,val) VALUES(?,?,?) ");
        PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT cdate FROM [" + this.tablename + "] WHERE cdate=? AND contract=?");
        PreparedStatement preparedStatement3 = connection.prepareStatement("UPDATE [" + this.tablename + "] SET val=? WHERE cdate=? AND contract=?");
        this.log.debug((Object)("records: size:" + vector.size()));
        for (Contract contract : vector) {
            this.log.debug((Object)("contract: date():" + contract.getCdate()));
            preparedStatement2.setDate(1, new Date(contract.getCdate().getTime()));
            preparedStatement2.setString(2, contract.getName());
            if (!preparedStatement2.executeQuery().next()) {
                preparedStatement.setDate(1, new Date(contract.getCdate().getTime()));
                preparedStatement.setString(2, contract.getName());
                preparedStatement.setDouble(3, contract.getValue());
                preparedStatement.executeUpdate();
                continue;
            }
            preparedStatement3.setDouble(1, contract.getValue());
            preparedStatement3.setDate(2, new Date(contract.getCdate().getTime()));
            preparedStatement3.setString(3, contract.getName());
            preparedStatement3.executeUpdate();
        }
        preparedStatement2.close();
        preparedStatement3.close();
        preparedStatement.close();
    }

    @Override
    public void addRecords(Connection connection, Vector vector) throws Exception {
        this.log.debug((Object)("records: size:" + vector.size()));
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT into " + this.tablename + "(cdate,contract,val) VALUES(?,?,?) ");
        for (Contract contract : vector) {
            this.log.debug((Object)("contract: date():" + contract.getCdate()));
            this.log.debug((Object)("contract: sqldbs():" + new Date(contract.getCdate().getTime())));
            this.log.debug((Object)("contract: this.tablename():" + this.tablename));
            preparedStatement.setDate(1, new Date(contract.getCdate().getTime()));
            preparedStatement.setString(2, contract.getName());
            preparedStatement.setDouble(3, contract.getValue());
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
    }

    @Override
    public void createTable(Connection connection, int n) throws Exception {
        String string = "IF NOT EXISTS (select * from sysobjects where id = object_id('" + this.tablename + "') and OBJECTPROPERTY(id, 'IsUserTable') = 1) ";
        string = string + "BEGIN ";
        string = string + "CREATE TABLE [" + this.tablename + "] ( ";
        string = string + "cdate datetime NOT NULL ,";
        string = string + "contract varchar(50), ";
        string = string + "val numeric(20," + n + ")  ";
        string = string + ") ";
        string = string + "END ";
        Statement statement = connection.createStatement();
        statement.execute(string);
        statement.close();
    }

    @Override
    public void updateSValRecords(Connection connection, Vector vector) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT into " + this.tablename + "(cdate,contract,val,sval) VALUES(?,?,?,?) ");
        PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT cdate FROM " + this.tablename + " WHERE cdate=? AND contract=?");
        PreparedStatement preparedStatement3 = connection.prepareStatement("UPDATE " + this.tablename + " SET val=?,sval=? WHERE cdate=? AND contract=?");
        for (Strategy strategy : vector) {
            preparedStatement2.setDate(1, new Date(strategy.getCdate().getTime()));
            preparedStatement2.setString(2, strategy.getName());
            if (!preparedStatement2.executeQuery().next()) {
                preparedStatement.setDate(1, new Date(strategy.getCdate().getTime()));
                preparedStatement.setString(2, strategy.getName());
                if (strategy.getSvalue() != null) {
                    preparedStatement.setObject(3, null);
                } else {
                    preparedStatement.setDouble(3, strategy.getValue());
                }
                preparedStatement.setString(4, strategy.getSvalue());
                preparedStatement.executeUpdate();
                continue;
            }
            if (strategy.getSvalue() != null) {
                preparedStatement3.setObject(1, null);
            } else {
                preparedStatement3.setDouble(1, strategy.getValue());
            }
            preparedStatement3.setString(2, strategy.getSvalue());
            preparedStatement3.setDate(3, new Date(strategy.getCdate().getTime()));
            preparedStatement3.setString(4, strategy.getName());
            preparedStatement3.executeUpdate();
        }
        preparedStatement2.close();
        preparedStatement3.close();
        preparedStatement.close();
    }

    @Override
    public void addSValRecords(Connection connection, Vector vector) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT into " + this.tablename + "(cdate,contract,sval) VALUES(?,?,?) ");
        for (Strategy strategy : vector) {
            preparedStatement.setDate(1, new Date(strategy.getCdate().getTime()));
            preparedStatement.setString(2, strategy.getName());
            preparedStatement.setString(3, strategy.getSvalue());
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
    }

    @Override
    public void createSValTable(Connection connection, int n) throws Exception {
        String string = "IF NOT EXISTS (select * from sysobjects where id = object_id('" + this.tablename + "') and OBJECTPROPERTY(id, 'IsUserTable') = 1) ";
        string = string + "BEGIN ";
        string = string + "CREATE TABLE [" + this.tablename + "] ( ";
        string = string + "cdate datetime NOT NULL ,";
        string = string + "contract varchar(50), ";
        string = string + "sval varchar(50), ";
        string = string + "val numeric(20," + n + ")  ";
        string = string + ") ";
        string = string + "END ";
        Statement statement = connection.createStatement();
        statement.execute(string);
        statement.close();
    }

    @Override
    public int checkSValueField(Connection connection) throws Exception {
        String string = "select count(*) as cnum  from [" + this.tablename + "] where val is not null";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        int n = 1;
        if (resultSet.next()) {
            n = resultSet.getInt("cnum");
        }
        resultSet.close();
        statement.close();
        return n;
    }

    @Override
    public int countRecords(Connection connection) throws Exception {
        String string = "select count(*) as cnum  from [" + this.tablename + "] ";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        int n = 1;
        if (resultSet.next()) {
            n = resultSet.getInt("cnum");
        }
        resultSet.close();
        statement.close();
        return n;
    }

    @Override
    public boolean checkSValueFieldTypeExist(Connection connection) throws Exception {
        String string = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '" + this.tablename + "' AND COLUMN_NAME = 'sval'";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        boolean bl = false;
        if (resultSet.next()) {
            bl = true;
        }
        return bl;
    }

    @Override
    public List getContractTitles(Connection connection) throws Exception {
        Vector<String> vector = new Vector<String>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT distinct contract FROM " + this.tablename);
        while (resultSet.next()) {
            vector.add(resultSet.getString("contract"));
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public List getContractTitles(Connection connection, String string) throws Exception {
        Vector<String> vector = new Vector<String>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT distinct contract FROM " + this.tablename + (string != null && !string.equals("") ? "  WHERE " + string : ""));
        while (resultSet.next()) {
            vector.add(resultSet.getString("contract"));
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public void updateMasterTable(Connection connection, String string, String string2) throws Exception {
        String string3 = "IF NOT EXISTS (select * from sysobjects where id = object_id('asset_master') and OBJECTPROPERTY(id, 'IsUserTable') = 1) ";
        string3 = string3 + "BEGIN ";
        string3 = string3 + "CREATE TABLE asset_master ( ";
        string3 = string3 + "commodity varchar(50) NOT NULL ,";
        string3 = string3 + "commodity_field varchar(100), ";
        string3 = string3 + "commodity_fieldoriginal varchar(100) ";
        string3 = string3 + ") ";
        string3 = string3 + "END ";
        Statement statement = connection.createStatement();
        statement.execute(string3);
        statement.close();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT commodity FROM asset_master WHERE commodity=? AND commodity_field=?");
        PreparedStatement preparedStatement2 = connection.prepareStatement("INSERT into asset_master(commodity,commodity_field,commodity_fieldoriginal) VALUES(?,?,?) ");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, this.tablename);
        if (!preparedStatement.executeQuery().next()) {
            preparedStatement2.setString(1, string);
            preparedStatement2.setString(2, this.tablename);
            preparedStatement2.setString(3, string2);
            preparedStatement2.executeUpdate();
        }
        preparedStatement.close();
        preparedStatement2.close();
    }

    @Override
    public String generateSQLXLQueryPlainQuery(String string, int n, List list) {
        String string2 = "SELECT cdate ";
        for (String string3 : list) {
            string2 = string2 + ",\r\nMAX(CASE WHEN contract='" + string3 + "' THEN val END) AS " + string3 + " ";
        }
        string2 = string2 + "\r\nFROM " + string + " WHERE cdate>=DATEADD(m,-" + n + ",current_timestamp) GROUP BY cdate ORDER BY cdate DESC";
        return string2;
    }

    public String generateSQLXLQuery1Query(String string, String string2, Vector<String> vector, List list) {
        String string3 = "SELECT cdate ";
        for (String string4 : list) {
            if (vector.size() < 1) {
                string3 = string3 + ",\r\nMAX(CASE WHEN contract='" + string4 + "' THEN val END) AS '" + string4 + "' ";
                continue;
            }
            if (vector.size() <= 0 || !vector.contains(string4.toLowerCase())) continue;
            string3 = string3 + ",\r\nMAX(CASE WHEN contract='" + string4 + "' THEN val END) AS '" + string4 + "' ";
        }
        string3 = string3 + "\r\nFROM " + string + " ";
        string3 = string3 + (string2 != null && !string2.equals("") ? "  WHERE " + string2 : "");
        string3 = string3 + " GROUP BY cdate ORDER BY cdate DESC";
        return string3;
    }

    public String generateSQLXLQuery2Query(Vector<String> vector, List<String> list, List<String> list2, Map<String, Vector> map, String string, String string2) throws Exception {
        String string3 = "SELECT cdate ";
        if (vector.size() > 0) {
            for (String string4 : vector) {
                if (!list2.contains(string4)) continue;
                string3 = string3 + ",\r\nMAX(CASE WHEN contract='" + string4.toUpperCase() + "' THEN " + string2 + " END) AS '" + string4.toUpperCase() + "' ";
            }
        } else {
            int n = 0;
            for (String string5 : list) {
                Vector vector2 = map.get(string5);
                if (vector2 == null) continue;
                n += vector2.size();
                for (String string6 : vector2) {
                    string3 = string3 + ",\r\nMAX(CASE WHEN contract='" + string6 + "' THEN " + string2 + " END) AS '" + string6 + "' ";
                }
            }
            if (n > 4000) {
                throw new Exception("Total # of Securities found " + n + ", It supports only less than 4000 securities, please specify instead of selecting all");
            }
        }
        string3 = string3 + "\r\nFROM (" + string + ") as outertable";
        string3 = string3 + " GROUP BY cdate ORDER BY cdate DESC";
        this.log.debug((Object)("generated query:" + string3));
        return string3;
    }
}

