/*
 * Decompiled with CFR 0.152.
 */
package com.fe.db.sqlserver;

import com.fe.ValueObject;
import com.fe.db.UtilDB;
import com.fe.migrate.historical.HistoricalMarketData;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.log4j.Logger;

public class UtilDBSQL
extends UtilDB {
    private Logger log = Logger.getLogger(UtilDB.class);

    @Override
    public List listCommodities(Connection connection) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sysobjects where id = object_id('asset_master') and OBJECTPROPERTY(id, 'IsUserTable') = 1");
        Vector<String> vector = new Vector<String>();
        if (resultSet.next()) {
            Statement statement2 = connection.createStatement();
            ResultSet resultSet2 = statement2.executeQuery("Select distinct commodity from asset_master ORDER BY commodity");
            while (resultSet2.next()) {
                vector.add(resultSet2.getString("commodity"));
            }
            statement2.close();
            resultSet2.close();
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public List listCommoditiesWithFilter(Connection connection, String string) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sysobjects where id = object_id('asset_master') and OBJECTPROPERTY(id, 'IsUserTable') = 1");
        Vector<String> vector = new Vector<String>();
        if (resultSet.next()) {
            Statement statement2 = connection.createStatement();
            ResultSet resultSet2 = statement2.executeQuery("Select distinct commodity from asset_master where SUBSTRING (commodity , 1, 1) in (" + string + ") ORDER BY commodity");
            while (resultSet2.next()) {
                vector.add(resultSet2.getString("commodity"));
            }
            statement2.close();
            resultSet2.close();
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public List listCommoditiesFirstLetters(Connection connection) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sysobjects where id = object_id('asset_master') and OBJECTPROPERTY(id, 'IsUserTable') = 1");
        Vector<String> vector = new Vector<String>();
        if (resultSet.next()) {
            Statement statement2 = connection.createStatement();
            ResultSet resultSet2 = statement2.executeQuery("select distinct(SUBSTRING(UPPER(commodity) , 1, 1)) as l  from asset_master ORDER BY l");
            while (resultSet2.next()) {
                vector.add(resultSet2.getString("l"));
            }
            statement2.close();
            resultSet2.close();
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public List uniqueFields(Connection connection) throws Exception {
        Vector<String> vector = new Vector<String>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sysobjects where id = object_id('asset_master') and OBJECTPROPERTY(id, 'IsUserTable') = 1");
        if (resultSet.next()) {
            Statement statement2 = connection.createStatement();
            ResultSet resultSet2 = statement2.executeQuery("select distinct commodity_fieldoriginal as field from asset_master");
            while (resultSet2.next()) {
                vector.add(resultSet2.getString("field"));
            }
            statement2.close();
            resultSet2.close();
        }
        statement.close();
        resultSet.close();
        return vector;
    }

    @Override
    public List<Map> listAllTables4Fields(Connection connection, String string, String string2) throws Exception {
        Vector<Map> vector = new Vector<Map>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from asset_master where commodity_fieldoriginal IN (" + string + ") AND commodity IN (" + string2 + ")");
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        statement.close();
        resultSet.close();
        return vector;
    }

    @Override
    public List<Map> listAllOrphanedAssets(Connection connection) throws Exception {
        Vector<Map> vector = new Vector<Map>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from asset_master where commodity_field not in(select name from sysobjects where name in (select commodity_field from asset_master) AND xtype='U')");
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        statement.close();
        resultSet.close();
        return vector;
    }

    @Override
    public void removeAllOrphanedAssets(Connection connection) throws Exception {
        Vector vector = new Vector();
        Statement statement = connection.createStatement();
        statement.executeUpdate("delete from asset_master WHERE commodity_field IN (select commodity_field from asset_master where commodity_field not in(select name from sysobjects where name in (select commodity_field from asset_master) AND xtype='U'))");
        statement.close();
    }

    @Override
    public List<String> listAllTables4Commodities(Connection connection, String string, Vector<String> vector) throws Exception {
        Vector<String> vector2 = new Vector<String>();
        PreparedStatement preparedStatement = connection.prepareStatement("select * from asset_master WHERE commodity_fieldoriginal=(select top 1 commodity_fieldoriginal from asset_master WHERE commodity_field=?) AND commodity=?");
        for (String string2 : vector) {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector2.add(resultSet.getString("commodity_field"));
            }
            resultSet.close();
        }
        preparedStatement.close();
        return vector2;
    }

    @Override
    public String getFieldOriginal(Connection connection, String string) throws Exception {
        Vector vector = new Vector();
        PreparedStatement preparedStatement = connection.prepareStatement("select commodity_fieldoriginal from asset_master WHERE commodity_field=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string2 = null;
        if (resultSet.next()) {
            string2 = resultSet.getString("commodity_fieldoriginal");
        }
        resultSet.close();
        preparedStatement.close();
        return string2;
    }

    @Override
    public Vector<ValueObject> listAllTables4Commodities2(Connection connection, String string, Vector<String> vector) throws Exception {
        Vector<ValueObject> vector2 = new Vector<ValueObject>();
        PreparedStatement preparedStatement = connection.prepareStatement("select * from asset_master WHERE commodity_fieldoriginal=(select top 1 commodity_fieldoriginal from asset_master  WHERE commodity_field=?) AND commodity=?");
        for (String string2 : vector) {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                ValueObject valueObject = new ValueObject();
                valueObject.setKey(string2);
                valueObject.setValue(resultSet.getString("commodity_field"));
                vector2.add(valueObject);
            }
            resultSet.close();
        }
        preparedStatement.close();
        return vector2;
    }

    @Override
    public TreeMap<String, Vector> listAllContractTitles(Connection connection, String string) throws Exception {
        TreeMap<String, Vector> treeMap = new TreeMap<String, Vector>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("Select distinct contract,tbl_name FROM (" + string + ") as outertable ORDER BY tbl_name");
        while (resultSet.next()) {
            Vector vector;
            String string2 = resultSet.getString("tbl_name");
            if (treeMap.get(string2) == null) {
                vector = new Vector();
                treeMap.put(string2, vector);
            } else {
                vector = treeMap.get(string2);
            }
            vector.add(resultSet.getString("contract"));
        }
        statement.close();
        resultSet.close();
        return treeMap;
    }

    @Override
    public TreeMap<String, Vector> listAllContractTitles2(Connection connection, String string) throws Exception {
        TreeMap<String, Vector> treeMap = new TreeMap<String, Vector>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("Select distinct contract,tbl_name FROM (" + string + ") as outertable ORDER BY tbl_name");
        while (resultSet.next()) {
            Vector vector;
            String string2 = resultSet.getString("tbl_name");
            if (treeMap.get(string2) == null) {
                vector = new Vector();
                treeMap.put(string2, vector);
            } else {
                vector = treeMap.get(string2);
            }
            vector.add(resultSet.getString("contract"));
        }
        statement.close();
        resultSet.close();
        return treeMap;
    }

    @Override
    public List<String> listAllContractTitles2LCase(Connection connection, String string) throws Exception {
        Vector<String> vector = new Vector<String>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("Select distinct contract FROM (" + string + ") as outertable");
        while (resultSet.next()) {
            vector.add(resultSet.getString("contract").toLowerCase());
        }
        statement.close();
        resultSet.close();
        return vector;
    }

    @Override
    public boolean removeCommodityAndFields(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT commodity_field FROM  asset_master WHERE commodity=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            String string2 = resultSet.getString("commodity_field");
            Statement statement = connection.createStatement();
            statement.execute("DROP TABLE [dbo].[" + string2 + "]");
            statement.close();
            String string3 = "DELETE FROM asset_master WHERE commodity_field='" + string2 + "'";
            Statement statement2 = connection.createStatement();
            statement2.execute(string3);
            statement2.close();
        }
        resultSet.close();
        preparedStatement.close();
        return true;
    }

    @Override
    public Vector getRawData(String string, Connection connection, String string2, String string3) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT CONVERT  ( varchar(40),cdate,103 ) as cdate1,  * FROM  [" + string2 + "] WHERE contract=? AND " + string + " ORDER BY CDATE DESC");
        preparedStatement.setString(1, string3);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public List getRecordCount4Contracts(Connection connection, String string, String string2) throws Exception {
        String string3 = "select 'select '+char(39)+char(39)+' as rw,'+char(39)+char(39)+' as field,'+char(39)+char(39) union all select 'UNION ALL select count(*) as rw,'+char(39)+commodity_fieldoriginal+char(39)+' as field,'+char(39)+'" + string + "'+char(39)+' from ['+commodity_field+'] where contract='+char(39)+'" + string2 + "'+char(39)+' group by contract ' from asset_master where commodity='" + string + "'";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string3);
        String string4 = "";
        while (resultSet.next()) {
            string4 = string4 + "  " + resultSet.getString(1);
        }
        resultSet.close();
        statement.close();
        Vector<Map> vector = new Vector<Map>();
        if (!string4.equals("")) {
            PreparedStatement preparedStatement = connection.prepareStatement(string4);
            ResultSet resultSet2 = preparedStatement.executeQuery();
            while (resultSet2.next()) {
                vector.add(new BasicRowProcessor().toMap(resultSet2));
            }
            resultSet2.close();
            preparedStatement.close();
        }
        return vector;
    }

    @Override
    public Map getRawData3(String string, Connection connection, String string2, String string3) throws Exception {
        this.log.debug((Object)("commodity:" + string3 + " tablename:" + string2));
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        Vector<Map> vector = new Vector<Map>();
        PreparedStatement preparedStatement = connection.prepareStatement("select * from asset_master WHERE commodity=? AND commodity_field=?");
        preparedStatement.setString(1, string3);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT CONVERT  ( varchar(40),cdate,103 ) as cdate1,  * FROM  [" + string2 + "] WHERE contract=? AND " + string + " ORDER BY CDATE DESC");
            preparedStatement2.setString(1, string3);
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            while (resultSet2.next()) {
                vector.add(new BasicRowProcessor().toMap(resultSet2));
            }
            resultSet2.close();
            preparedStatement2.close();
            treeMap.put("tablename", string2);
            treeMap.put("data", vector);
        }
        resultSet.close();
        preparedStatement.close();
        return treeMap;
    }

    @Override
    public Map getRawData2Contract(String string, Connection connection, String string2, String string3, String string4) throws Exception {
        this.log.debug((Object)("commodity:" + string4 + " fieldanme:" + string2));
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        Vector<Map> vector = new Vector<Map>();
        PreparedStatement preparedStatement = connection.prepareStatement("select * from asset_master WHERE commodity=? AND commodity_fieldoriginal=?");
        preparedStatement.setString(1, string4);
        preparedStatement.setString(2, string2);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            String string5 = resultSet.getString("commodity_field");
            PreparedStatement preparedStatement2 = connection.prepareStatement("SELECT CONVERT  ( varchar(40),cdate,103 ) as cdate1,  * FROM  [" + string5 + "] WHERE contract=? AND " + string + " ORDER BY CDATE DESC");
            this.log.debug((Object)("query:SELECT CONVERT  ( varchar(40),cdate,103 ) as cdate1,  * FROM  [" + string5 + "] WHERE contract=? AND " + string + " ORDER BY CDATE DESC"));
            preparedStatement2.setString(1, string3);
            ResultSet resultSet2 = preparedStatement2.executeQuery();
            while (resultSet2.next()) {
                vector.add(new BasicRowProcessor().toMap(resultSet2));
            }
            resultSet2.close();
            preparedStatement2.close();
            treeMap.put("tablename", string5);
            treeMap.put("data", vector);
        }
        resultSet.close();
        preparedStatement.close();
        return treeMap;
    }

    @Override
    public void deleteRawData(Connection connection, String string, Map<String, String> map) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM [" + string + "] WHERE cdate=? AND contract=?");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Date date = new Date(simpleDateFormat.parse(map.get("cdate1")).getTime());
        preparedStatement.setDate(1, date);
        preparedStatement.setString(2, map.get("contract"));
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public void updateRawData(Connection connection, String string, Map<String, String> map, Map<String, String> map2) throws Exception {
        double d;
        String string2 = "UPDATE [" + string + "] SET cdate=?, contract=?,val=? WHERE cdate=? AND contract=?";
        String string3 = null;
        if (map2.get("sval") != null) {
            string3 = map2.get("sval");
        } else if (map.get("sval") != null) {
            string3 = map.get("sval");
        }
        if (string3 != null) {
            string2 = "UPDATE [" + string + "] SET cdate=?, contract=?,sval=? WHERE cdate=? AND contract=?";
        }
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Date date = map2.get("cdate1") != null ? new Date(simpleDateFormat.parse(map2.get("cdate1")).getTime()) : new Date(simpleDateFormat.parse(map.get("cdate1")).getTime());
        boolean bl = false;
        if (map2.get("val") != null) {
            d = Double.parseDouble(map2.get("val"));
            bl = true;
        } else {
            if (string3 == null) {
                d = Double.parseDouble(map.get("val"));
                bl = true;
            }
            d = 0.0;
        }
        Date date2 = new Date(simpleDateFormat.parse(map.get("cdate1")).getTime());
        preparedStatement.setDate(1, date);
        preparedStatement.setString(2, map2.get("contract") != null ? map2.get("contract") : map.get("contract"));
        if (bl) {
            preparedStatement.setDouble(3, d);
        } else if (string3 != null) {
            preparedStatement.setString(3, string3);
        }
        preparedStatement.setDate(4, date2);
        preparedStatement.setString(5, map.get("contract"));
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public boolean removeFieldTable(Connection connection, String string) throws Exception {
        String string2 = "DELETE FROM asset_master WHERE commodity_field='" + string + "'";
        Statement statement = connection.createStatement();
        statement.execute(string2);
        Statement statement2 = connection.createStatement();
        statement2.execute("DROP TABLE [dbo].[" + string + "]");
        statement2.close();
        statement.close();
        return true;
    }

    @Override
    public boolean renameFieldTable(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM asset_master WHERE commodity_field=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string3 = null;
        if (resultSet.next()) {
            string3 = resultSet.getString("commodity");
            string3 = HistoricalMarketData.resolvedColName(string3) + "_" + HistoricalMarketData.resolvedColName(string2);
        }
        if (string3 != null) {
            Statement statement = connection.createStatement();
            statement.executeUpdate("sp_rename '" + string + "','" + string3 + "'");
            statement.close();
            PreparedStatement preparedStatement2 = connection.prepareStatement("UPDATE asset_master SET commodity_fieldoriginal=?,commodity_field=?  WHERE commodity_field=?");
            preparedStatement2.setString(1, string2);
            preparedStatement2.setString(2, string3);
            preparedStatement2.setString(3, string);
            preparedStatement2.executeUpdate();
            preparedStatement2.close();
            return true;
        }
        return false;
    }

    @Override
    public List listFieldTables4Admin(Connection connection, String string) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("Select commodity_field,commodity_fieldoriginal from asset_master WHERE commodity='" + string + "'");
        String string2 = "";
        int n = 0;
        while (resultSet.next()) {
            if (n > 0) {
                string2 = string2 + " UNION ALL ";
            }
            ++n;
            string2 = string2 + "SELECT count(*) as recs,'" + resultSet.getString("commodity_field") + "' as tabl,'" + resultSet.getString("commodity_fieldoriginal") + "' as title FROM " + resultSet.getString("commodity_field");
        }
        statement.close();
        resultSet.close();
        Vector vector = new Vector();
        if (n > 0) {
            Statement statement2 = connection.createStatement();
            ResultSet resultSet2 = statement2.executeQuery(string2);
            while (resultSet2.next()) {
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                treeMap.put("total", resultSet2.getObject("recs"));
                treeMap.put("ftable", resultSet2.getObject("tabl"));
                treeMap.put("fname", resultSet2.getObject("title"));
                treeMap.put("commodity", string);
                vector.add(treeMap);
            }
            statement2.close();
            resultSet2.close();
        }
        return vector;
    }

    @Override
    public List listFieldTables(Connection connection, String string) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sysobjects where id = object_id('asset_master') and OBJECTPROPERTY(id, 'IsUserTable') = 1");
        Vector vector = new Vector();
        if (resultSet.next()) {
            PreparedStatement preparedStatement = connection.prepareStatement("Select * from asset_master where commodity=?");
            preparedStatement.setString(1, string);
            ResultSet resultSet2 = preparedStatement.executeQuery();
            while (resultSet2.next()) {
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put("fieldname", resultSet2.getString("commodity_fieldoriginal"));
                treeMap.put("fieldtable", resultSet2.getString("commodity_field"));
                vector.add(treeMap);
            }
            preparedStatement.close();
            resultSet2.close();
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public List listAllUniqueFields(Connection connection) throws Exception {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sysobjects where id = object_id('asset_master') and OBJECTPROPERTY(id, 'IsUserTable') = 1");
        Vector vector = new Vector();
        if (resultSet.next()) {
            Statement statement2 = connection.createStatement();
            ResultSet resultSet2 = statement2.executeQuery("select commodity_fieldoriginal,MAX(commodity),MAX(commodity_field) as commodity_field1 from asset_master group by commodity_fieldoriginal");
            while (resultSet2.next()) {
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put("fieldname", resultSet2.getString("commodity_fieldoriginal"));
                treeMap.put("fieldtable", resultSet2.getString("commodity_field1"));
                vector.add(treeMap);
            }
            statement2.close();
            resultSet2.close();
        }
        resultSet.close();
        statement.close();
        return vector;
    }

    @Override
    public List listAllUniqueFields(Connection connection, String string) throws Exception {
        Vector<Map> vector = new Vector<Map>();
        String string2 = "SELECT a.rw,commodity_field as fieldtable,b.commodity_fieldoriginal from (SELECT  [TableName] = so.name, [rw] = MAX(si.rows) FROM  sysobjects so,  sysindexes si WHERE  so.xtype = 'U'  AND  si.id = OBJECT_ID(so.name) ";
        string2 = string2 + " GROUP BY  so.name ) as a left outer join asset_master b on a.TableName=b.commodity_field where b.commodity=?";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            Map map = new BasicRowProcessor().toMap(resultSet);
            map.put("fieldname", resultSet.getString("commodity_fieldoriginal"));
            vector.add(map);
        }
        resultSet.close();
        return vector;
    }

    @Override
    public void deleteContracts(Connection connection, String string, String string2) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("delete  from  [" + string + "]  WHERE  contract=?");
        preparedStatement.setString(1, string2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public Vector getUniqueContracts(Connection connection, String string) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("select * from (select contract,count(*) recs,min(cdate) as first,max(cdate) as last  from   [" + string + "] group by contract) as outtable order by last desc");
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Map> vector = new Vector<Map>();
        while (resultSet.next()) {
            Map map = new BasicRowProcessor().toMap(resultSet);
            java.util.Date date = (java.util.Date)map.get("first");
            java.util.Date date2 = (java.util.Date)map.get("last");
            if (date != null && date2 != null) {
                String string2 = new SimpleDateFormat("dd MMM yyyy").format(date) + " - " + new SimpleDateFormat("dd MMM yyyy").format(date2);
                map.put("dates", string2);
            }
            vector.add(map);
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    @Override
    public Map listAllCommoditiesAndFields(Connection connection) throws Exception {
        TreeMap<String, Vector> treeMap = new TreeMap<String, Vector>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sysobjects where id = object_id('asset_master') and OBJECTPROPERTY(id, 'IsUserTable') = 1");
        if (resultSet.next()) {
            Statement statement2 = connection.createStatement();
            ResultSet resultSet2 = statement2.executeQuery("select * from asset_master order by commodity");
            while (resultSet2.next()) {
                Vector vector;
                String string = resultSet2.getString("commodity");
                if (treeMap.get(string) == null) {
                    vector = new Vector();
                    treeMap.put(string, vector);
                } else {
                    vector = (Vector)treeMap.get(string);
                }
                ValueObject valueObject = new ValueObject();
                valueObject.setKey(resultSet2.getString("commodity_field"));
                valueObject.setValue(resultSet2.getString("commodity_fieldoriginal"));
                vector.add(valueObject);
            }
        }
        statement.close();
        resultSet.close();
        return treeMap;
    }

    @Override
    public void LastSyncUpdate(Connection connection) throws Exception {
        String string = "IF NOT EXISTS (select * from sysobjects where id = object_id('asset_sync') and OBJECTPROPERTY(id, 'IsUserTable') = 1) ";
        string = string + "BEGIN ";
        string = string + "CREATE TABLE asset_sync ( ";
        string = string + "syncdate datetime";
        string = string + ") ";
        string = string + "END ";
        Statement statement = connection.createStatement();
        statement.execute(string);
        statement.close();
        Statement statement2 = connection.createStatement();
        statement2.executeUpdate("INSERT into asset_sync(syncdate) VALUES(getdate()) ");
        statement2.close();
    }

    @Override
    public int lastSyncDays(Connection connection, java.util.Date date) throws Exception {
        Statement statement;
        ResultSet resultSet;
        int n = -1;
        Statement statement2 = connection.createStatement();
        ResultSet resultSet2 = statement2.executeQuery("select * from sysobjects where id = object_id('asset_sync') and OBJECTPROPERTY(id, 'IsUserTable') = 1 ");
        if (resultSet2.next() && (resultSet = (statement = connection.createStatement()).executeQuery("select top 1 syncdate from asset_sync ORDER BY syncdate DESC")).next()) {
            Date date2 = resultSet.getDate("syncdate");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date2);
            n = this.daysBetween(calendar2, calendar);
        }
        resultSet2.close();
        statement2.close();
        return n;
    }

    @Override
    public java.util.Date lastSyncDate(Connection connection) throws Exception {
        Statement statement;
        ResultSet resultSet;
        java.util.Date date = null;
        Statement statement2 = connection.createStatement();
        ResultSet resultSet2 = statement2.executeQuery("select * from sysobjects where id = object_id('asset_sync') and OBJECTPROPERTY(id, 'IsUserTable') = 1 ");
        if (resultSet2.next() && (resultSet = (statement = connection.createStatement()).executeQuery("select top 1 syncdate from asset_sync ORDER BY syncdate DESC")).next()) {
            date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(resultSet.getString("syncdate"));
        }
        resultSet2.close();
        statement2.close();
        return date;
    }

    private int daysBetween(Calendar calendar, Calendar calendar2) {
        Calendar calendar3 = (Calendar)calendar.clone();
        int n = 0;
        while (calendar3.before(calendar2)) {
            calendar3.add(5, 1);
            ++n;
        }
        return n;
    }

    @Override
    public TreeMap dailyStrategyData(Connection connection, String string, String string2, String string3) throws Exception {
        String string4;
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
        String string5 = "";
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            string5 = string5 + (string5.equals("") ? "'" + (String)object + "'" : ",'" + (String)object + "'");
        }
        if (!string5.equals("")) {
            string5 = " WHERE commodity_fieldoriginal IN (" + string5 + ") ";
        }
        this.log.debug((Object)("fields1:" + string5));
        if (string != null) {
            string4 = "select 'select contract,val,sval,'+CHAR(39)+commodity+CHAR(39)+' as commodity,'+CHAR(39)+commodity_fieldoriginal+CHAR(39)+' as fieldname from '+commodity_field+' WHERE cdate='+CHAR(39)+'" + string + "'+CHAR(39)+' AND contract='+CHAR(39)+'" + string2 + "'+CHAR(39)+' union ' as q from asset_master " + string5;
        } else {
            string4 = "select 'select top 1 contract,val,sval,'+CHAR(39)+commodity+CHAR(39)+' as commodity,'+CHAR(39)+commodity_fieldoriginal+CHAR(39)+' as fieldname from '+commodity_field+' WHERE cdate=(select max(cdate) from '+commodity_field+') AND contract='+CHAR(39)+'" + string2 + "'+CHAR(39)+' union ' as q from asset_master " + string5;
            string = "";
        }
        this.log.debug((Object)string4);
        object = connection.createStatement();
        ResultSet resultSet = object.executeQuery(string4);
        String string6 = "";
        while (resultSet.next()) {
            string6 = string6 + resultSet.getString("q");
        }
        if (!string6.equals("")) {
            string6 = "select * from (" + string6 + " select null,null,null,null,null) as t  where commodity is not null order by contract,commodity";
        }
        resultSet.close();
        object.close();
        System.out.println("UtilDB.dailyStrategyData():qr:" + string6);
        TreeMap<String, TreeMap> treeMap = new TreeMap<String, TreeMap>();
        if (!string6.equals("")) {
            Statement statement = connection.createStatement();
            ResultSet resultSet2 = statement.executeQuery(string6);
            while (resultSet2.next()) {
                TreeMap treeMap2;
                String string7 = resultSet2.getString("fieldname");
                String string8 = resultSet2.getString("commodity") + "|" + resultSet2.getString("contract");
                if (treeMap.get(string7) != null) {
                    treeMap2 = (TreeMap)treeMap.get(string7);
                } else {
                    treeMap2 = new TreeMap();
                    treeMap.put(string7, treeMap2);
                }
                if (resultSet2.getObject("sval") != null) {
                    treeMap2.put(string8, resultSet2.getObject("sval"));
                    continue;
                }
                treeMap2.put(string8, resultSet2.getDouble("val"));
            }
            statement.close();
            resultSet2.close();
        }
        return treeMap;
    }

    @Override
    public TreeMap listSavedChart(Connection connection) throws Exception {
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from sysobjects where id = object_id('saved_charts') and OBJECTPROPERTY(id, 'IsUserTable') = 1");
        if (resultSet.next()) {
            Statement statement2 = connection.createStatement();
            ResultSet resultSet2 = statement2.executeQuery("select id,chartname from saved_charts");
            while (resultSet2.next()) {
                treeMap.put(resultSet2.getInt("id"), resultSet2.getString("chartname"));
            }
            statement2.close();
            resultSet2.close();
        }
        statement.close();
        resultSet.close();
        return treeMap;
    }

    @Override
    public void deleteSavedChart(Connection connection, int n) throws Exception {
        PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM saved_charts WHERE id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public Map getSavedChartItem(Connection connection, int n) throws Exception {
        String string = "SELECT * FROM saved_charts WHERE id=?";
        PreparedStatement preparedStatement = connection.prepareStatement(string);
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        TreeMap<String, String> treeMap = null;
        if (resultSet.next()) {
            treeMap = new TreeMap<String, String>();
            treeMap.put("chartname", resultSet.getString("chartname"));
            treeMap.put("datestring", resultSet.getString("datestring"));
            treeMap.put("source1", resultSet.getString("source1"));
            treeMap.put("security1", resultSet.getString("security1"));
            treeMap.put("field1", resultSet.getString("field1"));
            treeMap.put("source2", resultSet.getString("source2"));
            treeMap.put("security2", resultSet.getString("security2"));
            treeMap.put("field2", resultSet.getString("field2"));
            treeMap.put("commodity1", resultSet.getString("commodity1"));
            treeMap.put("commodity2", resultSet.getString("commodity2"));
        }
        resultSet.close();
        preparedStatement.close();
        return treeMap;
    }

    @Override
    public void savedChart(Connection connection, Map map) throws Exception {
        String string = "IF NOT EXISTS (select * from sysobjects where id = object_id('saved_charts') and OBJECTPROPERTY(id, 'IsUserTable') = 1) ";
        string = string + "BEGIN ";
        string = string + "CREATE TABLE saved_charts ( ";
        string = string + "id int IDENTITY, chartname varchar(250),datestring  varchar(250),source1 varchar(50),security1 text,field1 varchar(250),source2 varchar(50),security2 text,field2 varchar(250),commodity1 varchar(250), commodity2 varchar(250)";
        string = string + ") ";
        string = string + "END ";
        Statement statement = connection.createStatement();
        statement.execute(string);
        statement.close();
        String string2 = "INSERT INTO saved_charts(chartname,datestring,source1,security1,field1,source2,security2,field2,commodity1,commodity2) VALUES(?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        preparedStatement.setString(1, (String)map.get("chartname"));
        preparedStatement.setString(2, (String)map.get("datestring"));
        preparedStatement.setString(3, (String)map.get("source1"));
        preparedStatement.setString(4, (String)map.get("security1"));
        preparedStatement.setString(5, (String)map.get("field1"));
        preparedStatement.setString(6, (String)map.get("source2"));
        preparedStatement.setString(7, (String)map.get("security2"));
        preparedStatement.setString(8, (String)map.get("field2"));
        preparedStatement.setString(9, (String)map.get("commodity1"));
        preparedStatement.setString(10, (String)map.get("commodity2"));
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    @Override
    public ArrayList showOldConnections(int n, String string) throws Exception {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        String string2 = "SELECT SPID FROM MASTER.DBO.SYSPROCESSES WHERE  DBID != 0 AND HOSTNAME = ? and last_batch<dateadd(minute,?,getdate())  ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
        preparedStatement.setString(1, string);
        preparedStatement.setInt(2, -n);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            arrayList.add(resultSet.getInt("SPID"));
        }
        return arrayList;
    }

    @Override
    public void killConnections(List<Integer> list) throws Exception {
        Statement statement = this.connection().createStatement();
        for (Integer n : list) {
            statement.executeUpdate("kill " + n);
        }
        statement.close();
    }

    public String getListAllContractTitlesJoinQuery(List<String> list, String string) {
        String string2 = "";
        int n = 0;
        for (String string3 : list) {
            if (n > 0) {
                string2 = string2 + "\n UNION ALL ";
            }
            string2 = string2 + " select *,'" + string3 + "' as tbl_name FROM " + string3 + " " + (string != null && !string.equals("") ? "  WHERE " + string + " " : "");
            ++n;
        }
        return string2;
    }

    public String getListAllContractTitles2JoinQuery(Vector<ValueObject> vector, String string) {
        String string2 = "";
        int n = 0;
        for (ValueObject valueObject : vector) {
            if (n > 0) {
                string2 = string2 + "\n UNION ALL ";
            }
            string2 = string2 + " select *,'" + valueObject.getValue() + "' as tbl_name,contract+'." + valueObject.getValue() + "' as securities FROM " + valueObject.getValue() + (string != null && !string.equals("") ? "  WHERE " + string + " " : "");
            ++n;
        }
        return string2;
    }

    public String generateMultiSQL2JoinQuery(List<Map> list, String string, String string2) {
        String string3 = "";
        int n = 0;
        for (Map map : list) {
            if (n > 0) {
                string3 = string3 + "\n UNION ALL ";
            }
            string3 = string3 + " select cdate,contract,val,sval,'" + map.get("commodity_fieldoriginal") + "' as hdr FROM " + map.get("commodity_field") + " " + (string != null && !string.equals("") ? "  WHERE " + string + " AND contract='" + string2 + "' " : "");
            ++n;
        }
        return string3;
    }
}

