/*
 * Decompiled with CFR 0.152.
 */
package com.fe.io.server;

import com.fe.io.server.ServerConnection;
import com.fe.io.server.ServerIORequestReceive;
import com.fe.scheduler.queue.QueueStackManager;
import com.googlecode.cqengine.CQEngine;
import com.googlecode.cqengine.IndexedCollection;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.navigable.NavigableIndex;
import com.googlecode.cqengine.index.unique.UniqueIndex;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.simple.Equal;
import com.googlecode.cqengine.resultset.ResultSet;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServerConnectionHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = Logger.getLogger(ServerConnectionHandler.class);
    private static IndexedCollection<ServerConnection> connections = CQEngine.newInstance();

    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.getServerConnection(channelHandlerContext) == null) {
            log.debug((Object)"new connection adding connection pool");
            ServerConnection serverConnection = new ServerConnection(channelHandlerContext);
            serverConnection.setConnectedtime(new Date().getTime());
            connections.add((Object)serverConnection);
            log.debug((Object)"added");
        }
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object != null && object instanceof Map) {
            ServerConnection serverConnection = this.getServerConnection(channelHandlerContext);
            log.debug((Object)("received map data from ip:" + serverConnection.getIp()));
            new ServerIORequestReceive((Map)object).process(serverConnection);
        }
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.flush();
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.removeServerConnection(channelHandlerContext);
        log.debug((Object)"channel inactive and removing server connection");
        channelHandlerContext.close();
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        log.error((Object)"exceptionCaught()", throwable);
        this.removeServerConnection(channelHandlerContext);
        channelHandlerContext.close();
    }

    private ServerConnection getServerConnection(ChannelHandlerContext channelHandlerContext) throws Exception {
        Equal equal = QueryFactory.equal(ServerConnection.CHCONTEXT, (Object)channelHandlerContext);
        ResultSet resultSet = connections.retrieve((Query)equal);
        if (!resultSet.isEmpty()) {
            return (ServerConnection)resultSet.iterator().next();
        }
        return null;
    }

    private boolean removeServerConnection(ChannelHandlerContext channelHandlerContext) throws Exception {
        ServerConnection serverConnection;
        Equal equal = QueryFactory.equal(ServerConnection.CHCONTEXT, (Object)channelHandlerContext);
        ResultSet resultSet = connections.retrieve((Query)equal);
        boolean bl = false;
        if (!resultSet.isEmpty() && (serverConnection = (ServerConnection)resultSet.iterator().next()) != null && serverConnection.getUser() != null) {
            QueueStackManager.peerDisconnected(serverConnection.getUser());
            connections.remove((Object)serverConnection);
            bl = true;
        }
        return bl;
    }

    public static ServerConnection getServerConnection(String string) throws Exception {
        Equal equal = QueryFactory.equal(ServerConnection.USER, (Object)string);
        ResultSet resultSet = connections.retrieve((Query)equal);
        if (!resultSet.isEmpty()) {
            return (ServerConnection)resultSet.iterator().next();
        }
        return null;
    }

    public static Iterator<ServerConnection> getAllServerConnection() throws Exception {
        return connections.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshServerConnection(ServerConnection serverConnection) throws Exception {
        ServerConnection serverConnection2 = serverConnection;
        synchronized (serverConnection2) {
            connections.remove((Object)serverConnection);
            connections.add((Object)serverConnection);
        }
    }

    static {
        connections.addIndex((Index)NavigableIndex.onAttribute(ServerConnection.IP));
        connections.addIndex((Index)UniqueIndex.onAttribute(ServerConnection.USER));
        connections.addIndex((Index)NavigableIndex.onAttribute(ServerConnection.CONNECTEDTIME));
        connections.addIndex((Index)UniqueIndex.onAttribute(ServerConnection.CHCONTEXT));
    }
}

