/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p;

import com.fe.p2p.TestDiscoveryServer;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.discovery.DiscoveryService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeService;
import net.jxta.platform.NetworkManager;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;

public class TestDiscoveryClient
extends Thread
implements DiscoveryListener,
OutputPipeListener {
    private transient NetworkManager manager;
    private transient DiscoveryService discovery;
    private PipeService pipeService;
    private PeerGroup netPeerGroup;
    public static final String MESSAGE_NAME_SPACE = "PipeTutorial";
    private final Object lock = new Object();
    public static HashMap nodes = new HashMap();
    private static ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue();
    private String to;
    private static boolean qstarted = false;

    public TestDiscoveryClient(PeerGroup peerGroup, PipeService pipeService, String string) {
        this.netPeerGroup = peerGroup;
        this.pipeService = pipeService;
        this.to = string;
    }

    public TestDiscoveryClient() {
    }

    public static void main(String[] stringArray) {
        TestDiscoveryClient testDiscoveryClient = new TestDiscoveryClient();
    }

    @Override
    public void run() {
        long l = 60000L;
        try {
            NetworkManager networkManager = TestDiscoveryServer.manager;
            this.netPeerGroup = networkManager.getNetPeerGroup();
            this.discovery = this.netPeerGroup.getDiscoveryService();
            this.pipeService = networkManager.getNetPeerGroup().getPipeService();
            this.discovery.addDiscoveryListener((DiscoveryListener)this);
            this.discovery.getRemoteAdvertisements(null, 0, null, null, 1, null);
            while (true) {
                try {
                    System.out.println("Sleeping for :" + l);
                    Thread.sleep(l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("Sending a Discovery Message");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void outputPipeEvent(OutputPipeEvent outputPipeEvent) {
        OutputPipe outputPipe = outputPipeEvent.getOutputPipe();
        try {
            PipeAdvertisement pipeAdvertisement = outputPipe.getAdvertisement();
            System.out.println("Sending message to " + pipeAdvertisement.getID() + " pipe::" + outputPipe.getPipeID());
            Message message = new Message();
            Date date = new Date(System.currentTimeMillis());
            StringMessageElement stringMessageElement = new StringMessageElement(MESSAGE_NAME_SPACE, date.toString() + " message to:" + pipeAdvertisement.getID(), null);
            message.addMessageElement(null, (MessageElement)stringMessageElement);
            outputPipe.send(message);
            System.out.println("message sent");
            this.processQueue();
        }
        catch (IOException iOException) {
            System.out.println("failed to send message");
            iOException.printStackTrace();
            System.exit(-1);
        }
    }

    private synchronized void started(boolean bl) {
        qstarted = bl;
    }

    private synchronized void add(String string) {
        queue.add(string);
        System.out.println("added to queue:s:" + string);
        this.processQueue();
    }

    private synchronized void processQueue() {
        if (!queue.isEmpty()) {
            String string = queue.poll();
            System.out.println("processing node:" + string);
            PipeAdvertisement pipeAdvertisement = TestDiscoveryServer.getPipeAdvertisement(string, this.netPeerGroup);
            try {
                this.pipeService.createOutputPipe(pipeAdvertisement, (OutputPipeListener)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void discoveryEvent(DiscoveryEvent discoveryEvent) {
        DiscoveryResponseMsg discoveryResponseMsg = discoveryEvent.getResponse();
        Enumeration enumeration = discoveryEvent.getSearchResults();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                PeerAdvertisement peerAdvertisement = (PeerAdvertisement)enumeration.nextElement();
                PipeAdvertisement pipeAdvertisement = TestDiscoveryServer.getPipeAdvertisement(peerAdvertisement.getName(), this.netPeerGroup);
                System.out.println("Module specific id :" + peerAdvertisement.getName() + " PIPE ID:" + pipeAdvertisement.getPipeID());
                try {
                    nodes.put(pipeAdvertisement.getPipeID(), peerAdvertisement.getName());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

