/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.msg.impl;

import com.fe.p2p.msg.MessageHandler;
import com.fe.p2p.msg.PostCallBack;
import com.fe.p2p.msg.PostMessage;
import com.fe.p2p.msg.impl.ExecuteScript;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.peer.QueueFactory;
import com.fe.scheduler.rscript.RScript;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;

public class TenderScript
extends MessageHandler
implements PostCallBack {
    private String uid;
    private String taskuid;
    protected JCS cache = null;
    private String requestid = null;
    private Logger log = Logger.getLogger(TenderScript.class);
    private static long TIMEOUT_MS = 2000L;
    private static Semaphore lock = new Semaphore(1, true);

    public TenderScript() {
        this.requestid = new Date().getTime() + "-" + Thread.currentThread().getName();
    }

    public String getRequestid() {
        return this.requestid;
    }

    public void setRequestid(String string) {
        this.requestid = string;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String string) {
        this.uid = string;
    }

    public String getTaskuid() {
        return this.taskuid;
    }

    public void setTaskuid(String string) {
        this.taskuid = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map executeAtDestination() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        try {
            this.acquireLock();
            this.log.debug((Object)("getTaskuid()" + this.getTaskuid()));
            this.log.debug((Object)("getQueue():" + new QueueFactory().getQueue(this.getTaskuid())));
            this.log.debug((Object)("Excecuting threads:" + new QueueFactory().getQueue(this.getTaskuid()).getExecutingStacks()));
            this.log.debug((Object)("taskuid:" + this.getTaskuid()));
            this.log.debug((Object)("getUid():" + this.getUid()));
            this.log.debug((Object)("getCache():" + this.getCache()));
            n = 1;
            Long l = (Long)this.getCache().get((Object)this.getUid());
            n = 2;
            if (l == null || new Date().getTime() - l > 100L) {
                n = 3;
                if (new QueueFactory().getQueue(this.getTaskuid()).isRoomForThread()) {
                    n = 4;
                    hashMap.put("okStart", this.getUid());
                    n = 5;
                    IElementAttributes iElementAttributes = this.getCache().getDefaultElementAttributes();
                    iElementAttributes.setMaxLifeSeconds(1L);
                    n = 6;
                    this.getCache().put((Object)this.getUid(), (Object)new Date().getTime(), iElementAttributes);
                    n = 7;
                }
            } else {
                hashMap.put("IGNORE_CALLBACK", "");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error((Object)("Error executeAtDestination(), E:" + exception.getMessage() + " p:" + n));
        }
        finally {
            this.releaseLock();
        }
        return hashMap;
    }

    @Override
    public synchronized void callBack(Map map) {
        this.log.debug((Object)"call back tender script:");
        this.log.debug((Object)("data:" + map + " okStart:" + map.get("okStart")));
        if (map.get("okStart") != null) {
            ExecuteScript executeScript = new ExecuteScript();
            executeScript.setUid(this.getUid());
            RScript rScript = LoadBalancingQueue.getExecuteRScriptDefault().startScriptIfNotStarted(executeScript, this.getMsgCreator());
            if (rScript != null) {
                ExecuteScript executeScript2 = new ExecuteScript();
                executeScript2.setUid(rScript.getUid());
                executeScript2.setTaskuid(this.getTaskuid());
                executeScript2.setScript(rScript.getScript());
                new PostMessage(executeScript2, this.getMsgCreator()).send();
            }
            executeScript = null;
            rScript = null;
        }
    }

    protected JCS getCache() throws Exception {
        if (this.cache == null) {
            this.cache = JCS.getInstance((String)"TenderScript");
            this.log.debug((Object)("cache:" + this.cache));
        }
        this.log.debug((Object)("cache1:" + this.cache));
        return this.cache;
    }

    @Override
    public void onCallBackSendingFailed() {
        this.log.error((Object)("postcallback failed, uid:" + this.uid));
    }

    @Override
    public void onSendingFailed() {
        this.log.error((Object)("Sending failed.. script uid:" + this.uid));
    }

    private void acquireLock() throws Exception {
        lock.tryAcquire(TIMEOUT_MS, TimeUnit.MILLISECONDS);
    }

    private void releaseLock() {
        lock.release();
    }
}

