/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.peer;

import com.fe.p2p.peer.PeerMachine;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class PeerManagerHSQL {
    private Logger log = Logger.getLogger(PeerManagerHSQL.class);
    private static Connection connection = null;
    private static final Semaphore dblock = new Semaphore(1, true);
    private static long TIMEOUT_MS = 2000L;
    private static String nextLineChar = "\r\n";

    protected void acquireLock() {
        try {
            Date date = new Date();
            dblock.tryAcquire(TIMEOUT_MS, TimeUnit.MILLISECONDS);
            Date date2 = new Date();
            long l = date2.getTime() - date.getTime();
            if (l > 0L) {
                String string = PeerManagerHSQL.collectStack(Thread.getAllStackTraces().get(Thread.currentThread()));
                this.log.debug((Object)("                  Caller  time:" + l + " id:" + Thread.currentThread().getId() + "\n" + string));
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    protected void releaseLock() {
        try {
            dblock.release();
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    private static String collectStack(StackTraceElement[] stackTraceElementArray) throws Exception {
        int n;
        String string = "";
        int n2 = 0;
        for (n = 0; n < stackTraceElementArray.length; ++n) {
            if (!stackTraceElementArray[n].getClassName().startsWith("com.fe.")) continue;
            n2 = n;
        }
        n = 2;
        n2 = n2 > n ? n2 - n : 0;
        int n3 = 1;
        for (int i = n2; i < stackTraceElementArray.length; ++i) {
            if (i > n2 + n && !stackTraceElementArray[i].getClassName().startsWith("com.fe.")) continue;
            String string2 = "";
            for (int j = 0; j < n3; ++j) {
                string2 = string2 + " ";
            }
            ++n3;
            if (stackTraceElementArray[i].getClassName().startsWith("com.fe.")) {
                string2 = string2 + "->";
            }
            string = string + string2 + "" + stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + "()" + nextLineChar;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Connection getConnection() {
        if (connection == null && connection == null) {
            this.acquireLock();
            try {
                if (connection == null) {
                    this.log.debug((Object)"~~~~~~~~~getConnection(-------)~~~~~~~~~~~~~~");
                    Class.forName("org.hsqldb.jdbc.JDBCDriver");
                    String string = "jdbc:hsqldb:mem:peers";
                    connection = DriverManager.getConnection(string, "SA", "SA");
                    String string2 = this.createSchemaQuery();
                    Statement statement = connection.createStatement();
                    statement.execute(string2);
                    statement.close();
                }
            }
            catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
                this.log.debug((Object)("Table already existing, e:" + sQLSyntaxErrorException.getMessage()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.releaseLock();
            }
        }
        return connection;
    }

    private String createSchemaQuery() {
        String string = "CREATE TABLE peers(";
        string = string + " id IDENTITY,";
        string = string + " peername VARCHAR(50),";
        string = string + " executing VARCHAR(250),";
        string = string + " lastresponse DATETIME,";
        string = string + " version VARCHAR(50),";
        string = string + " num_tasks_running INT ";
        string = string + ")";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeerMachine> getOnlinePeers(int n) {
        ArrayList<PeerMachine> arrayList = new ArrayList<PeerMachine>();
        try {
            String string = "Select * from peers WHERE lastresponse>dateadd('ms',-" + n + ",LOCALTIMESTAMP)";
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                PeerMachine peerMachine = new PeerMachine();
                peerMachine.setExecuting(resultSet.getString("executing"));
                peerMachine.setPeername(resultSet.getString("peername"));
                peerMachine.setVersion(resultSet.getString("version"));
                peerMachine.setNum_tasks_running(resultSet.getInt("num_tasks_running"));
                if (resultSet.getTimestamp("lastresponse") != null) {
                    Date date = new Date(resultSet.getTimestamp("lastresponse").getTime());
                    peerMachine.setLastresponse(date);
                }
                arrayList.add(peerMachine);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            this.log.error((Object)("getOnlinePeers:" + n));
            exception.printStackTrace();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePeerResponse(String string, Map map, String string2) {
        this.acquireLock();
        try {
            ResultSet resultSet2;
            String string3 = "Select * from peers where peername=?";
            String string4 = null;
            int n = 0;
            if (map != null) {
                n = map.size();
                for (ResultSet resultSet2 : map.keySet()) {
                    string4 = string4 == null ? resultSet2 + "=" + map.get(resultSet2) : string4 + "," + resultSet2 + "=" + map.get(resultSet2);
                }
            }
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(string3);
            preparedStatement.setString(1, string);
            resultSet2 = preparedStatement.executeQuery();
            String string5 = "";
            string5 = resultSet2.next() ? "UPDATE peers SET executing=?, lastresponse=?,num_tasks_running=?, version=? WHERE peername=?" : "INSERT INTO peers(executing,lastresponse,num_tasks_running,version,peername) VALUES(?,?,?,?,?)";
            resultSet2.close();
            preparedStatement.close();
            PreparedStatement preparedStatement2 = this.getConnection().prepareStatement(string5);
            preparedStatement2.setString(1, string4);
            try {
                preparedStatement2.setTimestamp(2, new Timestamp(new Date().getTime()));
            }
            catch (Exception exception) {
                this.log.error((Object)("error, e:" + exception.getMessage()));
                preparedStatement2.setTimestamp(2, null);
            }
            preparedStatement2.setInt(3, n);
            preparedStatement2.setString(4, string2);
            preparedStatement2.setString(5, string);
            preparedStatement2.executeUpdate();
            preparedStatement2.close();
        }
        catch (Exception exception) {
            this.log.error((Object)("Executing:" + map + " Error:" + exception.getMessage()));
        }
        finally {
            this.releaseLock();
        }
    }
}

