/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler;

import com.fe.client.BBSyncMgmt;
import com.fe.data.FlexiField;
import com.fe.db.SchedulerDB;
import com.fe.scheduler.ScheduledTaskField;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.exception.SchedulerException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionException;

public abstract class ScheduledTask {
    public static String FIELD_DEPENDENCY_IDS = "dependentids";
    public static String FIELD_DEPENDENCY_CHECKTIME = "dependentchecktime";
    public static String FIELD_DEPENDENCY_SUCCESS = "onsuccess";
    public static String FIELD_DEPENDENCY_FAIL = "onfail";
    public static String FIELD_DEPENDENCY_TIMEOUT = "ontimeout";
    public static String FIELD_CONCURRENT_EXEC = "concurrent_execution";
    private String name = null;
    private String uniqueid = null;
    private Vector<ScheduledTaskField> flexifields = new Vector();
    public static String EXCECUTION_SUCCESS = "success";
    public static String EXCECUTION_FAIL = "fail";
    public static String DEPENDENCY_TIMEOUT = "dep_timeout";
    public static String EXCECUTION_OVERLAPPED = "overlapped";
    public static String EXCECUTION_WARNING = "warning";
    public static String TIMOUT_WARNING = "timeout";
    public static String TASK_QUEUED = "queued";
    public static String TASK_EVENT_CALL_EXP_ID_VARIABLE = ".caller_id";
    public static String TASK_EVENT_CALL_EXP_TRIGGERTIME_VARIABLE = ".caller_trigger_time";
    public static String TASK_EVENT_CALL_EXP_ERRORMSG_VARIABLE = ".caller_error_message";
    public static final int PEER_ASSOCIATION_HISTORY_ADDED = 1;
    public static final int PEER_ASSOCIATION_HISTORY_REMOVED = 0;
    public static final int PEER_ASSOCIATION_HISTORY_PEER_ACTIVE = 1;
    public static final int PEER_ASSOCIATION_HISTORY_PEER_NOACTIVE = 0;
    private Logger log = Logger.getLogger(ScheduledTask.class);

    public ScheduledTask(String string, String string2) {
        this.name = string;
        this.uniqueid = string2;
        this.addNameField();
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueid() {
        return this.uniqueid;
    }

    public List<ScheduledTaskField> listFormFields() {
        return this.flexifields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNameField() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ScheduledTaskField scheduledTaskField;
        Object object5;
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            object5 = schedulerDB.listOfFolders(this.getUniqueid());
            scheduledTaskField = new ScheduledTaskField();
            scheduledTaskField.setShortname("folder_id");
            scheduledTaskField.setFieldlabel("Folder");
            scheduledTaskField.setFieldtype("dropdown");
            object4 = "";
            object3 = object5.iterator();
            while (object3.hasNext()) {
                object2 = (Map)object3.next();
                object = object2.get("id") + "~" + object2.get("folder_name");
                object4 = (String)object4 + (String)(((String)object4).equals("") ? object : "|" + (String)object);
            }
            scheduledTaskField.setFieldoptions((String)object4);
            this.flexifields.add(scheduledTaskField);
        }
        catch (Exception exception) {
            this.log.error((Object)("error:" + exception.getMessage()));
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {
                this.log.error((Object)"couldn't close sdb");
            }
        }
        object5 = new ScheduledTaskField();
        ((ScheduledTaskField)object5).setShortname("name");
        ((FlexiField)object5).setFieldtype("textbox");
        ((FlexiField)object5).setFieldlabel("Name");
        scheduledTaskField = new ScheduledTaskField();
        scheduledTaskField.setShortname(FIELD_DEPENDENCY_IDS);
        scheduledTaskField.setFieldtype("textbox");
        scheduledTaskField.setFieldlabel("Dependent Task IDs");
        scheduledTaskField.setFineprint("Runs only when those were successfully executed. Multiple IDs separated by comma. For example: 243,140,245 (Leave empty if not applicable)");
        scheduledTaskField.setPlacementform("dependency");
        object4 = new ScheduledTaskField();
        ((ScheduledTaskField)object4).setShortname(FIELD_DEPENDENCY_CHECKTIME);
        ((FlexiField)object4).setFieldtype("textbox");
        ((FlexiField)object4).setFieldlabel("Dependents Recency");
        ((ScheduledTaskField)object4).setFineprint(" Recency of all dependent task in Minutes (applicable only if Dependent task IDs entered)");
        ((ScheduledTaskField)object4).setPlacementform("dependency");
        this.flexifields.add((ScheduledTaskField)object5);
        this.flexifields.add(scheduledTaskField);
        this.flexifields.add((ScheduledTaskField)object4);
        object3 = new ScheduledTaskField();
        ((ScheduledTaskField)object3).setShortname(FIELD_DEPENDENCY_SUCCESS);
        ((FlexiField)object3).setFieldtype("textarea");
        ((FlexiField)object3).setFieldlabel("On Success");
        ((ScheduledTaskField)object3).setPlacementform("events");
        this.flexifields.add((ScheduledTaskField)object3);
        object2 = new ScheduledTaskField();
        ((ScheduledTaskField)object2).setShortname(FIELD_DEPENDENCY_FAIL);
        ((FlexiField)object2).setFieldtype("textarea");
        ((FlexiField)object2).setFieldlabel("On Error/Fail");
        ((ScheduledTaskField)object2).setPlacementform("events");
        this.flexifields.add((ScheduledTaskField)object2);
        object = new ScheduledTaskField();
        ((ScheduledTaskField)object).setShortname(FIELD_DEPENDENCY_TIMEOUT);
        ((FlexiField)object).setFieldtype("textarea");
        ((FlexiField)object).setFieldlabel("On Timeout");
        ((ScheduledTaskField)object).setPlacementform("events");
        this.flexifields.add((ScheduledTaskField)object);
        ScheduledTaskField scheduledTaskField2 = new ScheduledTaskField();
        scheduledTaskField2.setShortname(FIELD_CONCURRENT_EXEC);
        scheduledTaskField2.setFieldtype("dropdown");
        scheduledTaskField2.setPlacementform("concur");
        scheduledTaskField2.setFieldlabel("Number of Concurrent Executions");
        scheduledTaskField2.setFineprint(" >1 will allow task overlapping");
        scheduledTaskField2.setFieldoptions("2|3|4|5|6|7|8|9|10");
        scheduledTaskField2.setDropdowninitial("1");
        this.flexifields.add(scheduledTaskField2);
    }

    protected void removeAllFields() {
        this.flexifields.removeAllElements();
        this.addNameField();
    }

    public void addFormFields(Collection<ScheduledTaskField> collection) throws Exception {
        for (ScheduledTaskField scheduledTaskField : collection) {
            if (!this.flexifields.contains(scheduledTaskField)) {
                this.flexifields.add(scheduledTaskField);
                continue;
            }
            throw new Exception("Shortname is unique, Duplicate shortname are not allowed, or name shortname is already reserved.");
        }
    }

    public abstract void execute(StackFrame var1) throws JobExecutionException, SchedulerException, Exception;
}

