/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler;

import com.fe.Config;
import com.fe.client.AdminMgmt;
import com.fe.p2p.P2PService;
import com.fe.scheduler.SchedulerEngine;
import com.fe.util.PasswordService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;

public class SchedulerInitServlet
extends HttpServlet {
    private Logger log = Logger.getLogger(SchedulerInitServlet.class);
    private static String serverRoot = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        try {
            serverRoot = servletConfig.getServletContext().getRealPath("");
            System.out.println("------Server Root:" + serverRoot);
            this.log.debug((Object)"p2p service started ");
            String string = Config.getString("bloomberg_synchronization");
            if (Config.getValue("load_balancing_server") != null && Config.getValue("load_balancing_server").equals(P2PService.getComputerName())) {
                new SchedulerEngine().startSchedulerQueue();
                System.out.println("------Scheduer Queue started");
                System.out.println("------WebSocket Server started..");
            }
            this.log.debug((Object)"init()");
            if (Config.getValue("load_balancing_server") == null) {
                // empty if block
            }
            this.log.debug((Object)"init()1");
            this.initAdminDefaultPwd();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error((Object)("####Error while scheduling bloomberg sync ERROR MSG:" + exception.getMessage()));
        }
    }

    private void initAdminDefaultPwd() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(AdminMgmt.DB_USER_PROPERTY_FILE));
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                Properties properties = new Properties();
                String string = PasswordService.getInstance().encrypt("admin");
                properties.setProperty("admin", string);
                properties.store(new FileOutputStream(AdminMgmt.DB_USER_PROPERTY_FILE), null);
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getAppPath() {
        if (serverRoot == null) {
            return "c:\\tomcat\\webapps\\bldb";
        }
        return serverRoot;
    }
}

