/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.balance.executeR;

import com.fe.client.ClientErrorMgmt;
import com.fe.p2p.listener.OutgoingMessageCallBack;
import com.fe.p2p.msg.PostMessage;
import com.fe.p2p.msg.impl.TenderScript;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.balance.executeR.LoadBalancingExecuteRQueue;
import com.fe.scheduler.rscript.RScript;
import com.fe.scheduler.rscript.RScriptListener;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Collections;

public class GroupQueue
implements Callable {
    private Logger log = Logger.getLogger(GroupQueue.class);
    private ConcurrentLinkedQueue<RScript> scriptQueue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<RScript> scriptQueueProcessing = new ConcurrentLinkedQueue();
    private Hashtable<String, RScriptListener> scriptQueueListener = new Hashtable();
    private ExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private Future<String> future = null;
    protected static Vector<RScript> scriptQueueVec = new Vector();
    protected JCS cache = null;
    protected JCS cacheGrouped = null;
    private String uid = null;
    private static ConcurrentHashMap<String, GroupQueue> queueInstances = new ConcurrentHashMap();
    private Vector roundRobin = new Vector();

    private GroupQueue(String string) {
        this.uid = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static GroupQueue getGroupInstance(String string) {
        ConcurrentHashMap<String, GroupQueue> concurrentHashMap = queueInstances;
        synchronized (concurrentHashMap) {
            if (queueInstances.containsKey(string)) {
                return queueInstances.get(string);
            }
            GroupQueue groupQueue = new GroupQueue(string);
            queueInstances.put(string, groupQueue);
            return groupQueue;
        }
    }

    public static Map<String, GroupQueue> getAllGroupQueues() {
        return queueInstances;
    }

    protected ConcurrentLinkedQueue<RScript> getScriptQueue() {
        return this.scriptQueue;
    }

    protected ConcurrentLinkedQueue<RScript> getScriptQueueProcessing() {
        return this.scriptQueueProcessing;
    }

    protected Hashtable<String, RScriptListener> getScriptQueueListener() {
        return this.scriptQueueListener;
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected Future<String> getFuture() {
        return this.future;
    }

    protected String getUid() {
        return this.uid;
    }

    public void start() {
        this.future = this.executorService.submit(this);
    }

    public Object call() throws Exception {
        this.log.debug((Object)"call() made");
        try {
            while (!this.scriptQueue.isEmpty()) {
                try {
                    if (!this.scriptQueue.isEmpty()) {
                        this.processScriptQueue();
                    }
                }
                catch (Exception exception) {
                    this.log.error((Object)("error while processing queue: err: " + exception.getMessage()));
                }
                Thread.sleep(5L);
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("loadbalancing queue thread terminiated: e: " + exception.getMessage()));
            exception.printStackTrace();
        }
        return "done";
    }

    private void processScriptQueue() throws Exception {
        RScript rScript = this.scriptQueue.peek();
        if (!rScript.isExecuting()) {
            this.cache = this.getCache();
            if (this.getCache().get((Object)rScript.getUid()) == null) {
                IElementAttributes iElementAttributes = this.getGroupedCache().getDefaultElementAttributes();
                iElementAttributes.setMaxLifeSeconds((long)LoadBalancingExecuteRQueue.CACHE_GROUP_EXPIRY);
                this.getGroupedCache().putInGroup((Object)rScript.getUid(), LoadBalancingExecuteRQueue.CACHE_GROUP_TIMEOUT, (Object)"timeout", iElementAttributes);
                this.scriptTimedOut(rScript);
                for (Object e : this.getGroupedCache().getGroupKeys(LoadBalancingExecuteRQueue.CACHE_GROUP_TIMEOUT)) {
                    this.getGroupedCache().getFromGroup(e, LoadBalancingExecuteRQueue.CACHE_GROUP_TIMEOUT);
                }
            } else {
                Vector<String> vector;
                Vector<Object> vector2 = LoadBalancingQueue.getExecuteRScriptDefault().getRunOnlyOn(rScript.getTaskuid());
                if (rScript.getExecuteAt() != null) {
                    vector = new Vector<String>();
                    if (vector2.contains(rScript.getExecuteAt())) {
                        vector.add(rScript.getExecuteAt());
                    }
                } else {
                    for (String string : vector2) {
                        if (this.roundRobin.contains(string)) continue;
                        this.roundRobin.add(string);
                    }
                    vector = new Vector();
                    for (String string : this.roundRobin) {
                        if (!vector2.contains(string)) continue;
                        vector.add(string);
                    }
                }
                if (vector != null && vector.size() > 0) {
                    for (String string : vector) {
                        String string2 = string + "_" + rScript.getTaskuid();
                        IElementAttributes iElementAttributes = this.cache.getDefaultElementAttributes();
                        iElementAttributes.setMaxLifeSeconds(1L);
                        Long l = (Long)this.cache.get((Object)string2);
                        if (l != null && new Date().getTime() - l <= 100L) continue;
                        TenderScript tenderScript = new TenderScript();
                        tenderScript.setPriority(OutgoingMessageCallBack.PRIORITY_LOW);
                        tenderScript.setUid(rScript.getUid());
                        tenderScript.setTaskuid(rScript.getTaskuid());
                        PostMessage postMessage = new PostMessage(tenderScript, string);
                        postMessage.send();
                        this.cache.put((Object)string2, (Object)new Date().getTime(), iElementAttributes);
                        tenderScript = null;
                        postMessage = null;
                        this.log.debug((Object)("sending to :" + string));
                    }
                }
                if (!this.roundRobin.isEmpty()) {
                    Collections.rotate((List)this.roundRobin, (int)-1);
                }
                vector2 = null;
                vector = null;
            }
        }
        rScript = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void scriptTimedOut(RScript rScript) {
        block10: {
            try {
                if (this.scriptQueueListener.get(rScript.getUid()) == null) break block10;
                RScriptListener rScriptListener = this.scriptQueueListener.get(rScript.getUid());
                try {
                    LoadBalancingExecuteRQueue loadBalancingExecuteRQueue = (LoadBalancingExecuteRQueue)LoadBalancingQueue.getExecuteRScriptDefault();
                    rScriptListener.onScriptTimedOut(rScript);
                    loadBalancingExecuteRQueue.toWSTimedout(rScript.getUid());
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Error while invoking listener");
                }
                finally {
                    this.scriptQueueListener.remove(rScript.getUid());
                }
            }
            catch (Exception exception) {
                this.log.error((Object)"Error while time out");
            }
            finally {
                this.scriptQueue.remove(rScript);
            }
        }
    }

    protected JCS getCache() throws Exception {
        if (this.cache == null) {
            this.cache = JCS.getInstance((String)"LoadBalancingQueue");
        }
        return this.cache;
    }

    public JCS getGroupedCache() throws Exception {
        if (this.cacheGrouped == null) {
            this.cacheGrouped = JCS.getInstance((String)"LoadBalancingQueueGroupped");
        }
        return this.cacheGrouped;
    }
}

